/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Clipboard {
    public Vector[] slots = new Vector[9];
    private Score theScore;

    public Clipboard(Score score) {
        this.theScore = score;
        for (int i = 0; i < 9; ++i) {
            this.slots[i] = new Vector();
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < 9; ++i) {
            if (this.slots[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public String slotToString(int slotNum) {
        if (this.slots[slotNum].isEmpty()) {
            return "EMPTY";
        }
        return String.valueOf(this.slots[slotNum].size());
    }

    public void paste(int slotNum) {
        int trackNum = ((ScoreDrawingCanvas)this.theScore.sdc).currentTrack;
        int highlightedNote = ((ScoreDrawingCanvas)this.theScore.sdc).highlightedNote;
        for (int i = 0; i < this.slots[slotNum].size(); ++i) {
            this.theScore.getTrack(trackNum).getNotes().insertElementAt(new Note((Note)this.slots[slotNum].elementAt(i)), highlightedNote + i);
            this.theScore.showDisplayable(this.theScore.sdc);
        }
    }

    public void copy(int slotNum) {
        System.out.println("copying - or deleteing :-)");
        this.slots[slotNum].removeAllElements();
        int trackNum = ((ScoreDrawingCanvas)this.theScore.sdc).currentTrack;
        int playingDt = 0;
        int remDt = 0;
        int foundSelectedNotes = 0;
        for (int noteIndex = 0; noteIndex < this.theScore.getTrack(trackNum).getSize() && foundSelectedNotes < ((ScoreDrawingCanvas)this.theScore.sdc).numSelectedNotes; ++noteIndex) {
            Note n = this.theScore.getTrack(trackNum).getNote(noteIndex);
            if (n.selected) {
                playingDt += n.getDuration();
                playingDt -= n.getDeltaTime();
                this.slots[slotNum].addElement(new Note(n));
                if (n.getDuration() > n.getDeltaTime()) {
                    remDt += n.getDuration() - n.getDeltaTime();
                } else if (remDt > 0) {
                    remDt = remDt - n.getDeltaTime() < 0 ? 0 : (remDt -= n.getDeltaTime());
                }
                ++foundSelectedNotes;
            } else if (n.getDeltaTime() > 0) {
                Note tempNote;
                if (remDt > 0) {
                    if (remDt >= n.getDeltaTime()) {
                        remDt -= n.getDeltaTime();
                        ((Note)this.slots[slotNum].elementAt(foundSelectedNotes - 1)).setDeltaTime(((Note)this.slots[slotNum].elementAt(foundSelectedNotes - 1)).getDeltaTime() + n.getDeltaTime());
                    } else {
                        ((Note)this.slots[slotNum].elementAt(foundSelectedNotes - 1)).setDeltaTime(((Note)this.slots[slotNum].elementAt(foundSelectedNotes - 1)).getDeltaTime() + remDt);
                        tempNote = new Note(n);
                        tempNote.setDeltaTime(n.getDeltaTime() - remDt);
                        this.slots[slotNum].addElement(tempNote);
                    }
                } else if (foundSelectedNotes > 0) {
                    tempNote = new Note(n);
                    tempNote.setDuration(n.getDeltaTime());
                    tempNote.setPitch((byte)0);
                    this.slots[slotNum].addElement(tempNote);
                }
            }
            if (playingDt >= 0) continue;
            Note rest = new Note(0, 0, Math.abs(playingDt), Math.abs(playingDt));
            Queue noteQueue = this.theScore.makeNoteDisplayable(rest);
            try {
                Note tempNote = (Note)noteQueue.dequeue();
                rest.setDuration(tempNote.getDuration());
                rest.setDeltaTime(tempNote.getDeltaTime());
                rest.setTieForwards(tempNote.getTieForwards());
                this.slots[slotNum].addElement(rest);
                while (!noteQueue.isEmpty()) {
                    tempNote = (Note)noteQueue.dequeue();
                    this.slots[slotNum].addElement(rest);
                }
            }
            catch (Exception ex) {
                System.out.println("doh... can't dequeue");
            }
            playingDt = 0;
        }
    }
}

