/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ColourChooser
extends Canvas {
    private Font mediumFont;
    private int mediumFontHeight;
    private int rows = 0;
    private int cols = 0;
    private int selectedSquareX = 8;
    private int selectedSquareY = 8;
    private int selectedSquareRed = 0;
    private int selectedSquareGreen = 0;
    private int selectedSquareBlue = 0;
    private int squareWidth = 5;
    private int squareHeight = 5;
    private int width = this.getWidth();
    private int height = this.getHeight();
    public String item = "Stave colour";
    public int originalRed = 200;
    public int originalGreen = 100;
    public int originalBlue = 50;
    int xMargin = 0;
    int yMargin = 0;

    public ColourChooser() {
        this.mediumFont = Font.getFont((int)64, (int)0, (int)0);
        this.mediumFontHeight = this.mediumFont.getHeight();
        this.height -= 4 * this.mediumFontHeight + 1;
        if (this.width > this.height) {
            this.cols = 32;
            this.rows = 16;
        } else {
            this.cols = 16;
            this.rows = 32;
        }
        this.squareWidth = this.width / this.cols;
        this.squareHeight = this.height / this.rows;
        this.xMargin = (this.width - this.squareWidth * this.cols) / 2;
        this.yMargin = 4 * this.mediumFontHeight + 1 + (this.height - this.squareHeight * this.rows) / 2;
        System.out.println("ColourChooser...  width " + this.width + " and height = " + this.height + " and cols  = " + this.cols + " and rows = " + this.rows + "...");
        System.out.println("squareWidth = " + this.squareWidth + " and squareHeight = " + this.squareHeight);
    }

    protected void paint(Graphics g) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(0, 0, 0);
        g.setFont(this.mediumFont);
        g.drawString(this.item, this.width / 2, 0, 1 | 0x10);
        g.drawString("Original", this.width / 4, this.mediumFontHeight, 1 | 0x10);
        g.drawString("New", this.width / 4 * 3, this.mediumFontHeight, 1 | 0x10);
        g.drawString(String.valueOf(this.originalRed) + "," + String.valueOf(this.originalGreen) + "," + String.valueOf(this.originalBlue), this.width / 4, this.mediumFontHeight * 2, 1 | 0x10);
        g.setColor(this.originalRed, this.originalGreen, this.originalBlue);
        g.fillRect(1, this.mediumFontHeight * 3, this.width / 2 - 1, this.mediumFontHeight);
        int drawRow = 0;
        int drawCol = 0;
        int drawRed = 16;
        int drawGreen = 16;
        int drawBlue = 16;
        for (drawRow = 0; drawRow < this.rows; ++drawRow) {
            for (drawCol = 0; drawCol < this.cols; ++drawCol) {
                g.setColor(drawRed, drawGreen, drawBlue);
                g.fillRect(this.xMargin + drawCol * this.squareWidth, drawRow * this.squareHeight + this.yMargin, this.squareWidth, this.squareHeight);
                if (drawCol == this.selectedSquareX && drawRow == this.selectedSquareY) {
                    g.fillRect(this.width / 2 + 1, this.mediumFontHeight * 3, this.width / 2 - 1, this.mediumFontHeight);
                    g.setStrokeStyle(1);
                    g.setColor(255, 255, 255);
                    g.drawRect(this.xMargin + drawCol * this.squareWidth, drawRow * this.squareHeight + this.yMargin, this.squareWidth - 1, this.squareHeight - 1);
                    g.setColor(0, 0, 0);
                    g.drawRect(this.xMargin + drawCol * this.squareWidth + 1, drawRow * this.squareHeight + this.yMargin + 1, this.squareWidth - 3, this.squareHeight - 3);
                    g.setStrokeStyle(0);
                    g.drawString(String.valueOf(drawRed) + "," + String.valueOf(drawGreen) + "," + String.valueOf(drawBlue), this.width / 4 * 3, this.mediumFontHeight * 2, 1 | 0x10);
                    this.selectedSquareRed = drawRed;
                    this.selectedSquareGreen = drawGreen;
                    this.selectedSquareBlue = drawBlue;
                }
                if ((drawRed += 32) <= 256) continue;
                drawRed = 16;
                if ((drawGreen += 32) <= 256) continue;
                drawGreen = 16;
                drawBlue += 32;
            }
        }
    }

    public int getSelectedSquareRed() {
        return this.selectedSquareRed;
    }

    public int getSelectedSquareGreen() {
        return this.selectedSquareGreen;
    }

    public int getSelectedSquareBlue() {
        return this.selectedSquareBlue;
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == useful.theScore.optionsCanvas.keyCodes[3] || keyCode == useful.theScore.optionsCanvas.keyCodes[12]) {
            --this.selectedSquareX;
            if (this.selectedSquareX < 0) {
                this.selectedSquareX = this.cols - 1;
            }
        } else if (keyCode == useful.theScore.optionsCanvas.keyCodes[3] || keyCode == useful.theScore.optionsCanvas.keyCodes[12]) {
            --this.selectedSquareX;
            if (this.selectedSquareX < 0) {
                this.selectedSquareX = this.cols - 1;
            }
        } else if (keyCode == useful.theScore.optionsCanvas.keyCodes[5] || keyCode == useful.theScore.optionsCanvas.keyCodes[13]) {
            ++this.selectedSquareX;
            if (this.selectedSquareX == this.cols) {
                this.selectedSquareX = 0;
            }
        } else if (keyCode == useful.theScore.optionsCanvas.keyCodes[1] || keyCode == useful.theScore.optionsCanvas.keyCodes[14]) {
            --this.selectedSquareY;
            if (this.selectedSquareY < 0) {
                this.selectedSquareY = this.rows - 1;
            }
        } else if (keyCode == useful.theScore.optionsCanvas.keyCodes[7] || keyCode == useful.theScore.optionsCanvas.keyCodes[15]) {
            ++this.selectedSquareY;
            if (this.selectedSquareY == this.rows) {
                this.selectedSquareY = 0;
            }
        } else if (keyCode == useful.theScore.optionsCanvas.keyCodes[3] || keyCode == useful.theScore.optionsCanvas.keyCodes[12]) {
            // empty if block
        }
        this.repaint();
    }
}

