/*
 * Decompiled with CFR 0.152.
 */
public class Note {
    private byte pitch;
    private byte velocity;
    private int deltaTime;
    private int duration;
    private boolean tieForwards;
    private boolean tieBackwards;
    public boolean selected = false;

    public Note() {
    }

    public Note(byte p, byte v, int dt, int du) {
        this.pitch = p;
        this.velocity = v;
        this.deltaTime = dt;
        this.duration = du;
        this.tieForwards = false;
        this.tieBackwards = false;
    }

    public Note(Note n) {
        this.pitch = n.getPitch();
        this.velocity = n.getVelocity();
        this.deltaTime = n.getDeltaTime();
        this.duration = n.getDuration();
        this.tieBackwards = n.getTieBackwards();
        this.tieForwards = n.getTieForwards();
    }

    public Note(byte p, byte v, int du) {
        this.pitch = p;
        this.velocity = v;
        this.duration = du;
    }

    public void setPitch(byte p) {
        this.pitch = p;
    }

    public byte getPitch() {
        return this.pitch;
    }

    public void setVelocity(byte v) {
        this.velocity = v;
    }

    public byte getVelocity() {
        return this.velocity;
    }

    public void setDeltaTime(int dt) {
        this.deltaTime = dt;
    }

    public int getDeltaTime() {
        return this.deltaTime;
    }

    public void setDuration(int d) {
        this.duration = d;
    }

    public int getDuration() {
        return this.duration;
    }

    public void incrementDuration(int incDu) {
        this.duration += incDu;
    }

    public void incrementDeltaTime(int incDt) {
        this.deltaTime += incDt;
    }

    public void setTieForwards(boolean tf) {
        this.tieForwards = tf;
    }

    public boolean getTieForwards() {
        return this.tieForwards;
    }

    public void setTieBackwards(boolean tb) {
        this.tieBackwards = tb;
    }

    public boolean getTieBackwards() {
        return this.tieBackwards;
    }

    public int toggleSelected(int numSelectedNotes) {
        boolean bl = this.selected = !this.selected;
        if (this.selected) {
            return ++numSelectedNotes;
        }
        return --numSelectedNotes;
    }

    public int setSelected(int numSelectedNotes) {
        if (this.selected) {
            return numSelectedNotes;
        }
        this.selected = true;
        return ++numSelectedNotes;
    }

    public int setDeselected(int numSelectedNotes) {
        if (!this.selected) {
            return numSelectedNotes;
        }
        this.selected = false;
        return --numSelectedNotes;
    }

    public String toString() {
        return "Note, pitch = " + this.pitch + " velocity = " + this.velocity + " deltaTime = " + this.deltaTime + " and duration = " + this.duration + " and tf = " + this.tieForwards + ", tb = " + this.tieBackwards + " ...";
    }
}

