/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.MIDIControl;

public class NotePlayer
implements Runnable {
    private Player mp;
    public int duration;
    public byte velocity;
    public boolean stop;
    public byte pitch;
    public byte channel;
    public byte instrument;
    public String error;
    public int threadTask = 0;

    public NotePlayer() {
        this.duration = useful.theScore.optionsCanvas.sampleNoteDuration;
        this.velocity = useful.theScore.optionsCanvas.sampleNoteVelocity;
        System.out.println("just created np... dur = " + this.duration + " and vel = " + this.velocity);
    }

    MIDIControl getMIDIControl() {
        try {
            if (this.mp == null) {
                this.mp = Manager.createPlayer((String)"device://midi");
                this.mp.prefetch();
            }
        }
        catch (Exception Ex) {
            this.error = Ex.toString();
        }
        return (MIDIControl)this.mp.getControl("javax.microedition.media.control.MIDIControl");
    }

    public void run() {
        if (this.threadTask == 0) {
            this.stop = false;
            byte startPitch = this.pitch;
            Date startTime = new Date();
            Date nowTime = new Date();
            System.out.println("startTime= " + startTime + " and now Time = " + nowTime);
            try {
                MIDIControl mc = this.getMIDIControl();
                this.error = mc.toString();
                mc.shortMidiEvent(0x90 | this.channel, (int)this.pitch, (int)this.velocity);
                while (nowTime.getTime() < startTime.getTime() + (long)this.duration && !this.stop) {
                    nowTime = new Date();
                }
                mc.shortMidiEvent(0x80 | this.channel, (int)startPitch, 127);
            }
            catch (Exception ex) {
                this.error = ex.toString();
            }
        } else if (this.threadTask == 1) {
            this.threadTask = 0;
            try {
                MIDIControl mc = this.getMIDIControl();
                mc.shortMidiEvent(0xC0 | this.channel, (int)this.instrument, 0);
            }
            catch (Exception ex) {
                this.error = this.error + ex.toString();
            }
        }
    }
}

