/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;

public class OptionsCanvas
extends Canvas {
    private String[] keypadNames = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "*", "0", "#", "Left", "Right", "Up", "Down", "OK"};
    public int[] keyCodes = new int[17];
    public int[] newKeyCodes = new int[17];
    private int mode = 0;
    private int currentKey = 0;
    public int sampleNoteDuration = 500;
    public byte sampleNoteVelocity = (byte)127;
    public byte noteSize = (byte)8;
    public byte durationIndicatorSize = (byte)8;
    public int topOfStave;
    public int version = 6;
    public RecordStore rsControls;
    public RecordStore rsOptions;
    private ByteArrayOutputStream strmBytesO;
    private DataOutputStream strmDataTypeO;
    private byte[] record;
    private ByteArrayInputStream strmBytes;
    private DataInputStream strmDataType;
    private byte[] recData;
    private ByteArrayOutputStream strmBytesO2;
    private DataOutputStream strmDataTypeO2;
    private byte[] record2;
    private ByteArrayInputStream strmBytes2;
    private DataInputStream strmDataType2;
    private byte[] recData2;
    public int playerVolume = 50;
    public int[] colourBackground = new int[3];
    public int[] colourStave = new int[3];
    public int[] colourLedgerLines = new int[3];
    public int[] colourNotes = new int[3];
    public int[] colourSelectedNotes = new int[3];
    public int[] colourHighlightedNote = new int[3];
    public int[] colourClefs = new int[3];
    public int[] colourSharps = new int[3];
    public int[] colourFlats = new int[3];
    public int[] colourNaturals = new int[3];
    public int[] colourText = new int[3];

    public OptionsCanvas() {
        try {
            this.recData = new byte[900];
            this.recData2 = new byte[90];
            this.rsOptions = RecordStore.openRecordStore((String)"ScoreOptions", (boolean)true);
            this.rsControls = RecordStore.openRecordStore((String)"ScoreControls", (boolean)true);
            this.strmBytesO = new ByteArrayOutputStream();
            this.strmDataTypeO = new DataOutputStream(this.strmBytesO);
            this.strmBytes = new ByteArrayInputStream(this.recData);
            this.strmDataType = new DataInputStream(this.strmBytes);
            this.strmBytesO2 = new ByteArrayOutputStream();
            this.strmDataTypeO2 = new DataOutputStream(this.strmBytesO2);
            this.strmBytes2 = new ByteArrayInputStream(this.recData2);
            this.strmDataType2 = new DataInputStream(this.strmBytes2);
        }
        catch (Exception ex) {
            ex.toString();
            ex.printStackTrace();
        }
    }

    public void setControls() {
        this.mode = 0;
        this.currentKey = 0;
    }

    protected void paint(Graphics g) {
        if (this.mode == 0) {
            if (this.currentKey < 17) {
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(0);
                g.drawString("Press " + this.keypadNames[this.currentKey], this.getWidth() / 2, this.getHeight() / 2, 17);
            } else {
                this.saveKeyCodes();
            }
        }
    }

    public void saveKeyCodes() {
        try {
            for (int i = 0; i < this.currentKey; ++i) {
                this.keyCodes[i] = this.newKeyCodes[i];
                this.strmDataTypeO2.writeInt(this.keyCodes[i]);
                this.strmDataTypeO2.flush();
                this.record2 = this.strmBytesO2.toByteArray();
                this.rsControls.setRecord(i + 1, this.record2, 0, this.record2.length);
                System.out.println("saving key i = " + i + " and keycode = " + this.keyCodes[i]);
            }
        }
        catch (Exception ex) {
            System.out.println("Reocrd store error saving key codes..." + ex.toString());
            ex.printStackTrace();
        }
        useful.theScore.showOptionsMenu();
    }

    protected void keyPressed(int keyCode) {
        if (this.mode == 0) {
            this.newKeyCodes[this.currentKey] = keyCode;
            ++this.currentKey;
            this.repaint();
        }
    }

    public void loadOptions() {
        try {
            if (this.rsOptions.getNumRecords() == 0) {
                System.out.println("No records found - so no controls...");
                this.resetRecordStores();
            } else {
                System.out.println("Records were found - loading..." + this.rsOptions.getNumRecords());
                this.rsOptions.getRecord(1, this.recData, 0);
                int optionsVersion = this.strmDataType.readInt();
                System.out.println("just read  optionsversion = " + optionsVersion + " and version =  " + this.version);
                if (this.version > optionsVersion) {
                    this.resetRecordStores();
                } else {
                    this.rsOptions.getRecord(2, this.recData, 0);
                    this.sampleNoteDuration = this.strmDataType.readInt();
                    System.out.println("loaded snd");
                    this.rsOptions.getRecord(3, this.recData, 0);
                    this.sampleNoteVelocity = this.strmDataType.readByte();
                    System.out.println("loaded snv" + this.sampleNoteVelocity);
                    this.rsOptions.getRecord(4, this.recData, 0);
                    this.noteSize = this.strmDataType.readByte();
                    System.out.println("loaded ns = " + this.noteSize);
                    this.rsOptions.getRecord(5, this.recData, 0);
                    this.durationIndicatorSize = this.strmDataType.readByte();
                    System.out.println("loaded dis");
                    this.rsOptions.getRecord(6, this.recData, 0);
                    this.playerVolume = this.strmDataType.readInt();
                    int recNum = 7;
                    int rgbNum = 0;
                    for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                        this.rsOptions.getRecord(recNum, this.recData, 0);
                        this.colourBackground[rgbNum] = this.strmDataType.readInt();
                        ++recNum;
                    }
                    for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                        this.rsOptions.getRecord(recNum, this.recData, 0);
                        this.colourStave[rgbNum] = this.strmDataType.readInt();
                        ++recNum;
                    }
                    for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                        this.rsOptions.getRecord(recNum, this.recData, 0);
                        this.colourLedgerLines[rgbNum] = this.strmDataType.readInt();
                        ++recNum;
                    }
                    for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                        this.rsOptions.getRecord(recNum, this.recData, 0);
                        this.colourNotes[rgbNum] = this.strmDataType.readInt();
                        ++recNum;
                    }
                    for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                        this.rsOptions.getRecord(recNum, this.recData, 0);
                        this.colourSelectedNotes[rgbNum] = this.strmDataType.readInt();
                        ++recNum;
                    }
                    for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                        this.rsOptions.getRecord(recNum, this.recData, 0);
                        this.colourHighlightedNote[rgbNum] = this.strmDataType.readInt();
                        ++recNum;
                    }
                    for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                        this.rsOptions.getRecord(recNum, this.recData, 0);
                        this.colourClefs[rgbNum] = this.strmDataType.readInt();
                        ++recNum;
                    }
                    for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                        this.rsOptions.getRecord(recNum, this.recData, 0);
                        this.colourSharps[rgbNum] = this.strmDataType.readInt();
                        ++recNum;
                    }
                    for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                        this.rsOptions.getRecord(recNum, this.recData, 0);
                        this.colourFlats[rgbNum] = this.strmDataType.readInt();
                        ++recNum;
                    }
                    for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                        this.rsOptions.getRecord(recNum, this.recData, 0);
                        this.colourNaturals[rgbNum] = this.strmDataType.readInt();
                        ++recNum;
                    }
                    for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                        this.rsOptions.getRecord(recNum, this.recData, 0);
                        this.colourText[rgbNum] = this.strmDataType.readInt();
                        ++recNum;
                    }
                    for (int i = 1; i <= 17; ++i) {
                        this.rsControls.getRecord(i, this.recData2, 0);
                        this.keyCodes[i - 1] = this.strmDataType2.readInt();
                        System.out.println("i = " + i + " and keycode = " + this.keyCodes[i - 1]);
                    }
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Reocrd store error loading..." + ex.toString());
            ex.printStackTrace();
        }
    }

    public void resetRecordStores() {
        try {
            System.out.println("resetting record stores...");
            this.rsOptions.closeRecordStore();
            RecordStore.deleteRecordStore((String)"ScoreOptions");
            this.rsOptions = RecordStore.openRecordStore((String)"ScoreOptions", (boolean)true);
            this.saveDefaultOptions();
            this.rsControls.closeRecordStore();
            RecordStore.deleteRecordStore((String)"ScoreControls");
            this.rsControls = RecordStore.openRecordStore((String)"ScoreControls", (boolean)true);
            this.saveDefaultControls();
        }
        catch (Exception ex) {
            System.out.println("Reocrd store error resetRecordStore..." + ex.toString());
            ex.printStackTrace();
        }
    }

    public void saveDefaultControls() {
        try {
            for (int i = 1; i <= 17; ++i) {
                this.strmDataTypeO2.writeInt(20);
                this.strmDataTypeO2.flush();
                this.record2 = this.strmBytesO2.toByteArray();
                this.rsControls.addRecord(this.record2, 0, this.record2.length);
                System.out.println("saving default controls i = " + i);
            }
        }
        catch (Exception ex) {
            System.out.println("Reocrd store error saving default..." + ex.toString());
            ex.printStackTrace();
        }
    }

    public void saveDefaultOptions() {
        try {
            this.strmDataTypeO.writeInt(this.version);
            this.strmDataTypeO.flush();
            this.record = this.strmBytesO.toByteArray();
            this.rsOptions.addRecord(this.record, 0, this.record.length);
            this.strmDataTypeO.writeInt(this.sampleNoteDuration);
            this.strmDataTypeO.flush();
            this.record = this.strmBytesO.toByteArray();
            this.rsOptions.addRecord(this.record, 0, this.record.length);
            this.strmDataTypeO.writeByte(this.sampleNoteVelocity);
            this.strmDataTypeO.flush();
            this.record = this.strmBytesO.toByteArray();
            this.rsOptions.addRecord(this.record, 0, this.record.length);
            this.strmDataTypeO.writeByte(this.noteSize);
            this.strmDataTypeO.flush();
            this.record = this.strmBytesO.toByteArray();
            this.rsOptions.addRecord(this.record, 0, this.record.length);
            this.strmDataTypeO.writeByte(this.durationIndicatorSize);
            this.strmDataTypeO.flush();
            this.record = this.strmBytesO.toByteArray();
            this.rsOptions.addRecord(this.record, 0, this.record.length);
            this.strmDataTypeO.writeInt(this.playerVolume);
            this.strmDataTypeO.flush();
            this.record = this.strmBytesO.toByteArray();
            this.rsOptions.addRecord(this.record, 0, this.record.length);
            this.setDefaultColours();
            int rgbNum = 0;
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourBackground[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.addRecord(this.record, 0, this.record.length);
            }
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourStave[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.addRecord(this.record, 0, this.record.length);
            }
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourLedgerLines[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.addRecord(this.record, 0, this.record.length);
            }
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourNotes[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.addRecord(this.record, 0, this.record.length);
            }
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourSelectedNotes[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.addRecord(this.record, 0, this.record.length);
            }
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourHighlightedNote[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.addRecord(this.record, 0, this.record.length);
            }
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourClefs[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.addRecord(this.record, 0, this.record.length);
            }
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourSharps[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.addRecord(this.record, 0, this.record.length);
            }
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourFlats[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.addRecord(this.record, 0, this.record.length);
            }
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourNaturals[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.addRecord(this.record, 0, this.record.length);
            }
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourText[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.addRecord(this.record, 0, this.record.length);
            }
        }
        catch (Exception ex) {
            System.out.println("Reocrd store error loading..." + ex.toString());
            ex.printStackTrace();
        }
    }

    public void setDefaultColours() {
        this.colourBackground[0] = 240;
        this.colourBackground[1] = 240;
        this.colourBackground[2] = 240;
        this.colourStave[0] = 16;
        this.colourStave[1] = 16;
        this.colourStave[2] = 16;
        this.colourLedgerLines[0] = 16;
        this.colourLedgerLines[1] = 16;
        this.colourLedgerLines[2] = 16;
        this.colourNotes[0] = 16;
        this.colourNotes[1] = 16;
        this.colourNotes[2] = 16;
        this.colourSelectedNotes[0] = 16;
        this.colourSelectedNotes[1] = 240;
        this.colourSelectedNotes[2] = 16;
        this.colourHighlightedNote[0] = 16;
        this.colourHighlightedNote[1] = 16;
        this.colourHighlightedNote[2] = 240;
        this.colourClefs[0] = 16;
        this.colourClefs[1] = 16;
        this.colourClefs[2] = 16;
        this.colourSharps[0] = 16;
        this.colourSharps[1] = 16;
        this.colourSharps[2] = 16;
        this.colourFlats[0] = 16;
        this.colourFlats[1] = 16;
        this.colourFlats[2] = 16;
        this.colourNaturals[0] = 16;
        this.colourNaturals[1] = 16;
        this.colourNaturals[2] = 16;
        this.colourText[0] = 16;
        this.colourText[1] = 16;
        this.colourText[2] = 16;
    }

    public void saveOptions() {
        System.out.println("saving sample note...");
        try {
            this.strmDataTypeO.writeInt(this.version);
            this.strmDataTypeO.flush();
            this.record = this.strmBytesO.toByteArray();
            this.rsOptions.setRecord(1, this.record, 0, this.record.length);
            this.strmDataTypeO.writeInt(this.sampleNoteDuration);
            this.strmDataTypeO.flush();
            this.record = this.strmBytesO.toByteArray();
            this.rsOptions.setRecord(2, this.record, 0, this.record.length);
            this.strmDataTypeO.writeByte(this.sampleNoteVelocity);
            this.strmDataTypeO.flush();
            this.record = this.strmBytesO.toByteArray();
            this.rsOptions.setRecord(3, this.record, 0, this.record.length);
            this.strmDataTypeO.writeByte(this.noteSize);
            this.strmDataTypeO.flush();
            this.record = this.strmBytesO.toByteArray();
            this.rsOptions.setRecord(4, this.record, 0, this.record.length);
            this.strmDataTypeO.writeByte(this.durationIndicatorSize);
            this.strmDataTypeO.flush();
            this.record = this.strmBytesO.toByteArray();
            this.rsOptions.setRecord(5, this.record, 0, this.record.length);
            this.strmDataTypeO.writeInt(this.playerVolume);
            this.strmDataTypeO.flush();
            this.record = this.strmBytesO.toByteArray();
            this.rsOptions.setRecord(6, this.record, 0, this.record.length);
            int rgbNum = 0;
            int recNum = 7;
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourBackground[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.setRecord(recNum, this.record, 0, this.record.length);
                ++recNum;
            }
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourStave[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.setRecord(recNum, this.record, 0, this.record.length);
                ++recNum;
            }
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourLedgerLines[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.setRecord(recNum, this.record, 0, this.record.length);
                ++recNum;
            }
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourNotes[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.setRecord(recNum, this.record, 0, this.record.length);
                ++recNum;
            }
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourSelectedNotes[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.setRecord(recNum, this.record, 0, this.record.length);
                ++recNum;
            }
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourHighlightedNote[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.setRecord(recNum, this.record, 0, this.record.length);
                ++recNum;
            }
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourClefs[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.setRecord(recNum, this.record, 0, this.record.length);
                ++recNum;
            }
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourSharps[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.setRecord(recNum, this.record, 0, this.record.length);
                ++recNum;
            }
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourFlats[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.setRecord(recNum, this.record, 0, this.record.length);
                ++recNum;
            }
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourNaturals[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.setRecord(recNum, this.record, 0, this.record.length);
                ++recNum;
            }
            for (rgbNum = 0; rgbNum <= 2; ++rgbNum) {
                this.strmDataTypeO.writeInt(this.colourText[rgbNum]);
                this.strmDataTypeO.flush();
                this.record = this.strmBytesO.toByteArray();
                this.rsOptions.setRecord(recNum, this.record, 0, this.record.length);
                ++recNum;
            }
        }
        catch (Exception ex) {
            System.out.println("error saving..." + ex.toString());
            ex.printStackTrace();
        }
    }
}

