/*
 * Decompiled with CFR 0.152.
 */
import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class Score
extends MIDlet
implements CommandListener,
Runnable {
    public TempoTrack tempoTrack;
    public KeySigHandler keySigHandler;
    public Vector tracks;
    public MidiHandler mh;
    private String scoreName;
    private int ticksPerCrotchet;
    private int[] drawableNotes;
    private List fileMenu;
    private List scoreMenu;
    private List optionsMenu;
    private List coloursMenu;
    private List trackListMenu;
    private List singleTrackMenu;
    private List metaEventMenu;
    public List metaEventList;
    public List singleMetaEventMenu;
    public List fileList;
    private List sharpsFlatsMenu;
    private List majorMinorMenu;
    private List instrumentGroupsList;
    private List instrumentList;
    private List clefList;
    private Command okCommand;
    private Command backCommand;
    public Displayable sdc;
    private Alert sureAlert;
    private Alert errorAlert;
    private TextBox txtNumber;
    private TextBox txtName;
    private int fileAction;
    private int nameAction;
    private int txtNumberAction;
    private int sureAlertAction;
    private int trackNum;
    public int metaEventMenuAction;
    private int metaEventTask;
    public String[] instrumentNames;
    private String[] instrumentGroups;
    public String path;
    private int threadTask;
    public String fileName;
    private TempoEvent editTempoEvent;
    private KeySigEvent editKeySigEvent;
    private TimeSigEvent editTimeSigEvent;
    private int editBars;
    private int editBeats;
    private int editTicks;
    public TimeSigEvent timeSigAtEditME;
    int dtAtEditME;
    private int maxTranspose;
    private int correctRootCollectiveMaximum;
    private int collectiveMaximum;
    private int transposeMethod;
    private Alert transposeAlert;
    private int playStopIndex;
    public Clipboard clipboard;
    public int[] markers;
    public OptionsCanvas optionsCanvas;
    public KeyPadCanvas keyPadCanvas;
    public ColourChooser colourChooser;

    public void startApp() {
        this.path = "";
        useful.theScore = this;
        this.ticksPerCrotchet = 120;
        this.drawableNotes = new int[11];
        this.setDrawableNotes();
        this.scoreName = "my song";
        this.tempoTrack = new TempoTrack(this);
        this.keySigHandler = new KeySigHandler();
        this.tracks = new Vector();
        this.optionsCanvas = new OptionsCanvas();
        this.optionsCanvas.loadOptions();
        this.colourChooser = new ColourChooser();
        this.mh = new MidiHandler(this);
        this.clipboard = new Clipboard(this);
        this.markers = new int[9];
        for (int i = 0; i < 9; ++i) {
            this.markers[i] = 1;
        }
        this.keyPadCanvas = new KeyPadCanvas();
        System.out.println("hello...");
        this.instrumentGroups = new String[]{"Piano", "Vibes", "Organ", "Guitar", "Bass", "Violin", "Strings", "Brass", "Reed", "Woodwind", "Synth lead", "Synth pad", "Synth FX", "Ethnic", "Percussion", "Sound FX"};
        this.instrumentNames = new String[]{"Acoustic Grand Piano", "Bright Acoustic Piano", "Electric Grand Piano", "Honky Tonk Piano", "Elec Piano 1", "Elec Piano 2", "Harpsichord", "Clavichord", "Celesta", "Glokenspiel", "Music box", "Vibraphone", "Marimba", "Xylophone", "Tubular Bells", "Dulcimer", "Drawbar Organ", "Percussive Organ", "Rock Organ", "Church Organ", "Reed Organ", "Accordion", "Harmonica", "Tango Accordion", "Acc Guitar(Nylon)", "Acc Guitar(Clean)", "Elec Guitar (Jazz)", "Elec Guitar (Clean)", "Electric Guitar (Muted)", "Overdriven Guitar", "Distortion Guitar", "Guitar Harmonics", "Acoustic Bass", "Electric Bass(Finger)", "Electric Bass(Pick)", "Fretless Bass", "Slap Bass 1", "Slap Bass 2", "Synth Bass 1", "Synth Bass 2", "Violin", "Viola", "Cello", "Contra Bass", "Tremolo Strings", "Pizzicato Strings", "Orchestral Harp", "Timpani", "Strings 1", "Strings 2", "Synth Strings 1", "Synth Strings 2", "Choir Aahs", "Choir Oohs", "Synth Voice", "Orchestral Hit", "Trumpet", "Trombone", "Tuba", "Muted Trumpet", "French Horn", "Brass Section", "Synth Brass 1", "Synth Brass 2", "Soprano Sax", "Alto Sax", "Tenor Sax", "Baritone Sax", "Oboe", "English Horn", "Bassoon", "Clarinet", "Piccolo", "Flute", "Recorder", "Pan Flute", "Blown Bottle", "Shakuhachi", "Whistle", "Ocarina", "Square Wave", "Sawtooth", "Calliope", "Chiffer", "Charang", "Voice", "Fifth", "Bass", "New Age", "Warm", "Polysynth", "Choir", "Bowed", "Metallic", "Halo", "Sweep", "Rain", "Soundtrack", "Crystal", "Atmosphere", "Brightness", "Goblins", "Echoes", "Sci-Fi", "Sitar", "Banjo", "Shamisen", "Koto", "Kalimba", "Bagpipe", "Fiddle", "Shanai", "Tinkle Bell", "Agogo", "Steel Drums", "Woodblock", "Taiko Drum", "Melodic Drum", "Synth Drum", "Reverse Cymbal", "Fret Noise", "Breath Noise", "Seashore", "Bird Tweet", "Telephone Ring", "Helicopter", "Applause", "Gunshot"};
        this.okCommand = new Command("OK", 4, 0);
        this.backCommand = new Command("Back", 2, 0);
        Command addCommand = new Command("Add", 4, 1);
        Command editCommand = new Command("Edit", 4, 1);
        Command deleteCommand = new Command("Delete", 4, 1);
        this.optionsCanvas.addCommand(this.okCommand);
        this.optionsCanvas.addCommand(this.backCommand);
        this.optionsCanvas.setCommandListener(this);
        this.colourChooser.addCommand(this.okCommand);
        this.colourChooser.addCommand(this.backCommand);
        this.colourChooser.setCommandListener(this);
        String[] tracksList = new String[]{"empty"};
        this.trackListMenu = new List("Tracks list", 3, tracksList, null);
        this.trackListMenu.setSelectCommand(this.okCommand);
        this.trackListMenu.addCommand(this.backCommand);
        this.trackListMenu.setCommandListener((CommandListener)this);
        String[] keysElements = new String[]{"7 flats", "6 flats", "5 flats", "4 flats", "3 flats", "2 flats", "1 flat", "No sharps", "1 sharp", "2 sharps", "3 sharps", "4 sharps", "5 sharps", "6 sharps", "7 sharps"};
        this.sharpsFlatsMenu = new List("Sharps / flats", 3, keysElements, null);
        this.sharpsFlatsMenu.setSelectCommand(this.okCommand);
        this.sharpsFlatsMenu.addCommand(this.backCommand);
        this.sharpsFlatsMenu.setCommandListener((CommandListener)this);
        String[] majorMinorElements = new String[]{"Major", "Minor"};
        this.majorMinorMenu = new List("Key - Major / Minor", 3, majorMinorElements, null);
        this.majorMinorMenu.setSelectCommand(this.okCommand);
        this.majorMinorMenu.addCommand(this.backCommand);
        this.majorMinorMenu.setCommandListener((CommandListener)this);
        String[] singleTrackMenuElements = new String[]{"Go to stave", "Rename", "Set channel", "Set instrument", "Set clef", "Copy track", "Transpose", "Remove track"};
        this.singleTrackMenu = new List("Track", 3, singleTrackMenuElements, null);
        this.singleTrackMenu.setSelectCommand(this.okCommand);
        this.singleTrackMenu.addCommand(this.backCommand);
        this.singleTrackMenu.setCommandListener((CommandListener)this);
        String[] clefListElements = new String[]{"Treble clef", "Bass clef", "Alto clef", "Tenor clef"};
        this.clefList = new List("Select clef", 3, clefListElements, null);
        this.clefList.setSelectCommand(this.okCommand);
        this.clefList.addCommand(this.backCommand);
        this.clefList.setCommandListener((CommandListener)this);
        String[] fileMenuElements = new String[]{"New Score", "Load from file", "Load from RS", "Save to file", "Save to RS", "Delete file", "Delete from RS", "Options", "Exit"};
        this.fileMenu = new List("File menu", 3, fileMenuElements, null);
        this.fileMenu.setSelectCommand(this.okCommand);
        this.fileMenu.addCommand(this.backCommand);
        this.fileMenu.setCommandListener((CommandListener)this);
        String[] optionsMenuElements = new String[]{"Pixels in note head", "Duration indicator size", "Sample duration (ms)", "Sample velocity", "Player volume (0 - 100)", "Colours", "Set controls"};
        this.optionsMenu = new List("Options menu", 3, optionsMenuElements, null);
        this.optionsMenu.setSelectCommand(this.okCommand);
        this.optionsMenu.addCommand(this.backCommand);
        this.optionsMenu.setCommandListener((CommandListener)this);
        String[] coloursMenuElements = new String[]{"Background", "Stave", "Ledger lines", "Notes", "Selected notes", "Highlighted note", "Clefs", "Sharps", "Flats", "Naturals", "Text"};
        this.coloursMenu = new List("Colours menu", 3, coloursMenuElements, null);
        this.coloursMenu.setSelectCommand(this.okCommand);
        this.coloursMenu.addCommand(this.backCommand);
        this.coloursMenu.setCommandListener((CommandListener)this);
        String[] fileListElements = new String[]{"Empty"};
        this.fileList = new List("Files", 3, fileListElements, null);
        this.fileList.setSelectCommand(this.okCommand);
        this.fileList.addCommand(this.backCommand);
        this.fileList.setCommandListener((CommandListener)this);
        String[] instrumentsListElements = new String[]{"Empty"};
        this.instrumentGroupsList = new List("Instruments", 3, instrumentsListElements, null);
        this.instrumentGroupsList.setSelectCommand(this.okCommand);
        this.instrumentGroupsList.addCommand(this.backCommand);
        this.instrumentGroupsList.setCommandListener((CommandListener)this);
        this.instrumentList = new List("Instruments", 3, instrumentsListElements, null);
        this.instrumentList.setTitle("Instruments");
        this.instrumentList.setSelectCommand(this.okCommand);
        this.instrumentList.addCommand(this.backCommand);
        this.instrumentList.setCommandListener((CommandListener)this);
        this.txtNumber = new TextBox("Note size", "0", 4, 2);
        this.txtNumber.addCommand(this.okCommand);
        this.txtNumber.addCommand(this.backCommand);
        this.txtNumber.setCommandListener((CommandListener)this);
        this.txtName = new TextBox("Name", "", 300, 0);
        this.txtName.addCommand(this.okCommand);
        this.txtName.addCommand(this.backCommand);
        this.txtName.setCommandListener((CommandListener)this);
        String[] metaEventMenuElements = new String[]{"Time signatures", "Key signatures", "Tempos"};
        this.metaEventMenu = new List("Meta events", 3, metaEventMenuElements, null);
        this.metaEventMenu.setSelectCommand(this.okCommand);
        this.metaEventMenu.addCommand(this.backCommand);
        this.metaEventMenu.setCommandListener((CommandListener)this);
        String[] empty = new String[]{"empty"};
        this.singleMetaEventMenu = new List("Meta event", 3, empty, null);
        this.singleMetaEventMenu.setSelectCommand(this.okCommand);
        this.singleMetaEventMenu.addCommand(this.backCommand);
        this.singleMetaEventMenu.setCommandListener((CommandListener)this);
        this.metaEventList = new List("events", 3, metaEventMenuElements, null);
        this.metaEventList.setSelectCommand(editCommand);
        this.metaEventList.addCommand(addCommand);
        this.metaEventList.addCommand(deleteCommand);
        this.metaEventList.addCommand(this.backCommand);
        this.metaEventList.setCommandListener((CommandListener)this);
        String[] scoreMenuElements = new String[]{"Score name", "Meta Events", "Tidy up", "Tracks", "Add rests at end", "Play"};
        this.playStopIndex = 5;
        this.scoreMenu = new List("Score menu", 3, scoreMenuElements, null);
        this.scoreMenu.setSelectCommand(this.okCommand);
        this.scoreMenu.addCommand(this.backCommand);
        this.scoreMenu.setCommandListener((CommandListener)this);
        this.sureAlert = new Alert("Exit?", "www.marchantpeter.co.uk", null, AlertType.CONFIRMATION);
        this.sureAlert.addCommand(this.okCommand);
        this.sureAlert.addCommand(this.backCommand);
        this.sureAlert.setCommandListener((CommandListener)this);
        this.errorAlert = new Alert("Error");
        this.errorAlert.setTimeout(4000);
        this.errorAlert.setType(AlertType.ERROR);
        this.sdc = new ScoreDrawingCanvas(this);
        Command scoreCommand = new Command("Score", 4, 1);
        Command fileCommand = new Command("File", 3, 1);
        Command saveCommand = new Command("Save", 1, 0);
        Command cancelCommand = new Command("Cancel", 4, 1);
        this.sdc.addCommand(scoreCommand);
        this.sdc.addCommand(fileCommand);
        this.sdc.setCommandListener((CommandListener)this);
        this.newScore();
        Display.getDisplay((MIDlet)this).setCurrent(this.sdc);
    }

    public void showDisplayable(Displayable d) {
        Display.getDisplay((MIDlet)this).setCurrent(d);
    }

    public void commandAction(Command c, Displayable s) {
        if (s.equals((Object)this.optionsCanvas)) {
            if (c.getLabel().equals("Back")) {
                System.out.println("back - dont save controls...");
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.optionsMenu);
            } else if (c.getLabel().equals("OK")) {
                this.optionsCanvas.saveKeyCodes();
                System.out.println("do save controls...");
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.optionsMenu);
            }
        } else if (s.equals(this.sdc)) {
            if (c.getLabel().equals("Score")) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.scoreMenu);
            } else if (c.getLabel().equals("File")) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fileMenu);
            }
        } else if (s.equals(this.scoreMenu)) {
            System.out.println("in score menu");
            if (c.getLabel().equals("Back")) {
                System.out.println("in back...");
                Display.getDisplay((MIDlet)this).setCurrent(this.sdc);
            } else if (this.scoreMenu.getString(this.scoreMenu.getSelectedIndex()).equals("Score name")) {
                this.nameAction = 1;
                this.txtName.setString(this.scoreName);
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.txtName);
            } else if (this.scoreMenu.getString(this.scoreMenu.getSelectedIndex()).equals("Tidy up")) {
                this.mh.tidyUp();
                Display.getDisplay((MIDlet)this).setCurrent(this.sdc);
            } else if (this.scoreMenu.getString(this.scoreMenu.getSelectedIndex()).equals("Tracks")) {
                this.populateTrackList();
            } else if (this.scoreMenu.getString(this.scoreMenu.getSelectedIndex()).equals("Meta Events")) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.metaEventMenu);
            } else if (this.scoreMenu.getString(this.scoreMenu.getSelectedIndex()).equals("Add rests at end")) {
                for (int tn = 0; tn < this.tracks.size(); ++tn) {
                    Track t = this.getTrack(tn);
                    for (int i = 0; i < 100; ++i) {
                        t.addNote(new Note(0, 127, this.ticksPerCrotchet / 2, this.ticksPerCrotchet / 2));
                    }
                }
                Display.getDisplay((MIDlet)this).setCurrent(this.sdc);
            } else if (this.scoreMenu.getString(this.scoreMenu.getSelectedIndex()).equals("Play") || this.scoreMenu.getString(this.scoreMenu.getSelectedIndex()).equals("Stop")) {
                ((ScoreDrawingCanvas)this.sdc).np.stop = true;
                if (!this.mh.play()) {
                    ((ScoreDrawingCanvas)this.sdc).np.threadTask = 1;
                    Thread npSetInstrumentThread = new Thread(((ScoreDrawingCanvas)this.sdc).np);
                    npSetInstrumentThread.start();
                    this.removeStop();
                    ((ScoreDrawingCanvas)this.sdc).stopScrolling();
                } else {
                    this.scoreMenu.delete(this.playStopIndex);
                    this.scoreMenu.insert(this.playStopIndex, "Stop", null);
                    ((ScoreDrawingCanvas)this.sdc).startScrolling();
                }
                this.scoreMenu.setSelectedIndex(this.playStopIndex, true);
                Display.getDisplay((MIDlet)this).setCurrent(this.sdc);
            }
        } else if (s.equals(this.trackListMenu)) {
            if (c.getLabel().equals("Back")) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.scoreMenu);
            } else if (this.trackListMenu.getSelectedIndex() == 0) {
                this.addNewTrack();
                this.getTrack(this.tracks.size() - 1).setChannel((byte)this.getFirstUnusedChannel());
                this.populateTrackList();
            } else {
                this.trackNum = this.trackListMenu.getSelectedIndex() - 1;
                this.singleTrackMenu.setTitle("Track " + this.trackListMenu.getString(this.trackListMenu.getSelectedIndex()));
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleTrackMenu);
            }
        } else if (s.equals(this.metaEventMenu)) {
            if (c.getLabel().equals("Back")) {
                System.out.println("sel index = " + this.metaEventMenu.getSelectedIndex());
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.scoreMenu);
            } else if (this.metaEventMenu.getString(this.metaEventMenu.getSelectedIndex()).equals("Time signatures")) {
                this.metaEventMenuAction = 88;
                this.metaEventList.setTitle("Time signatures");
                this.tempoTrack.populateMetaEventList();
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.metaEventList);
            } else if (this.metaEventMenu.getString(this.metaEventMenu.getSelectedIndex()).equals("Key signatures")) {
                this.metaEventMenuAction = 89;
                this.metaEventList.setTitle("Key signatures");
                this.tempoTrack.populateMetaEventList();
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.metaEventList);
            } else if (this.metaEventMenu.getString(this.metaEventMenu.getSelectedIndex()).equals("Tempos")) {
                this.metaEventMenuAction = 81;
                this.metaEventList.setTitle("Tempos");
                this.tempoTrack.populateMetaEventList();
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.metaEventList);
            }
        } else if (s.equals(this.metaEventList)) {
            if (c.getLabel().equals("Back")) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.metaEventMenu);
            } else if (c.getLabel().equals("Add")) {
                this.metaEventTask = 0;
                this.singleMetaEventMenu.deleteAll();
                this.singleMetaEventMenu.append("Accept", null);
                this.singleMetaEventMenu.append("Bar", null);
                this.editBars = this.tempoTrack.getBarNumber();
                this.editBeats = 1;
                this.editTicks = 0;
                if (this.metaEventMenuAction == 81) {
                    this.singleMetaEventMenu.setTitle("Add tempo");
                    this.singleMetaEventMenu.append("Beat", null);
                    this.singleMetaEventMenu.append("Ticks", null);
                    this.singleMetaEventMenu.append("Set BPM", null);
                    this.editTempoEvent = new TempoEvent();
                } else if (this.metaEventMenuAction == 88) {
                    this.singleMetaEventMenu.setTitle("Add time signature");
                    this.singleMetaEventMenu.append("Set Numerator", null);
                    this.singleMetaEventMenu.append("Set Denominator", null);
                    this.editTimeSigEvent = new TimeSigEvent(4, 2);
                } else if (this.metaEventMenuAction == 89) {
                    this.singleMetaEventMenu.setTitle("Add key signature");
                    this.singleMetaEventMenu.append("Set sharps / flats", null);
                    this.singleMetaEventMenu.append("Set Major / minor", null);
                    this.editKeySigEvent = new KeySigEvent(0, 0);
                }
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleMetaEventMenu);
            } else if (c.getLabel().equals("Edit")) {
                this.metaEventTask = 1;
                this.singleMetaEventMenu.deleteAll();
                this.singleMetaEventMenu.append("Accept", null);
                if (this.metaEventMenuAction == 81) {
                    this.singleMetaEventMenu.setTitle("Edit tempo");
                    this.singleMetaEventMenu.append("Set BPM", null);
                    this.editTempoEvent = new TempoEvent();
                    this.editTempoEvent.setBPM(this.tempoTrack.getTempo(this.metaEventList.getSelectedIndex()).getBPM());
                } else if (this.metaEventMenuAction == 88) {
                    this.singleMetaEventMenu.setTitle("Edit time signature");
                    this.singleMetaEventMenu.append("Set Numerator", null);
                    this.singleMetaEventMenu.append("Set Denominator", null);
                    this.editTimeSigEvent = new TimeSigEvent(4, 2);
                    this.editTimeSigEvent.setNumerator((byte)this.tempoTrack.getTimeSig(this.metaEventList.getSelectedIndex()).getNumerator());
                    this.editTimeSigEvent.setDenominator((byte)this.tempoTrack.getTimeSig(this.metaEventList.getSelectedIndex()).getDenominator());
                } else if (this.metaEventMenuAction == 89) {
                    this.singleMetaEventMenu.setTitle("Edit key signature");
                    this.singleMetaEventMenu.append("Set sharps / flats", null);
                    this.singleMetaEventMenu.append("Set Major / minor", null);
                    this.editKeySigEvent = new KeySigEvent(0, 0);
                    this.editKeySigEvent.setSf(this.tempoTrack.getKeySig(this.metaEventList.getSelectedIndex()).getSf());
                    this.editKeySigEvent.setMinor(this.tempoTrack.getKeySig(this.metaEventList.getSelectedIndex()).getMinor());
                }
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleMetaEventMenu);
            } else if (c.getLabel().equals("Delete")) {
                if (this.metaEventList.getSelectedIndex() == 0) {
                    this.errorAlert.setString("Error - cannot delete the first event...");
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.errorAlert);
                } else {
                    this.tempoTrack.deleteMetaEvent();
                    this.tempoTrack.populateMetaEventList();
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.metaEventList);
                }
            }
        } else if (s.equals(this.singleMetaEventMenu)) {
            if (c.getLabel().equals("Back")) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.metaEventList);
            } else if (this.singleMetaEventMenu.getString(this.singleMetaEventMenu.getSelectedIndex()).equals("Bar")) {
                this.txtNumberAction = 2;
                this.txtNumber.setTitle("Bar");
                this.txtNumber.setString(String.valueOf(this.editBars));
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.txtNumber);
            } else if (this.singleMetaEventMenu.getString(this.singleMetaEventMenu.getSelectedIndex()).equals("Beat")) {
                this.txtNumberAction = 2;
                this.txtNumber.setTitle("Beat");
                this.txtNumber.setString(String.valueOf(this.editBeats));
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.txtNumber);
            } else if (this.singleMetaEventMenu.getString(this.singleMetaEventMenu.getSelectedIndex()).equals("Ticks")) {
                this.txtNumberAction = 2;
                this.txtNumber.setTitle("Ticks");
                this.txtNumber.setString(String.valueOf(this.editTicks));
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.txtNumber);
            } else if (this.singleMetaEventMenu.getString(this.singleMetaEventMenu.getSelectedIndex()).equals("Set BPM")) {
                this.txtNumberAction = 2;
                this.txtNumber.setTitle("Set BPM");
                this.txtNumber.setString(String.valueOf(this.editTempoEvent.getBPM()));
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.txtNumber);
            } else if (this.singleMetaEventMenu.getString(this.singleMetaEventMenu.getSelectedIndex()).equals("Set Numerator")) {
                this.txtNumberAction = 2;
                this.txtNumber.setTitle("Set Numerator");
                this.txtNumber.setString(String.valueOf(this.editTimeSigEvent.getNumerator()));
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.txtNumber);
            } else if (this.singleMetaEventMenu.getString(this.singleMetaEventMenu.getSelectedIndex()).equals("Set Denominator")) {
                this.txtNumberAction = 2;
                this.txtNumber.setTitle("Set Denominator");
                this.txtNumber.setString(String.valueOf(this.editTimeSigEvent.getDenominator()));
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.txtNumber);
            } else if (this.singleMetaEventMenu.getString(this.singleMetaEventMenu.getSelectedIndex()).equals("Set sharps / flats")) {
                this.sharpsFlatsMenu.setSelectedIndex(7 + this.editKeySigEvent.getSf(), true);
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.sharpsFlatsMenu);
            } else if (this.singleMetaEventMenu.getString(this.singleMetaEventMenu.getSelectedIndex()).equals("Set Major / minor")) {
                System.out.println("sf = " + this.editKeySigEvent.getSf());
                this.majorMinorMenu.setSelectedIndex((int)this.editKeySigEvent.getMinor(), true);
                System.out.println("MAJOR/MINOR = " + this.editKeySigEvent.getMinor());
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.majorMinorMenu);
            } else {
                System.out.println("HAHAHAHA - metaEventTask = " + this.metaEventTask + " and metaEventMenuAction = " + this.metaEventMenuAction + " and singleMetaEventMenu.getSelectedIndex() = " + this.singleMetaEventMenu.getSelectedIndex() + "edit bars = " + this.editBars);
                if (this.metaEventMenuAction == 81) {
                    if (this.singleMetaEventMenu.getSelectedIndex() == 0) {
                        if (this.metaEventTask == 0) {
                            System.out.println("dtatEditME = " + this.dtAtEditME);
                            this.tempoTrack.getDTfromBar(this.editBars);
                            int dtAt = this.dtAtEditME + (this.editBeats - 1) * this.timeSigAtEditME.getTicksPerBeat(this.ticksPerCrotchet) + this.editTicks;
                            System.out.println("dtAt = " + dtAt);
                            this.tempoTrack.insertTempoEvent(this.editTempoEvent, dtAt);
                        } else if (this.metaEventTask == 1) {
                            this.tempoTrack.getTempo(this.metaEventList.getSelectedIndex()).setBPM(this.editTempoEvent.getBPM());
                        }
                    }
                } else if (this.metaEventMenuAction == 88) {
                    if (this.singleMetaEventMenu.getSelectedIndex() == 0) {
                        if (this.metaEventTask == 0) {
                            System.out.println("1dtatEditME = " + this.dtAtEditME);
                            this.tempoTrack.getDTfromBar(this.editBars);
                            System.out.println("2dtatEditME = " + this.dtAtEditME);
                            this.tempoTrack.insertTimeSigEvent(this.editTimeSigEvent, this.dtAtEditME);
                        } else if (this.metaEventTask == 1) {
                            this.tempoTrack.getTimeSig(this.metaEventList.getSelectedIndex()).setNumerator((byte)this.editTimeSigEvent.getNumerator());
                            this.tempoTrack.getTimeSig(this.metaEventList.getSelectedIndex()).setDenominator((byte)this.editTimeSigEvent.getDenominator());
                        }
                    }
                } else if (this.metaEventMenuAction == 89 && this.singleMetaEventMenu.getSelectedIndex() == 0) {
                    if (this.metaEventTask == 0) {
                        System.out.println("1dtatEditME = " + this.dtAtEditME);
                        this.tempoTrack.getDTfromBar(this.editBars);
                        System.out.println("2dtatEditME = " + this.dtAtEditME);
                        this.tempoTrack.insertKeySigEvent(this.editKeySigEvent, this.dtAtEditME);
                    } else if (this.metaEventTask == 1) {
                        this.tempoTrack.getKeySig(this.metaEventList.getSelectedIndex()).setSf(this.editKeySigEvent.getSf());
                        this.tempoTrack.getKeySig(this.metaEventList.getSelectedIndex()).setMinor(this.editKeySigEvent.getMinor());
                    }
                }
                this.tempoTrack.populateMetaEventList();
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.metaEventList);
            }
        } else if (s.equals(this.sharpsFlatsMenu)) {
            if (c.getLabel().equals("Back")) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleMetaEventMenu);
            } else {
                this.editKeySigEvent.setSf((byte)(-7 + this.sharpsFlatsMenu.getSelectedIndex()));
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleMetaEventMenu);
            }
        } else if (s.equals(this.majorMinorMenu)) {
            if (c.getLabel().equals("Back")) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleMetaEventMenu);
            } else {
                this.editKeySigEvent.setMinor((byte)this.majorMinorMenu.getSelectedIndex());
                System.out.println("mm2 = " + this.editKeySigEvent.getSf());
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleMetaEventMenu);
            }
        } else if (s.equals(this.singleTrackMenu)) {
            if (c.getLabel().equals("Back")) {
                this.populateTrackList();
            } else if (this.singleTrackMenu.getString(this.singleTrackMenu.getSelectedIndex()).equals("Go to stave")) {
                ((ScoreDrawingCanvas)this.sdc).changeTrack(this.trackNum);
                Display.getDisplay((MIDlet)this).setCurrent(this.sdc);
            } else if (this.singleTrackMenu.getString(this.singleTrackMenu.getSelectedIndex()).equals("Rename")) {
                this.txtName.setString(this.getTrack(this.trackNum).getTrackName());
                this.nameAction = 0;
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.txtName);
            } else if (this.singleTrackMenu.getString(this.singleTrackMenu.getSelectedIndex()).equals("Set channel")) {
                this.txtNumberAction = 1;
                this.txtNumber.setTitle("Set channel");
                this.txtNumber.setString(Integer.toString(this.getTrack(this.trackNum).getChannel() + 1));
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.txtNumber);
            } else if (this.singleTrackMenu.getString(this.singleTrackMenu.getSelectedIndex()).equals("Set instrument")) {
                this.instrumentGroupsList.setTitle("Groups -- (" + this.instrumentNames[this.getTrack(this.trackNum).getInstrument()] + ")");
                this.instrumentGroupsList.deleteAll();
                for (int i = 0; i < this.instrumentGroups.length; ++i) {
                    this.instrumentGroupsList.append(this.instrumentGroups[i], null);
                }
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.instrumentGroupsList);
            } else if (this.singleTrackMenu.getString(this.singleTrackMenu.getSelectedIndex()).equals("Set clef")) {
                this.clefList.setSelectedIndex((int)this.getTrack(this.trackNum).getClef(), true);
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.clefList);
            } else if (this.singleTrackMenu.getString(this.singleTrackMenu.getSelectedIndex()).equals("Copy track")) {
                this.threadTask = 5;
                Thread myThread = new Thread(this);
                myThread.start();
            } else if (this.singleTrackMenu.getString(this.singleTrackMenu.getSelectedIndex()).equals("Transpose")) {
                this.txtNumberAction = 5;
                this.txtNumber.setTitle("Transpose (semintones)");
                this.txtNumber.setString("0");
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.txtNumber);
            } else if (this.singleTrackMenu.getString(this.singleTrackMenu.getSelectedIndex()).equals("Remove track")) {
                this.sureAlertAction = 3;
                this.sureAlert.setTitle("Remove track?");
                this.sureAlert.setString("Do you really want to remove track " + this.trackListMenu.getString(this.trackListMenu.getSelectedIndex()) + "?");
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.sureAlert);
            }
        } else if (s.equals(this.instrumentList)) {
            if (c.getLabel().equals("Back")) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.instrumentGroupsList);
            } else {
                this.getTrack(this.trackNum).setInstrument((byte)(this.instrumentGroupsList.getSelectedIndex() * 8 + this.instrumentList.getSelectedIndex()));
                if (this.trackNum == ((ScoreDrawingCanvas)this.sdc).currentTrack) {
                    ((ScoreDrawingCanvas)this.sdc).np.instrument = this.getTrack(this.trackNum).getInstrument();
                    ((ScoreDrawingCanvas)this.sdc).np.threadTask = 1;
                    Thread npSetInstrumentThread = new Thread(((ScoreDrawingCanvas)this.sdc).np);
                    npSetInstrumentThread.start();
                }
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleTrackMenu);
            }
        } else if (s.equals(this.instrumentGroupsList)) {
            if (c.getLabel().equals("Back")) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleTrackMenu);
            } else {
                try {
                    this.instrumentList.deleteAll();
                    for (int i = this.instrumentGroupsList.getSelectedIndex() * 8; i < this.instrumentGroupsList.getSelectedIndex() * 8 + 8; ++i) {
                        this.instrumentList.append(this.instrumentNames[i], null);
                    }
                    this.instrumentList.setTitle(this.instrumentGroups[this.instrumentGroupsList.getSelectedIndex()]);
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.instrumentList);
                }
                catch (Exception e) {
                    this.instrumentList.setTitle(e.toString());
                }
            }
        } else if (s.equals(this.clefList)) {
            if (c.getLabel().equals("Back")) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleTrackMenu);
            } else {
                this.getTrack(this.trackNum).setClef((byte)this.clefList.getSelectedIndex());
                ((ScoreDrawingCanvas)this.sdc).clef = (byte)this.clefList.getSelectedIndex();
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleTrackMenu);
            }
        } else if (s.equals(this.txtName)) {
            if (c.getLabel().equals("Back")) {
                if (this.nameAction == 0) {
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleTrackMenu);
                } else if (this.nameAction == 1) {
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.scoreMenu);
                } else if (this.nameAction == 2) {
                    this.threadTask = 0;
                    Thread myThread = new Thread(this);
                    myThread.start();
                }
            } else if (this.nameAction == 0 && this.txtName.getString() != null) {
                this.getTrack(this.trackNum).setTrackName(this.txtName.getString());
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleTrackMenu);
            } else if (this.nameAction == 1 && this.txtName.getString() != null) {
                this.scoreName = this.txtName.getString();
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.scoreMenu);
            } else if (this.nameAction == 2 && this.txtName.getString().indexOf(".") == -1 && this.txtName.getString().indexOf("/") == -1) {
                this.fileName = this.txtName.getString();
                this.threadTask = 2;
                Thread myThread = new Thread(this);
                myThread.start();
            }
        } else if (s.equals(this.fileMenu)) {
            System.out.println("in file menu...");
            if (c.getLabel().equals("Back")) {
                Display.getDisplay((MIDlet)this).setCurrent(this.sdc);
            } else if (this.fileMenu.getString(this.fileMenu.getSelectedIndex()).equals("New Score")) {
                this.sureAlertAction = 1;
                this.sureAlert.setTitle("New score?");
                this.sureAlert.setString("Do you really want to create a new score?  Any unsaved data will be lost...");
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.sureAlert);
            } else if (this.fileMenu.getString(this.fileMenu.getSelectedIndex()).equals("Load from file")) {
                this.fileAction = 2;
                this.fileList.setTitle("Load file");
                this.threadTask = 0;
                Thread myThread = new Thread(this);
                myThread.start();
            } else if (this.fileMenu.getString(this.fileMenu.getSelectedIndex()).equals("Save to file")) {
                this.fileAction = 3;
                this.fileList.setTitle("Save to file");
                this.threadTask = 0;
                Thread myThread = new Thread(this);
                myThread.start();
            } else if (this.fileMenu.getString(this.fileMenu.getSelectedIndex()).equals("Delete file")) {
                this.fileAction = 4;
                this.fileList.setTitle("Delete file");
                this.threadTask = 0;
                Thread myThread = new Thread(this);
                myThread.start();
            } else if (this.fileMenu.getString(this.fileMenu.getSelectedIndex()).equals("Load from RS")) {
                this.fileAction = 0;
                this.fileList.deleteAll();
                this.fileList.setTitle("Load from RS");
                if (this.mh.getRecordList(this.fileList) == 0 && this.fileList.size() > 0) {
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fileList);
                } else {
                    this.errorAlert.setString("Error listing records...");
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.errorAlert);
                }
            } else if (this.fileMenu.getString(this.fileMenu.getSelectedIndex()).equals("Save to RS")) {
                this.mh.createMidiData();
                int ret = this.mh.writeMidiToRS();
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fileMenu);
                Alert al = new Alert("Save to RS");
                if (ret == -1) {
                    al.setString("There was an error saving to RS...");
                } else if (ret == -2) {
                    al.setString("Error - record store full...");
                } else if (ret == -3) {
                    al.setString("Error - security exception...");
                } else {
                    al.setString("Record " + ret + " created...");
                }
                al.setTimeout(4000);
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)al);
            } else if (this.fileMenu.getString(this.fileMenu.getSelectedIndex()).equals("Delete from RS")) {
                this.fileAction = 1;
                this.fileList.deleteAll();
                this.fileList.setTitle("DELETE from RS");
                if (this.mh.getRecordList(this.fileList) == 0 && this.fileList.size() > 0) {
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fileList);
                } else {
                    this.errorAlert.setString("Error listing records...");
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.errorAlert);
                }
            } else if (this.fileMenu.getString(this.fileMenu.getSelectedIndex()).equals("Options")) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.optionsMenu);
            } else if (this.fileMenu.getString(this.fileMenu.getSelectedIndex()).equals("Exit")) {
                this.sureAlertAction = 0;
                this.sureAlert.setTitle("Confirm exit?");
                this.sureAlert.setString("Any unsaved data will be lost...  www.marchantpeter.co.uk");
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.sureAlert);
            }
        } else if (s.equals(this.optionsMenu)) {
            if (c.getLabel().equals("Back")) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fileMenu);
            } else if (this.optionsMenu.getString(this.optionsMenu.getSelectedIndex()).equals("Pixels in note head")) {
                this.txtNumber.setTitle("Pixels in note head");
                this.txtNumberAction = 0;
                this.txtNumber.setString(Integer.toString(((ScoreDrawingCanvas)this.sdc).noteSize));
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.txtNumber);
            } else if (this.optionsMenu.getString(this.optionsMenu.getSelectedIndex()).equals("Sample duration (ms)")) {
                this.txtNumber.setTitle("Sample note duration (ms)");
                this.txtNumberAction = 3;
                this.txtNumber.setString(Integer.toString(((ScoreDrawingCanvas)this.sdc).np.duration));
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.txtNumber);
            } else if (this.optionsMenu.getString(this.optionsMenu.getSelectedIndex()).equals("Sample velocity")) {
                this.txtNumber.setTitle("Sample note velocity");
                this.txtNumberAction = 4;
                this.txtNumber.setString(Integer.toString(((ScoreDrawingCanvas)this.sdc).np.velocity));
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.txtNumber);
            } else if (this.optionsMenu.getString(this.optionsMenu.getSelectedIndex()).equals("Duration indicator size")) {
                this.txtNumber.setTitle("Duration indicator siz");
                this.txtNumberAction = 6;
                this.txtNumber.setString(Integer.toString(((ScoreDrawingCanvas)this.sdc).durationIndicatorSize));
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.txtNumber);
            } else if (this.optionsMenu.getString(this.optionsMenu.getSelectedIndex()).equals("Colours")) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.coloursMenu);
            } else if (this.optionsMenu.getString(this.optionsMenu.getSelectedIndex()).equals("Set controls")) {
                this.optionsCanvas.setControls();
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.optionsCanvas);
            } else if (this.optionsMenu.getString(this.optionsMenu.getSelectedIndex()).equals("Player volume (0 - 100)")) {
                this.txtNumber.setTitle("Player volume (0 - 100)");
                this.txtNumberAction = 7;
                this.txtNumber.setString(Integer.toString(this.optionsCanvas.playerVolume));
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.txtNumber);
            }
        } else if (s.equals(this.coloursMenu)) {
            if (c.getLabel().equals("Back")) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.optionsMenu);
            } else {
                this.colourChooser.item = this.coloursMenu.getString(this.coloursMenu.getSelectedIndex());
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.colourChooser);
                if (this.colourChooser.item.equals("Background")) {
                    this.colourChooser.originalRed = this.optionsCanvas.colourBackground[0];
                    this.colourChooser.originalGreen = this.optionsCanvas.colourBackground[1];
                    this.colourChooser.originalBlue = this.optionsCanvas.colourBackground[2];
                } else if (this.colourChooser.item.equals("Stave")) {
                    this.colourChooser.originalRed = this.optionsCanvas.colourStave[0];
                    this.colourChooser.originalGreen = this.optionsCanvas.colourStave[1];
                    this.colourChooser.originalBlue = this.optionsCanvas.colourStave[2];
                } else if (this.colourChooser.item.equals("Ledger lines")) {
                    this.colourChooser.originalRed = this.optionsCanvas.colourLedgerLines[0];
                    this.colourChooser.originalGreen = this.optionsCanvas.colourLedgerLines[1];
                    this.colourChooser.originalBlue = this.optionsCanvas.colourLedgerLines[2];
                } else if (this.colourChooser.item.equals("Notes")) {
                    this.colourChooser.originalRed = this.optionsCanvas.colourNotes[0];
                    this.colourChooser.originalGreen = this.optionsCanvas.colourNotes[1];
                    this.colourChooser.originalBlue = this.optionsCanvas.colourNotes[2];
                } else if (this.colourChooser.item.equals("Selected notes")) {
                    this.colourChooser.originalRed = this.optionsCanvas.colourSelectedNotes[0];
                    this.colourChooser.originalGreen = this.optionsCanvas.colourSelectedNotes[1];
                    this.colourChooser.originalBlue = this.optionsCanvas.colourSelectedNotes[2];
                } else if (this.colourChooser.item.equals("Highlighted note")) {
                    this.colourChooser.originalRed = this.optionsCanvas.colourHighlightedNote[0];
                    this.colourChooser.originalGreen = this.optionsCanvas.colourHighlightedNote[1];
                    this.colourChooser.originalBlue = this.optionsCanvas.colourHighlightedNote[2];
                } else if (this.colourChooser.item.equals("Clefs")) {
                    this.colourChooser.originalRed = this.optionsCanvas.colourClefs[0];
                    this.colourChooser.originalGreen = this.optionsCanvas.colourClefs[1];
                    this.colourChooser.originalBlue = this.optionsCanvas.colourClefs[2];
                } else if (this.colourChooser.item.equals("Sharps")) {
                    this.colourChooser.originalRed = this.optionsCanvas.colourSharps[0];
                    this.colourChooser.originalGreen = this.optionsCanvas.colourSharps[1];
                    this.colourChooser.originalBlue = this.optionsCanvas.colourSharps[2];
                } else if (this.colourChooser.item.equals("Flats")) {
                    this.colourChooser.originalRed = this.optionsCanvas.colourFlats[0];
                    this.colourChooser.originalGreen = this.optionsCanvas.colourFlats[1];
                    this.colourChooser.originalBlue = this.optionsCanvas.colourFlats[2];
                } else if (this.colourChooser.item.equals("Naturals")) {
                    this.colourChooser.originalRed = this.optionsCanvas.colourNaturals[0];
                    this.colourChooser.originalGreen = this.optionsCanvas.colourNaturals[1];
                    this.colourChooser.originalBlue = this.optionsCanvas.colourNaturals[2];
                } else if (this.colourChooser.item.equals("Text")) {
                    this.colourChooser.originalRed = this.optionsCanvas.colourText[0];
                    this.colourChooser.originalGreen = this.optionsCanvas.colourText[1];
                    this.colourChooser.originalBlue = this.optionsCanvas.colourText[2];
                }
            }
        } else if (s.equals((Object)this.colourChooser)) {
            if (c.getLabel().equals("Back")) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.coloursMenu);
            } else {
                if (this.colourChooser.item.equals("Background")) {
                    this.optionsCanvas.colourBackground[0] = this.colourChooser.getSelectedSquareRed();
                    this.optionsCanvas.colourBackground[1] = this.colourChooser.getSelectedSquareGreen();
                    this.optionsCanvas.colourBackground[2] = this.colourChooser.getSelectedSquareBlue();
                } else if (this.colourChooser.item.equals("Stave")) {
                    this.optionsCanvas.colourStave[0] = this.colourChooser.getSelectedSquareRed();
                    this.optionsCanvas.colourStave[1] = this.colourChooser.getSelectedSquareGreen();
                    this.optionsCanvas.colourStave[2] = this.colourChooser.getSelectedSquareBlue();
                } else if (this.colourChooser.item.equals("Ledger lines")) {
                    this.optionsCanvas.colourLedgerLines[0] = this.colourChooser.getSelectedSquareRed();
                    this.optionsCanvas.colourLedgerLines[1] = this.colourChooser.getSelectedSquareGreen();
                    this.optionsCanvas.colourLedgerLines[2] = this.colourChooser.getSelectedSquareBlue();
                } else if (this.colourChooser.item.equals("Notes")) {
                    this.optionsCanvas.colourNotes[0] = this.colourChooser.getSelectedSquareRed();
                    this.optionsCanvas.colourNotes[1] = this.colourChooser.getSelectedSquareGreen();
                    this.optionsCanvas.colourNotes[2] = this.colourChooser.getSelectedSquareBlue();
                } else if (this.colourChooser.item.equals("Selected notes")) {
                    this.optionsCanvas.colourSelectedNotes[0] = this.colourChooser.getSelectedSquareRed();
                    this.optionsCanvas.colourSelectedNotes[1] = this.colourChooser.getSelectedSquareGreen();
                    this.optionsCanvas.colourSelectedNotes[2] = this.colourChooser.getSelectedSquareBlue();
                } else if (this.colourChooser.item.equals("Highlighted note")) {
                    this.optionsCanvas.colourHighlightedNote[0] = this.colourChooser.getSelectedSquareRed();
                    this.optionsCanvas.colourHighlightedNote[1] = this.colourChooser.getSelectedSquareGreen();
                    this.optionsCanvas.colourHighlightedNote[2] = this.colourChooser.getSelectedSquareBlue();
                } else if (this.colourChooser.item.equals("Clefs")) {
                    this.optionsCanvas.colourClefs[0] = this.colourChooser.getSelectedSquareRed();
                    this.optionsCanvas.colourClefs[1] = this.colourChooser.getSelectedSquareGreen();
                    this.optionsCanvas.colourClefs[2] = this.colourChooser.getSelectedSquareBlue();
                } else if (this.colourChooser.item.equals("Sharps")) {
                    this.optionsCanvas.colourSharps[0] = this.colourChooser.getSelectedSquareRed();
                    this.optionsCanvas.colourSharps[1] = this.colourChooser.getSelectedSquareGreen();
                    this.optionsCanvas.colourSharps[2] = this.colourChooser.getSelectedSquareBlue();
                } else if (this.colourChooser.item.equals("Flats")) {
                    this.optionsCanvas.colourFlats[0] = this.colourChooser.getSelectedSquareRed();
                    this.optionsCanvas.colourFlats[1] = this.colourChooser.getSelectedSquareGreen();
                    this.optionsCanvas.colourFlats[2] = this.colourChooser.getSelectedSquareBlue();
                } else if (this.colourChooser.item.equals("Naturals")) {
                    this.optionsCanvas.colourNaturals[0] = this.colourChooser.getSelectedSquareRed();
                    this.optionsCanvas.colourNaturals[1] = this.colourChooser.getSelectedSquareGreen();
                    this.optionsCanvas.colourNaturals[2] = this.colourChooser.getSelectedSquareBlue();
                } else if (this.colourChooser.item.equals("Text")) {
                    this.optionsCanvas.colourText[0] = this.colourChooser.getSelectedSquareRed();
                    this.optionsCanvas.colourText[1] = this.colourChooser.getSelectedSquareGreen();
                    this.optionsCanvas.colourText[2] = this.colourChooser.getSelectedSquareBlue();
                }
                this.optionsCanvas.saveOptions();
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.coloursMenu);
            }
        } else if (s.equals(this.fileList)) {
            if (c.getLabel().equals("Back")) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fileMenu);
            } else {
                int index = this.fileList.getSelectedIndex();
                if (this.fileAction == 0) {
                    String rec = this.fileList.getString(index);
                    System.out.println(rec.substring(0, rec.indexOf(" --")));
                    int recID = Integer.parseInt(rec.substring(0, rec.indexOf(" --")));
                    this.mh.loadMidiFromRS(recID);
                    ((ScoreDrawingCanvas)this.sdc).gotoStart();
                    Display.getDisplay((MIDlet)this).setCurrent(this.sdc);
                } else if (this.fileAction == 1) {
                    String rec = this.fileList.getString(this.fileList.getSelectedIndex());
                    System.out.println(rec.substring(0, rec.indexOf(" --")));
                    int recID = Integer.parseInt(rec.substring(0, rec.indexOf(" --")));
                    if (!this.mh.deleteRecord(recID)) {
                        this.errorAlert.setString("Record cannot be deleted...");
                        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.errorAlert);
                    } else {
                        this.fileList.delete(this.fileList.getSelectedIndex());
                        if (this.fileList.size() == 0) {
                            this.errorAlert.setString("There are no records...");
                            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.errorAlert);
                            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fileMenu);
                        }
                    }
                } else if (this.fileAction == 2) {
                    if (index == 0) {
                        this.upOneLevel();
                    } else if (this.fileList.getString(index).endsWith("/")) {
                        this.path = this.path + this.fileList.getString(index);
                        Thread myThread = new Thread(this);
                        myThread.start();
                    } else {
                        this.threadTask = 1;
                        Thread myThread = new Thread(this);
                        myThread.start();
                    }
                } else if (this.fileAction == 3) {
                    if (index == 0) {
                        this.upOneLevel();
                    } else if (index == 1) {
                        this.nameAction = 2;
                        this.txtName.setString(this.fileName);
                        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.txtName);
                    } else if (this.fileList.getString(index).endsWith("/")) {
                        this.path = this.path + this.fileList.getString(index);
                        Thread myThread = new Thread(this);
                        myThread.start();
                    } else {
                        this.nameAction = 2;
                        int dotpos = this.fileList.getString(index).indexOf(".");
                        if (dotpos > 0) {
                            this.txtName.setString(this.fileList.getString(index).substring(0, dotpos));
                        } else {
                            this.txtName.setString(this.fileList.getString(index));
                        }
                        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.txtName);
                    }
                } else if (this.fileAction == 4) {
                    if (index == 0) {
                        this.upOneLevel();
                    } else if (this.fileList.getString(index).endsWith("/")) {
                        this.path = this.path + this.fileList.getString(index);
                        Thread myThread = new Thread(this);
                        myThread.start();
                    } else {
                        this.threadTask = 3;
                        Thread myThread = new Thread(this);
                        myThread.start();
                    }
                }
            }
        } else if (s.equals(this.txtNumber)) {
            int val;
            if (c.getLabel().equals("Back")) {
                if (this.txtNumberAction == 0 || this.txtNumberAction == 3 || this.txtNumberAction == 4 || this.txtNumberAction == 6 || this.txtNumberAction == 7) {
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.optionsMenu);
                } else if (this.txtNumberAction == 1 || this.txtNumberAction == 5) {
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleTrackMenu);
                } else if (this.txtNumberAction == 2) {
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleMetaEventMenu);
                }
            } else if (this.txtNumberAction == 0) {
                int val2 = Integer.parseInt(this.txtNumber.getString());
                if (val2 >= 1 && val2 <= 127) {
                    ((ScoreDrawingCanvas)this.sdc).noteSize = Byte.parseByte(this.txtNumber.getString());
                    this.optionsCanvas.noteSize = Byte.parseByte(this.txtNumber.getString());
                    this.optionsCanvas.saveOptions();
                    Display.getDisplay((MIDlet)this).setCurrent(this.sdc);
                }
            } else if (this.txtNumberAction == 1) {
                int val3 = Integer.parseInt(this.txtNumber.getString());
                if (val3 >= 1 && val3 <= 16) {
                    this.getTrack(this.trackNum).setChannel((byte)(val3 - 1));
                    if (this.trackNum == ((ScoreDrawingCanvas)this.sdc).currentTrack) {
                        ((ScoreDrawingCanvas)this.sdc).np.channel = this.getTrack(this.trackNum).getChannel();
                    }
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleTrackMenu);
                }
            } else if (this.txtNumberAction == 2) {
                int val4;
                if (this.singleMetaEventMenu.getString(this.singleMetaEventMenu.getSelectedIndex()).equals("Bar")) {
                    int val5 = Integer.parseInt(this.txtNumber.getString());
                    if (val5 >= 1) {
                        this.editBars = val5;
                        this.tempoTrack.getDTfromBar(val5);
                        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleMetaEventMenu);
                    }
                } else if (this.singleMetaEventMenu.getString(this.singleMetaEventMenu.getSelectedIndex()).equals("Beat")) {
                    int val6 = Integer.parseInt(this.txtNumber.getString());
                    this.tempoTrack.getDTfromBar(this.editBars);
                    if (val6 >= 1 && val6 <= this.editTimeSigEvent.getNumerator()) {
                        this.editBeats = val6;
                        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleMetaEventMenu);
                    }
                } else if (this.singleMetaEventMenu.getString(this.singleMetaEventMenu.getSelectedIndex()).equals("Ticks")) {
                    int val7 = Integer.parseInt(this.txtNumber.getString());
                    this.tempoTrack.getDTfromBar(this.editBars);
                    if (val7 >= 1 && val7 <= this.editTimeSigEvent.getTicksPerBeat(this.ticksPerCrotchet)) {
                        this.editTicks = val7;
                        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleMetaEventMenu);
                    }
                } else if (this.singleMetaEventMenu.getString(this.singleMetaEventMenu.getSelectedIndex()).equals("Set BPM")) {
                    int val8 = Integer.parseInt(this.txtNumber.getString());
                    if (val8 >= 1) {
                        this.editTempoEvent.setBPM(val8);
                        this.tempoTrack.getDTfromBar(val8);
                        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleMetaEventMenu);
                    }
                } else if (this.singleMetaEventMenu.getString(this.singleMetaEventMenu.getSelectedIndex()).equals("Set Numerator")) {
                    int val9 = Integer.parseInt(this.txtNumber.getString());
                    if (val9 >= 1 && val9 <= 16) {
                        this.editTimeSigEvent.setNumerator((byte)val9);
                        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleMetaEventMenu);
                    }
                } else if (this.singleMetaEventMenu.getString(this.singleMetaEventMenu.getSelectedIndex()).equals("Set Denominator") && ((val4 = Integer.parseInt(this.txtNumber.getString())) == 2 || val4 == 4 || val4 == 8)) {
                    this.editTimeSigEvent.setDenominator((byte)val4);
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleMetaEventMenu);
                }
            } else if (this.txtNumberAction == 3) {
                int val10 = Integer.parseInt(this.txtNumber.getString());
                if (val10 >= 0 && val10 <= 5000) {
                    ((ScoreDrawingCanvas)this.sdc).np.duration = Integer.parseInt(this.txtNumber.getString());
                    this.optionsCanvas.sampleNoteDuration = Integer.parseInt(this.txtNumber.getString());
                    this.optionsCanvas.saveOptions();
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.optionsMenu);
                }
            } else if (this.txtNumberAction == 4) {
                int val11 = Integer.parseInt(this.txtNumber.getString());
                if (val11 >= 0 && val11 <= 127) {
                    ((ScoreDrawingCanvas)this.sdc).np.velocity = (byte)Integer.parseInt(this.txtNumber.getString());
                    this.optionsCanvas.sampleNoteVelocity = Byte.parseByte(this.txtNumber.getString());
                    this.optionsCanvas.saveOptions();
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.optionsMenu);
                }
            } else if (this.txtNumberAction == 5) {
                int val12 = Integer.parseInt(this.txtNumber.getString());
                if (val12 != 0) {
                    this.threadTask = 6;
                    Thread myThread = new Thread(this);
                    myThread.start();
                }
            } else if (this.txtNumberAction == 6) {
                int val13 = Integer.parseInt(this.txtNumber.getString());
                if (val13 >= 1 && val13 <= 127) {
                    ((ScoreDrawingCanvas)this.sdc).durationIndicatorSize = Byte.parseByte(this.txtNumber.getString());
                    this.optionsCanvas.durationIndicatorSize = Byte.parseByte(this.txtNumber.getString());
                    this.optionsCanvas.saveOptions();
                    Display.getDisplay((MIDlet)this).setCurrent(this.sdc);
                }
            } else if (this.txtNumberAction == 7 && (val = Integer.parseInt(this.txtNumber.getString())) >= 0 && val <= 100) {
                this.optionsCanvas.playerVolume = val;
                this.optionsCanvas.saveOptions();
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.optionsMenu);
            }
        } else if (s.equals(this.sureAlert)) {
            if (c.getLabel().equals("Back")) {
                if (this.sureAlertAction == 0) {
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fileMenu);
                } else if (this.sureAlertAction == 1) {
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fileMenu);
                } else if (this.sureAlertAction == 2) {
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.txtName);
                } else if (this.sureAlertAction == 3) {
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleTrackMenu);
                }
            } else if (this.sureAlertAction == 0) {
                this.mh.stop();
                this.notifyDestroyed();
            } else if (this.sureAlertAction == 1) {
                this.newScore();
                this.tempoTrack.setDeltaTime(0);
                Display.getDisplay((MIDlet)this).setCurrent(this.sdc);
            } else if (this.sureAlertAction == 2) {
                this.threadTask = 4;
                Thread myThread = new Thread(this);
                myThread.start();
            } else if (this.sureAlertAction == 3) {
                this.tracks.removeElementAt(this.trackNum);
                if (this.trackNum < ((ScoreDrawingCanvas)this.sdc).currentTrack) {
                    --((ScoreDrawingCanvas)this.sdc).currentTrack;
                } else if (this.trackNum == ((ScoreDrawingCanvas)this.sdc).currentTrack) {
                    --((ScoreDrawingCanvas)this.sdc).currentTrack;
                    ((ScoreDrawingCanvas)this.sdc).gotoStart();
                }
                if (this.tracks.size() == 0) {
                    this.addNewTrack();
                    ((ScoreDrawingCanvas)this.sdc).currentTrack = 0;
                    ((ScoreDrawingCanvas)this.sdc).gotoStart();
                }
                this.populateTrackList();
            }
        } else if (s.equals(this.transposeAlert)) {
            if (c.getLabel().equals("Cancel")) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleTrackMenu);
            } else if (c.getLabel().startsWith("Collective maximum")) {
                this.transposeMethod = 1;
                this.threadTask = 7;
                Thread myThread = new Thread(this);
                myThread.start();
            } else if (c.getLabel().startsWith("Correct root collective maximum")) {
                this.transposeMethod = 2;
                this.threadTask = 7;
                Thread myThread = new Thread(this);
                myThread.start();
            } else if (c.getLabel().equals("Individual maximum")) {
                this.transposeMethod = 3;
                this.threadTask = 7;
                Thread myThread = new Thread(this);
                myThread.start();
            }
        }
    }

    public int getFirstUnusedChannel() {
        int i;
        boolean[] usedChannels = new boolean[16];
        for (i = 0; i < 16; ++i) {
            usedChannels[i] = false;
        }
        for (i = 0; i < this.tracks.size(); ++i) {
            usedChannels[this.getTrack((int)i).getChannel()] = true;
        }
        int unusedChannel = -1;
        for (int i2 = 0; i2 < 16; ++i2) {
            if (i2 == 9 || usedChannels[i2]) continue;
            unusedChannel = i2;
            break;
        }
        if (unusedChannel > -1) {
            return unusedChannel;
        }
        return 0;
    }

    public void setTicksPerCrotchet(int tpc) {
        this.ticksPerCrotchet = tpc;
        this.setDrawableNotes();
        ((ScoreDrawingCanvas)this.sdc).setTicksPerCrotchet(this.ticksPerCrotchet);
    }

    public int getTicksPerCrotchet() {
        return this.ticksPerCrotchet;
    }

    private void setDrawableNotes() {
        this.drawableNotes[0] = this.ticksPerCrotchet * 4;
        this.drawableNotes[1] = this.ticksPerCrotchet * 3;
        this.drawableNotes[2] = this.ticksPerCrotchet * 2;
        this.drawableNotes[3] = (int)((double)this.ticksPerCrotchet * 1.5);
        this.drawableNotes[4] = this.ticksPerCrotchet;
        this.drawableNotes[5] = this.ticksPerCrotchet / 4 * 3;
        this.drawableNotes[6] = this.ticksPerCrotchet / 2;
        this.drawableNotes[7] = this.ticksPerCrotchet / 8 * 3;
        this.drawableNotes[8] = this.ticksPerCrotchet / 4;
        this.drawableNotes[9] = this.ticksPerCrotchet / 16 * 3;
        this.drawableNotes[10] = this.ticksPerCrotchet / 8;
    }

    private int getBiggestUsefulNote(int d) {
        for (int i = 0; i < this.drawableNotes.length; ++i) {
            if (this.drawableNotes[i] > d) continue;
            return this.drawableNotes[i];
        }
        return this.drawableNotes[this.drawableNotes.length - 1];
    }

    public Queue makeNoteDisplayable(Note n) {
        Queue toReturn = new Queue();
        int remainingDuration = n.getDuration();
        int remainingDeltaTime = n.getDeltaTime();
        while (remainingDuration > 0) {
            int tempDt;
            int biggestUsefulNote = this.getBiggestUsefulNote(remainingDuration);
            remainingDuration -= biggestUsefulNote;
            if (remainingDeltaTime == 0) {
                tempDt = 0;
            } else if (remainingDeltaTime >= biggestUsefulNote) {
                tempDt = biggestUsefulNote;
                remainingDeltaTime -= biggestUsefulNote;
            } else {
                tempDt = remainingDeltaTime;
                remainingDeltaTime = 0;
            }
            Note toAdd = new Note(n.getPitch(), n.getVelocity(), tempDt, biggestUsefulNote);
            if (toReturn.isEmpty()) {
                toAdd.setTieBackwards(n.getTieBackwards());
            } else {
                toAdd.setTieBackwards(true);
            }
            if (remainingDuration == 0) {
                toAdd.setTieForwards(n.getTieForwards());
                toAdd.setDeltaTime(toAdd.getDeltaTime() + remainingDeltaTime);
            } else {
                toAdd.setTieForwards(true);
            }
            toReturn.enqueue(toAdd);
        }
        return toReturn;
    }

    public Stack makeRestDisplayable(Note n) {
        Stack<Note> toReturn = new Stack<Note>();
        int remainingDuration = n.getDuration();
        int remainingDeltaTime = n.getDeltaTime();
        while (remainingDuration > 0) {
            int tempDt;
            int biggestUsefulNote = this.getBiggestUsefulNote(remainingDuration);
            remainingDuration -= biggestUsefulNote;
            if (remainingDeltaTime == 0) {
                tempDt = 0;
            } else if (remainingDeltaTime >= biggestUsefulNote) {
                tempDt = biggestUsefulNote;
                remainingDeltaTime -= biggestUsefulNote;
            } else {
                tempDt = remainingDeltaTime;
                remainingDeltaTime = 0;
            }
            Note toAdd = new Note(n.getPitch(), n.getVelocity(), tempDt, biggestUsefulNote);
            toReturn.push(toAdd);
        }
        return toReturn;
    }

    public void setScoreName(String sn) {
        this.fileName = this.scoreName = sn;
    }

    public void setScoreName(byte[] data) {
        this.scoreName = "";
        for (int i = 0; i < data.length; ++i) {
            this.scoreName = this.scoreName + (char)data[i];
        }
        this.fileName = this.scoreName;
    }

    public String getScoreName() {
        return this.scoreName;
    }

    public Track getTrack(int t) {
        return (Track)this.tracks.elementAt(t);
    }

    public void addNewTrack() {
        Track newTrack = new Track();
        newTrack.setTrackName("New track");
        newTrack.setChannel((byte)0);
        newTrack.setInstrument((byte)0);
        for (int i = 0; i < 100; ++i) {
            newTrack.addNote(new Note(0, 127, this.ticksPerCrotchet / 2, this.ticksPerCrotchet / 2));
        }
        this.tracks.addElement(newTrack);
    }

    public void newScore() {
        this.tempoTrack.clearMetaEvents();
        this.tempoTrack.addKeySigEvent(new KeySigEvent(0, 0), 0);
        TempoEvent te = new TempoEvent();
        te.setBPM(120);
        this.tempoTrack.addTempoEvent(te, 0);
        this.tempoTrack.addTimeSigEvent(new TimeSigEvent(4, 2), 0);
        this.tracks.removeAllElements();
        this.scoreName = "New score";
        this.setTicksPerCrotchet(120);
        this.addNewTrack();
        this.fileName = this.scoreName;
        ((ScoreDrawingCanvas)this.sdc).currentTrack = 0;
        ((ScoreDrawingCanvas)this.sdc).gotoStart();
    }

    public void showFileList() {
        int res;
        this.fileList.deleteAll();
        this.fileList.append("Up one level", null);
        if (this.fileAction == 3) {
            this.fileList.append("Save as", null);
        }
        if ((res = this.mh.getFileList(this.fileList)) == 0) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fileList);
        } else if (res == -1) {
            this.errorAlert.setString("Error listing files...  Security Exception");
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.errorAlert);
        } else if (res == -2) {
            this.errorAlert.setString("Error listing files...  IO Exception - directory not found");
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.errorAlert);
        } else if (res == -3) {
            this.errorAlert.setString("Error listing files...");
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.errorAlert);
        }
    }

    public void upOneLevel() {
        if (!this.path.equals("")) {
            int ind = this.path.substring(0, this.path.length() - 1).lastIndexOf(47);
            this.path = ind != -1 ? this.path.substring(0, ind) : "";
            Thread myThread = new Thread(this);
            myThread.start();
        }
    }

    private void populateTrackList() {
        this.trackListMenu.deleteAll();
        this.trackListMenu.append("Add new Track", null);
        for (int i = 0; i < this.tracks.size(); ++i) {
            this.trackListMenu.append(String.valueOf(i + 1) + ". " + this.getTrack(i).getTrackName(), null);
        }
        this.trackListMenu.setSelectedIndex(((ScoreDrawingCanvas)this.sdc).currentTrack + 1, true);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.trackListMenu);
    }

    public void saveFile() {
        this.mh.createMidiData();
        int res = this.mh.writeMidiToFile();
        if (res == 0) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.fileMenu);
        } else if (res == -1) {
            this.errorAlert.setString("Error - writing file...");
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.errorAlert);
        } else if (res == -2) {
            this.errorAlert.setString("Error - closing file...");
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.errorAlert);
        }
    }

    public void run() {
        if (this.threadTask == 0) {
            this.showFileList();
        } else if (this.threadTask == 1) {
            System.out.println("ticks per crotchet = " + this.ticksPerCrotchet);
            int res = this.mh.loadMidiFromFile(this.path + this.fileList.getString(this.fileList.getSelectedIndex()));
            if (res == 0) {
                ((ScoreDrawingCanvas)this.sdc).gotoStart();
                ((ScoreDrawingCanvas)this.sdc).currentTrack = 0;
                this.mh.pleaseWait.setString("Done...");
                Display.getDisplay((MIDlet)this).setCurrent(this.sdc);
            } else {
                if (res == 1) {
                    this.errorAlert.setString("Error - file not found...");
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.errorAlert);
                } else if (res == 2) {
                    this.errorAlert.setString("Error - file is not a valid MIDI file...");
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.errorAlert);
                } else if (res == 3) {
                    this.errorAlert.setString("Error - file is not a MIDI format type 1 file...");
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.errorAlert);
                } else if (res == 4) {
                    this.errorAlert.setString("Error - track data not found where expected...");
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.errorAlert);
                }
                System.out.println("ticks per crotchet = " + this.ticksPerCrotchet);
            }
        } else if (this.threadTask == 2) {
            int res = this.mh.doesFileExist();
            if (res == 0) {
                this.saveFile();
            } else if (res == 1) {
                this.sureAlert.setString("Warning - the file ( " + this.path + this.fileName + ".mid) already exists...  Do you want to overwrite it?");
                this.sureAlertAction = 2;
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.sureAlert);
            } else {
                this.errorAlert.setString("Error whilst checking if file exists...");
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.errorAlert);
            }
        } else if (this.threadTask == 3) {
            if (this.fileList.getString(this.fileList.getSelectedIndex()).endsWith(".mid")) {
                int res = this.mh.deleteFile(this.path + this.fileList.getString(this.fileList.getSelectedIndex()));
                if (res == 0) {
                    this.showFileList();
                } else if (res == -1) {
                    this.errorAlert.setString("Error deleting file...  Security Exception");
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.errorAlert);
                } else if (res == -2) {
                    this.errorAlert.setString("Error deleting file...  IO Exception - file not found");
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.errorAlert);
                } else if (res == -3) {
                    this.errorAlert.setString("Error deleting file...");
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.errorAlert);
                }
            } else {
                this.errorAlert.setString("Error - only MIDI files can be deleted...");
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.errorAlert);
            }
        } else if (this.threadTask == 4) {
            this.saveFile();
        } else if (this.threadTask == 5) {
            Track newTrack = new Track();
            int ctn = this.trackListMenu.getSelectedIndex() - 1;
            this.mh.pleaseWait.setString("Copying track " + String.valueOf(ctn) + ". " + this.getTrack(ctn).getTrackName());
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mh.pleaseWait);
            newTrack.setChannel(this.getTrack(ctn).getChannel());
            newTrack.setClef(this.getTrack(ctn).getClef());
            newTrack.setInstrument(this.getTrack(ctn).getInstrument());
            newTrack.setTrackName("Copy of " + this.getTrack(ctn).getTrackName());
            for (int i = 0; i < this.getTrack(ctn).getSize(); ++i) {
                newTrack.addNote(new Note(this.getTrack(ctn).getNote(i)));
            }
            if (ctn + 1 <= ((ScoreDrawingCanvas)this.sdc).currentTrack) {
                ++((ScoreDrawingCanvas)this.sdc).currentTrack;
            }
            if (ctn + 1 == this.tracks.size()) {
                this.tracks.addElement(newTrack);
            } else {
                this.tracks.insertElementAt(newTrack, ctn + 1);
            }
            this.populateTrackList();
        } else if (this.threadTask == 6) {
            int i;
            int ctn = this.trackListMenu.getSelectedIndex() - 1;
            this.mh.pleaseWait.setString("Preparing to transpose track " + String.valueOf(ctn) + ". " + this.getTrack(ctn).getTrackName());
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mh.pleaseWait);
            int transposeAmount = Integer.parseInt(this.txtNumber.getString());
            int outOfRangeNotes = 0;
            this.maxTranspose = 0;
            this.collectiveMaximum = 0;
            this.correctRootCollectiveMaximum = 0;
            if (transposeAmount > 0) {
                for (i = 0; i < this.getTrack(ctn).getSize(); ++i) {
                    if (this.getTrack(ctn).getNote(i).getPitch() > this.maxTranspose) {
                        this.maxTranspose = this.getTrack(ctn).getNote(i).getPitch();
                    }
                    if (this.getTrack(ctn).getNote(i).getPitch() > 0 && this.getTrack(ctn).getNote(i).getPitch() + transposeAmount > 127) {
                        ++outOfRangeNotes;
                    }
                    this.collectiveMaximum = 127 - this.maxTranspose;
                    this.correctRootCollectiveMaximum = transposeAmount % 12 > this.collectiveMaximum % 12 ? this.collectiveMaximum - 12 + (transposeAmount % 12 - this.collectiveMaximum % 12) : (transposeAmount % 12 < this.collectiveMaximum % 12 ? this.collectiveMaximum - (this.collectiveMaximum % 12 - transposeAmount % 12) : this.collectiveMaximum);
                }
            } else {
                this.maxTranspose = 127;
                for (i = 0; i < this.getTrack(ctn).getSize(); ++i) {
                    if (this.getTrack(ctn).getNote(i).getPitch() > 0 && this.getTrack(ctn).getNote(i).getPitch() < this.maxTranspose) {
                        this.maxTranspose = this.getTrack(ctn).getNote(i).getPitch();
                    }
                    if (this.getTrack(ctn).getNote(i).getPitch() <= 0 || this.getTrack(ctn).getNote(i).getPitch() + transposeAmount >= 1) continue;
                    ++outOfRangeNotes;
                }
                this.collectiveMaximum = -this.maxTranspose + 1;
                this.correctRootCollectiveMaximum = transposeAmount % 12 < this.collectiveMaximum % 12 ? this.collectiveMaximum + 12 + (transposeAmount % 12 - this.collectiveMaximum % 12) : (transposeAmount % 12 > this.collectiveMaximum % 12 ? this.collectiveMaximum - (this.collectiveMaximum % 12 - transposeAmount % 12) : this.collectiveMaximum);
            }
            if (outOfRangeNotes > 0) {
                this.transposeAlert = new Alert("Error transpose", "", null, AlertType.INFO);
                this.transposeAlert.setString("Transposing track " + String.valueOf(ctn) + ". " + this.getTrack(ctn).getTrackName() + " by " + this.txtNumber.getString() + " will cause " + String.valueOf(outOfRangeNotes) + " + note" + (outOfRangeNotes > 1 ? "s" : "") + " to be out of range...  What would you like to do?");
                Command cancelCommand = new Command("Cancel", 4, 0);
                Command collectiveMaximumCommand = new Command("Collective maximum " + String.valueOf(this.collectiveMaximum), 4, 1);
                Command individualMaximumCommand = new Command("Individual maximum", 4, 1);
                Command collectiveMaximumCorrectStartCommand = new Command("Correct root collective maximum " + String.valueOf(this.correctRootCollectiveMaximum), 4, 1);
                this.transposeAlert.addCommand(cancelCommand);
                this.transposeAlert.addCommand(collectiveMaximumCommand);
                this.transposeAlert.addCommand(individualMaximumCommand);
                this.transposeAlert.addCommand(collectiveMaximumCorrectStartCommand);
                this.transposeAlert.setCommandListener((CommandListener)this);
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.transposeAlert);
            } else {
                this.mh.pleaseWait.setString("Transposing track " + String.valueOf(ctn) + ". " + this.getTrack(ctn).getTrackName());
                for (i = 0; i < this.getTrack(ctn).getSize(); ++i) {
                    if (this.getTrack(ctn).getNote(i).getPitch() <= 0) continue;
                    this.getTrack(ctn).getNote(i).setPitch((byte)(this.getTrack(ctn).getNote(i).getPitch() + transposeAmount));
                }
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleTrackMenu);
            }
        } else if (this.threadTask == 7) {
            int ctn = this.trackListMenu.getSelectedIndex() - 1;
            this.mh.pleaseWait.setString("Transposing track " + String.valueOf(ctn) + ". " + this.getTrack(ctn).getTrackName());
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mh.pleaseWait);
            if (this.transposeMethod == 1) {
                for (int i = 0; i < this.getTrack(ctn).getSize(); ++i) {
                    if (this.getTrack(ctn).getNote(i).getPitch() <= 0) continue;
                    this.getTrack(ctn).getNote(i).setPitch((byte)(this.getTrack(ctn).getNote(i).getPitch() + this.collectiveMaximum));
                }
            } else if (this.transposeMethod == 2) {
                for (int i = 0; i < this.getTrack(ctn).getSize(); ++i) {
                    if (this.getTrack(ctn).getNote(i).getPitch() <= 0) continue;
                    this.getTrack(ctn).getNote(i).setPitch((byte)(this.getTrack(ctn).getNote(i).getPitch() + this.correctRootCollectiveMaximum));
                }
            } else if (this.transposeMethod == 3) {
                for (int i = 0; i < this.getTrack(ctn).getSize(); ++i) {
                    int newVal;
                    int transposeAmount = Integer.parseInt(this.txtNumber.getString());
                    if (transposeAmount > 0) {
                        if (this.getTrack(ctn).getNote(i).getPitch() <= 0) continue;
                        for (newVal = this.getTrack(ctn).getNote(i).getPitch() + transposeAmount; newVal > 127; newVal -= 12) {
                        }
                        this.getTrack(ctn).getNote(i).setPitch((byte)newVal);
                        continue;
                    }
                    if (this.getTrack(ctn).getNote(i).getPitch() <= 0) continue;
                    for (newVal = this.getTrack(ctn).getNote(i).getPitch() + transposeAmount; newVal < 1; newVal += 12) {
                    }
                    this.getTrack(ctn).getNote(i).setPitch((byte)newVal);
                }
            }
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.singleTrackMenu);
        }
    }

    public void removeStop() {
        this.scoreMenu.delete(this.playStopIndex);
        this.scoreMenu.insert(this.playStopIndex, "Play", null);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditonal) {
    }

    public void showOptionsMenu() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.optionsMenu);
    }
}

