/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Track {
    private String trackName;
    private Vector notes;
    private Vector tiedNotes;
    private byte channel;
    private byte instrument;
    private byte clef;
    public int highlightedNoteDt;

    public Track(String tn, byte c) {
        this.trackName = tn;
        this.notes = new Vector();
        this.tiedNotes = new Vector();
        this.channel = c;
        this.instrument = 0;
        this.clef = 0;
    }

    public Track() {
        this.trackName = "new track";
        this.notes = new Vector();
        this.tiedNotes = new Vector();
        this.instrument = 0;
        this.channel = 0;
        this.clef = 0;
    }

    public void setChannel(byte c) {
        this.channel = c;
    }

    public byte getChannel() {
        return this.channel;
    }

    public void setTrackName(String tn) {
        this.trackName = tn;
    }

    public String getTrackName() {
        return this.trackName;
    }

    public void setInstrument(byte instrument) {
        this.instrument = instrument;
    }

    public byte getInstrument() {
        return this.instrument;
    }

    public void setClef(byte clef) {
        this.clef = clef;
    }

    public byte getClef() {
        return this.clef;
    }

    public void setNotes(Vector n) {
        this.notes = n;
    }

    public Vector getNotes() {
        return this.notes;
    }

    public void addNote(Note n) {
        this.notes.addElement(n);
    }

    public Note getNote(int n) {
        return (Note)this.notes.elementAt(n);
    }

    public int insertNote(Note toInsert, int dtAt) {
        int i = 0;
        int prevNoteStartDT = 0;
        System.out.println("note being inserted, p = " + toInsert.getPitch() + "dt = " + toInsert.getDeltaTime() + " du = " + toInsert.getDuration() + " insert at " + dtAt);
        for (int dt = 0; i < this.notes.size() && dt <= dtAt; dt += this.getNote(i).getDeltaTime(), ++i) {
            prevNoteStartDT = dt;
        }
        int oldDt = this.getNote(i - 1).getDeltaTime();
        int newDt = dtAt - prevNoteStartDT;
        System.out.println("oldDt = " + oldDt);
        if (toInsert.getDeltaTime() <= 0) {
            this.getNote(i - 1).setDeltaTime(newDt);
            if (this.getNote(i - 1).getPitch() == 0) {
                if (this.getNote(i - 1).getDeltaTime() == 0) {
                    this.notes.removeElementAt(i - 1);
                } else {
                    this.getNote(i - 1).setDuration(this.getNote(i - 1).getDeltaTime());
                }
            }
            System.out.println("size = " + this.notes.size() + " and i = " + i);
            System.out.println("just changed note, duration= " + this.getNote(i).getDuration() + "dt = " + this.getNote(i).getDeltaTime() + "pitch = " + this.getNote(i).getPitch());
            toInsert.setDeltaTime(oldDt - newDt);
            System.out.println("added one to i");
        } else {
            System.out.println("inserted at i, = " + --i);
        }
        this.notes.insertElementAt(toInsert, i);
        System.out.println("just inserted note... i = " + i + " duration = " + toInsert.getDuration() + " and deltaTime = " + toInsert.getDeltaTime() + "and pitch = " + toInsert.getPitch());
        if (toInsert.getPitch() > 0) {
            this.removeRestsDuringNote(i, dtAt);
        }
        return i;
    }

    public void removeRestsDuringNote(int i, int trackDT) {
        int dur = this.getNote(i).getDuration();
        int tempDt1 = 0;
        while (i < this.notes.size() && dur > tempDt1) {
            if (this.getNote(i).getPitch() == 0) {
                System.out.println("in while loop, pitch =0, i = " + i + ", pitch = " + this.getNote(i).getPitch() + " dt = " + this.getNote(i).getDeltaTime() + " and duration = " + this.getNote(i).getDuration());
                if (tempDt1 + this.getNote(i).getDeltaTime() <= dur) {
                    System.out.println("need to remove the whole rest...");
                    this.getNote(i - 1).setDeltaTime(this.getNote(i - 1).getDeltaTime() + this.getNote(i).getDeltaTime());
                    tempDt1 += this.getNote(i).getDeltaTime();
                    this.notes.removeElementAt(i);
                    --i;
                } else {
                    this.getNote(i - 1).setDeltaTime(this.getNote(i - 1).getDeltaTime() + (dur - tempDt1));
                    System.out.println("need to remove part of the rest but not all of it...");
                    this.getNote(i).setDuration(this.getNote(i).getDuration() - (dur - tempDt1));
                    this.getNote(i).setDeltaTime(this.getNote(i).getDuration());
                    tempDt1 = dur;
                    Queue noteQueue = useful.theScore.makeNoteDisplayable(this.getNote(i));
                    Note tempNote = (Note)noteQueue.dequeue();
                    System.out.println("1st note dequeued= " + tempNote);
                    this.getNote(i).setDuration(tempNote.getDuration());
                    this.getNote(i).setDeltaTime(tempNote.getDeltaTime());
                    int tempDT = trackDT + tempDt1 + this.getNote(i).getDeltaTime();
                    while (!noteQueue.isEmpty()) {
                        tempNote = (Note)noteQueue.dequeue();
                        System.out.println("next note dequeued = " + tempNote);
                        this.insertNote(tempNote, tempDT);
                        tempDT += tempNote.getDuration();
                    }
                }
            } else {
                tempDt1 += this.getNote(i).getDeltaTime();
            }
            ++i;
        }
        System.out.println("end of removeRests during note...");
    }

    public void addTiedNote(TiedNote tn) {
        this.tiedNotes.addElement(tn);
    }

    public TiedNote getTiedNote(int tn) {
        return (TiedNote)this.tiedNotes.elementAt(tn);
    }

    public int getSize() {
        return this.notes.size();
    }

    public int getTiedNotesSize() {
        return this.tiedNotes.size();
    }

    public TiedNote findTiedNote(int tp) {
        for (int i = 0; i < this.tiedNotes.size(); ++i) {
            TiedNote tn = this.getTiedNote(i);
            if (tn.getPitch() != tp) continue;
            this.tiedNotes.removeElementAt(i);
            return tn;
        }
        return new TiedNote(0, 0, 0);
    }

    public void clearTiedNotes() {
        this.tiedNotes.removeAllElements();
    }

    public void deleteNote(int index, int currentBarTicks) {
        int searchdt;
        int originalDuration = this.getNote(index).getDuration();
        int originalDeltaTime = this.getNote(index).getDeltaTime();
        System.out.println("in remove note...");
        int startOfBarIndex = index;
        for (searchdt = currentBarTicks; startOfBarIndex > 0 && searchdt >= 0; searchdt -= this.getNote(--startOfBarIndex).getDeltaTime()) {
        }
        if (searchdt < 0) {
            ++startOfBarIndex;
        }
        System.out.println("startofBarindex = " + startOfBarIndex);
        int maxDuration = 0;
        while (startOfBarIndex < index) {
            if (this.getNote(startOfBarIndex).getDuration() > maxDuration) {
                maxDuration = this.getNote(startOfBarIndex).getDuration();
            }
            maxDuration -= this.getNote(startOfBarIndex).getDeltaTime();
            ++startOfBarIndex;
        }
        System.out.println("maxDuration = " + maxDuration);
        if (maxDuration - originalDeltaTime < 0) {
            this.notes.insertElementAt(new Note(0, 112, originalDeltaTime - maxDuration, originalDeltaTime - maxDuration), index + 1);
            this.notes.removeElementAt(index);
            ++index;
        } else {
            this.notes.removeElementAt(index);
        }
        maxDuration -= originalDeltaTime;
        int remainingDuration = originalDuration - originalDeltaTime;
        System.out.println("remainingDuration = " + remainingDuration);
        while (remainingDuration > 0) {
            int diff = this.getNote(index).getDeltaTime() - this.getNote(index).getDuration();
            if (diff > 0 && maxDuration - this.getNote(index).getDeltaTime() < 0) {
                System.out.println("inserting another rest part way through");
                this.notes.insertElementAt(new Note(0, 112, this.getNote(index).getDeltaTime() - maxDuration, this.getNote(index).getDeltaTime() - maxDuration), index + 1);
                this.getNote(index).setDeltaTime(this.getNote(index).getDuration());
            }
            if (this.getNote(index).getDuration() > maxDuration) {
                maxDuration = this.getNote(index).getDuration();
            }
            remainingDuration -= this.getNote(index).getDeltaTime();
            maxDuration -= this.getNote(index).getDeltaTime();
            ++index;
        }
    }

    public void addRests(int index, int currentBarTicks, int trackDT) {
        System.out.println("adding rests!!!");
        if (this.getNote(index).getDeltaTime() > this.getNote(index).getDuration()) {
            int searchdt;
            System.out.println("going to insert a rest...");
            int originalDuration = this.getNote(index).getDuration();
            int originalDeltaTime = this.getNote(index).getDeltaTime();
            int startOfBarIndex = index;
            for (searchdt = currentBarTicks; startOfBarIndex > 0 && searchdt >= 0; searchdt -= this.getNote(--startOfBarIndex).getDeltaTime()) {
            }
            if (searchdt < 0) {
                ++startOfBarIndex;
            }
            System.out.println("startofBarindex = " + startOfBarIndex);
            int maxDuration = 0;
            while (startOfBarIndex < index) {
                if (this.getNote(startOfBarIndex).getDuration() > maxDuration) {
                    maxDuration = this.getNote(startOfBarIndex).getDuration();
                }
                maxDuration -= this.getNote(startOfBarIndex).getDeltaTime();
                ++startOfBarIndex;
            }
            if (maxDuration < originalDeltaTime) {
                System.out.println("remainding duration =" + maxDuration);
                this.getNote(index).setDeltaTime(originalDuration);
                int restSize = originalDeltaTime - originalDuration;
                Note rest = new Note(0, 112, restSize, restSize);
                System.out.println("made a rest " + restSize);
                Queue noteQueue = useful.theScore.makeNoteDisplayable(rest);
                int tempDT = trackDT + this.getNote(index).getDeltaTime();
                while (!noteQueue.isEmpty()) {
                    Note tempNote = (Note)noteQueue.dequeue();
                    System.out.println("next note off stack, duration = " + tempNote.getDuration() + " and delta time = " + tempNote.getDeltaTime() + " and tieBackwards = " + tempNote.getTieBackwards() + " and tie forwards = " + tempNote.getTieForwards());
                    this.notes.insertElementAt(tempNote, ++index);
                }
            }
        }
    }

    public int removeNote(int index, int currentBarTicks) {
        int searchdt;
        int toReturn = 0;
        int originalDuration = this.getNote(index).getDuration();
        int originalDeltaTime = this.getNote(index).getDeltaTime();
        int startOfBarIndex = index;
        for (searchdt = currentBarTicks; startOfBarIndex > 0 && searchdt >= 0; searchdt -= this.getNote(--startOfBarIndex).getDeltaTime()) {
        }
        if (searchdt < 0) {
            ++startOfBarIndex;
        }
        int readFrom = searchdt;
        int maxDuration = 0;
        while (startOfBarIndex < index) {
            if (this.getNote(startOfBarIndex).getDuration() > maxDuration) {
                maxDuration = this.getNote(startOfBarIndex).getDuration();
            }
            maxDuration -= this.getNote(startOfBarIndex).getDeltaTime();
            ++startOfBarIndex;
        }
        if (maxDuration == 0) {
            if (this.getNote(index).getDuration() == this.getNote(index).getDeltaTime()) {
                this.getNote(index).setPitch((byte)0);
                this.getNote(index).setTieBackwards(false);
                this.getNote(index).setTieForwards(false);
            } else if (this.getNote(index).getDeltaTime() == 0) {
                this.notes.removeElementAt(index);
            } else {
                this.getNote(index).setPitch((byte)0);
                this.getNote(index).setDuration(originalDeltaTime);
                this.getNote(index).setTieBackwards(false);
                this.getNote(index).setTieForwards(false);
                int endOfNote = currentBarTicks + originalDuration;
                searchdt = currentBarTicks + this.getNote(index).getDeltaTime();
                int searchIndex = index + 1;
                maxDuration = 0;
                while (searchdt < endOfNote) {
                    if (maxDuration < this.getNote(searchIndex).getDuration()) {
                        maxDuration = this.getNote(searchIndex).getDuration();
                    }
                    if ((maxDuration -= this.getNote(searchIndex).getDeltaTime()) < 0) {
                        int positiveDur = 0 - maxDuration;
                        Note toInsert = new Note(0, 70, positiveDur, positiveDur);
                        this.insertNote(toInsert, searchdt + this.getNote(searchIndex).getDeltaTime());
                    }
                    searchdt += this.getNote(searchIndex).getDeltaTime();
                    ++searchIndex;
                }
            }
        } else if (maxDuration >= originalDeltaTime) {
            int prevDeltaTime = this.getNote(index - 1).getDeltaTime();
            this.getNote(index - 1).setDeltaTime(prevDeltaTime + originalDeltaTime);
            this.notes.removeElementAt(index);
            toReturn = prevDeltaTime;
        } else if (this.getNote(index).getDeltaTime() == 0) {
            this.notes.removeElementAt(index);
        } else {
            this.getNote(index).setPitch((byte)0);
            this.getNote(index).setTieBackwards(false);
            this.getNote(index).setTieForwards(false);
            this.getNote(index).setDuration(originalDeltaTime - maxDuration);
            this.getNote(index).setDeltaTime(originalDeltaTime - maxDuration);
            this.getNote(index - 1).setDeltaTime(this.getNote(index - 1).getDeltaTime() + maxDuration);
            int endOfNote = currentBarTicks + originalDuration;
            searchdt = currentBarTicks + maxDuration;
            int searchIndex = index + 1;
            maxDuration = 0;
            while (searchdt < endOfNote) {
                if (maxDuration < this.getNote(searchIndex).getDuration()) {
                    maxDuration = this.getNote(searchIndex).getDuration();
                }
                if ((maxDuration -= this.getNote(searchIndex).getDeltaTime()) < 0) {
                    int positiveDur = 0 - maxDuration;
                    Note toInsert = new Note(0, 70, positiveDur, positiveDur);
                    this.insertNote(toInsert, searchdt + this.getNote(searchIndex).getDeltaTime());
                }
                searchdt += this.getNote(searchIndex).getDeltaTime();
                ++searchIndex;
            }
        }
        return toReturn;
    }

    public int getNoteFromMs(long ms) {
        System.out.println("Just started getNoteFromMs");
        this.highlightedNoteDt = 0;
        int noteIndex = 0;
        int ticksPerCrotchet = useful.theScore.getTicksPerCrotchet();
        useful.theScore.tempoTrack.setDeltaTime(0);
        int tempo = useful.theScore.tempoTrack.getCurrentTempo().getTempo();
        int dt = this.getNote(noteIndex).getDeltaTime();
        int msInTick = tempo / ticksPerCrotchet;
        System.out.println("msintick = " + msInTick + ",dt = " + dt + ", ms = " + ms + "tpc = " + ticksPerCrotchet + "tempo = " + tempo);
        while (ms > (long)(dt * msInTick)) {
            if (noteIndex == this.notes.size() - 1) {
                System.out.println("in Track.getNoteFromMs, noteIndex==notes.size()-1...");
                for (int i = 0; i < 50; ++i) {
                    this.addNote(new Note(0, 70, useful.theScore.getTicksPerCrotchet() / 2, useful.theScore.getTicksPerCrotchet() / 2));
                }
            }
            this.highlightedNoteDt += dt;
            ms -= (long)(dt * msInTick);
            useful.theScore.tempoTrack.incrementDeltaTime(dt);
            if (useful.theScore.tempoTrack.hasTempoChanged()) {
                tempo = useful.theScore.tempoTrack.getCurrentTempo().getTempo();
                msInTick = tempo / ticksPerCrotchet;
            }
            dt = this.getNote(++noteIndex).getDeltaTime();
        }
        return noteIndex;
    }

    public void deselectAllNotes(int numSelectedNotes) {
        for (int noteIndex = 0; numSelectedNotes > 0 && noteIndex < this.notes.size(); ++noteIndex) {
            numSelectedNotes = this.getNote(noteIndex).setDeselected(numSelectedNotes);
        }
    }

    public int getNumSelectedNotes() {
        int numSelectedNotes = 0;
        for (int i = 0; i < this.notes.size(); ++i) {
            if (!this.getNote((int)i).selected) continue;
            ++numSelectedNotes;
        }
        return numSelectedNotes;
    }

    public int getHighlightedNoteFromDt(int dt) {
        int highlightedNote = 0;
        while (dt >= this.getNote(highlightedNote).getDeltaTime()) {
            dt -= this.getNote(highlightedNote).getDeltaTime();
            if (++highlightedNote != this.notes.size()) continue;
            for (int j = 0; j < 50; ++j) {
                this.addNote(new Note(0, 70, useful.theScore.getTicksPerCrotchet() / 2, useful.theScore.getTicksPerCrotchet() / 2));
            }
        }
        return highlightedNote;
    }
}

