/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Explosion {
    public static final int WIDTH_NORMAL_EXPLOSION = 62;
    public static final int HEIGHT_NORMAL_EXPLOSION = 55;
    public static final int WIDTH_SPARK_EXPLOSION = 8;
    public static final int HEIGHT_SPARK_EXPLOSION = 8;
    public static final int WIDTH_SMOKE_EXPLOSION = 20;
    public static final int HEIGHT_SMOKE_EXPLOSION = 20;
    public static final int WIDTH_LASER_IMPACT = 30;
    public static final int HEIGHT_LASER_IMPACT = 30;
    public static final int EXPLOSION_DELTA = 4;
    public static Image imgExplosion;
    public static Image imgSparks;
    public static Image imgSmoke;
    public static Image imgRock;
    public static Image imgLaserGlare;
    public static int[] explosionParam;
    public static int explosionCurrentMax;
    public static final int EXPLOSION_PARAM_TYPE = 0;
    public static final int EXPLOSION_PARAM_XPOS = 1;
    public static final int EXPLOSION_PARAM_YPOS = 2;
    public static final int EXPLOSION_PARAM_SPEED = 3;
    public static final int EXPLOSION_PARAM_FRAME = 4;
    public static final int EXPLOSION_PARAM_MAXFRAME = 5;
    public static final int EXPLOSION_PARAM_UPSPEED = 6;
    public static final int EXPLOSION_PARAM_MAX = 7;
    public static final int MAX_EXPLOSION = 164;
    public static final int EXPLOSION_TYPE_NONE = -1;
    public static final int EXPLOSION_NORMAL = 0;
    public static final int EXPLOSION_NUKE = 1;
    public static final int EXPLOSION_SPARK = 2;
    public static final int EXPLOSION_SIMPLESPARK = 3;
    public static final int EXPLOSION_MINI = 4;
    public static final int EXPLOSION_FIREWORKS = 5;
    public static final int EXPLOSION_SMOKE = 6;
    public static final int EXPLOSION_ROCK = 7;
    public static final int EXPLOSION_LASER = 8;
    public static final int EXPLOSION_SIMPLESPARK2 = 9;
    public static final int EXPLOSION_BOOSTER = 10;
    public static final int EXPLOSION_FRAME_NORMALMAX = 10;
    public static final int EXPLOSION_FRAME_NUKEMAX = 8;
    public static final int EXPLOSION_FRAME_SPARKMAX = 4;
    public static final int EXPLOSION_FRAME_MINIMAX = 5;
    public static final int EXPLOSION_FRAME_SMOKEMAX = 6;
    public static final int EXPLOSION_FRAME_LASERMAX = 2;
    public static final int EXPLOSION_FRAME_LASERSPARKMAX = 3;

    static void init(int n) {
        switch (n) {
            case 35: {
                imgExplosion = gameTopLevel.getImage("/explosion.png");
                break;
            }
            case 36: {
                imgSparks = gameTopLevel.getImage("/spark.png");
                break;
            }
            case 37: {
                imgSmoke = gameTopLevel.getImage("/smoke.png");
                break;
            }
            case 38: {
                imgRock = gameTopLevel.getImage("/smallrock.png");
                break;
            }
            case 39: {
                imgLaserGlare = gameTopLevel.getImage("/laserglare.png");
            }
        }
    }

    static void initLevel() {
        explosionParam = new int[1148];
        for (int i = 0; i < 164; ++i) {
            Explosion.explosionParam[i * 7 + 0] = -1;
        }
        explosionCurrentMax = 0;
    }

    static void closeLevel() {
        explosionParam = null;
    }

    static void generate(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        while (n5 < 164 && explosionParam[n6 + 0] != -1) {
            ++n5;
            n6 += 7;
        }
        if (n5 != 164) {
            if (explosionCurrentMax < n5 + 1) {
                explosionCurrentMax = n5 + 1;
            }
            Explosion.explosionParam[n6 + 0] = n3;
            Explosion.explosionParam[n6 + 1] = n;
            Explosion.explosionParam[n6 + 2] = n2;
            Explosion.explosionParam[n6 + 3] = n4;
            Explosion.explosionParam[n6 + 4] = 0;
            switch (n3) {
                case 0: {
                    int n7;
                    Explosion.explosionParam[n6 + 5] = 10;
                    for (n7 = 0; n7 < 8; ++n7) {
                        Explosion.generate(n + 31, n2 + 27, 5, n4 + Enemy.rnd.nextInt() % 8);
                    }
                    for (n7 = 0; n7 < 4; ++n7) {
                        Explosion.generate(n + 31, n2 + 27, 6, n4 + Enemy.rnd.nextInt() % 3 - 2);
                    }
                    break;
                }
                case 1: {
                    Explosion.explosionParam[n6 + 5] = 8;
                    break;
                }
                case 2: {
                    Explosion.explosionParam[n6 + 5] = 4;
                    for (int i = 0; i < 3; ++i) {
                        Explosion.generate(n, n2, 5, n4 + Enemy.rnd.nextInt() % 5);
                    }
                    Explosion.generate(n, n2, 6, n4 + Enemy.rnd.nextInt() % 3 - 2);
                    break;
                }
                case 10: {
                    Explosion.explosionParam[n6 + 4] = -2;
                    Explosion.explosionParam[n6 + 5] = 4;
                    break;
                }
                case 9: {
                    Explosion.explosionParam[n6 + 4] = -2;
                }
                case 3: {
                    Explosion.explosionParam[n6 + 5] = 4;
                    Explosion.explosionParam[n6 + 0] = 2;
                    break;
                }
                case 4: {
                    Explosion.explosionParam[n6 + 5] = 5;
                    for (int i = 0; i < 4; ++i) {
                        Explosion.generate(n + 31, n2 + 27, 5, n4 + Enemy.rnd.nextInt() % 8);
                    }
                    Explosion.generate(n + 31, n2 + 27, 6, n4 + Enemy.rnd.nextInt() % 3 - 2);
                    break;
                }
                case 5: {
                    Explosion.explosionParam[n6 + 5] = 12;
                    Explosion.explosionParam[n6 + 6] = Enemy.rnd.nextInt() % 6 - 2;
                    break;
                }
                case 6: {
                    Explosion.explosionParam[n6 + 3] = n4 / 2 + Enemy.rnd.nextInt() % 2;
                    Explosion.explosionParam[n6 + 5] = 18;
                    Explosion.explosionParam[n6 + 6] = -Math.abs(Enemy.rnd.nextInt() % 3) - 1;
                    break;
                }
                case 7: {
                    Explosion.explosionParam[n6 + 3] = n4;
                    Explosion.explosionParam[n6 + 5] = Short.MAX_VALUE;
                    Explosion.explosionParam[n6 + 6] = -Math.abs(Enemy.rnd.nextInt() % 4) - 5;
                    break;
                }
                case 8: {
                    Explosion.explosionParam[n6 + 3] = n4;
                    Explosion.explosionParam[n6 + 5] = 2;
                    Explosion.explosionParam[n6 + 4] = 0;
                    int n8 = n6 + 1;
                    explosionParam[n8] = explosionParam[n8] - 15;
                    int n9 = n6 + 2;
                    explosionParam[n9] = explosionParam[n9] - 15;
                }
            }
        }
    }

    static void recomputeMaxExplosion() {
        if (explosionCurrentMax > 0) {
            while (explosionParam[(explosionCurrentMax - 1) * 7 + 0] == -1) {
                if (--explosionCurrentMax != 0) continue;
                return;
            }
        }
    }

    static void update() {
        int n = 0;
        int n2 = 0;
        while (n < explosionCurrentMax) {
            if (explosionParam[n2 + 0] != -1) {
                int n3 = n2 + 1;
                explosionParam[n3] = explosionParam[n3] + explosionParam[n2 + 3];
                int n4 = n2 + 4;
                explosionParam[n4] = explosionParam[n4] + 1;
                if (explosionParam[n2 + 0] == 9 && explosionParam[n2 + 4] == 0) {
                    int n5 = n2 + 4;
                    explosionParam[n5] = explosionParam[n5] + 1;
                }
                if (explosionParam[n2 + 0] == 10) {
                    int n6 = n2 + 2;
                    explosionParam[n6] = explosionParam[n6] + 4;
                }
                if (explosionParam[n2 + 0] == 5 || explosionParam[n2 + 0] == 7) {
                    int n7 = n2 + 2;
                    explosionParam[n7] = explosionParam[n7] + explosionParam[n2 + 6];
                    int n8 = n2 + 6;
                    explosionParam[n8] = explosionParam[n8] + 1;
                }
                if (explosionParam[n2 + 0] == 6) {
                    int n9 = n2 + 2;
                    explosionParam[n9] = explosionParam[n9] + explosionParam[n2 + 6];
                }
                if (explosionParam[n2 + 4] == explosionParam[n2 + 5]) {
                    Explosion.explosionParam[n2 + 0] = -1;
                    Explosion.recomputeMaxExplosion();
                }
                if (explosionParam[n2 + 2] > MOBCanvas.CANVAS_HEIGHT) {
                    Explosion.explosionParam[n2 + 0] = -1;
                    Explosion.recomputeMaxExplosion();
                }
            }
            ++n;
            n2 += 7;
        }
    }

    static void draw(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        while (n < explosionCurrentMax) {
            if (explosionParam[n2 + 0] != -1 && explosionParam[n2 + 4] >= 0) {
                switch (explosionParam[n2 + 0]) {
                    case 0: 
                    case 4: {
                        graphics.drawRegion(imgExplosion, 62 * explosionParam[n2 + 4], 0, 62, 55, 0, explosionParam[n2 + 1], explosionParam[n2 + 2], 0x10 | 4);
                        break;
                    }
                    case 2: 
                    case 10: {
                        graphics.drawRegion(imgSparks, 8 * explosionParam[n2 + 4], 0, 8, 8, 0, explosionParam[n2 + 1], explosionParam[n2 + 2], 0x10 | 4);
                        break;
                    }
                    case 1: {
                        switch (explosionParam[n2 + 4]) {
                            case 0: 
                            case 1: {
                                graphics.setColor(0, 0, 0);
                                break;
                            }
                            case 2: {
                                graphics.setColor(255, 0, 0);
                                break;
                            }
                            case 3: {
                                graphics.setColor(255, 255, 255);
                                break;
                            }
                            case 4: {
                                graphics.setColor(128, 128, 128);
                                break;
                            }
                            case 5: {
                                graphics.setColor(128, 128, 128);
                                break;
                            }
                            case 6: {
                                graphics.setColor(64, 64, 64);
                                break;
                            }
                            case 7: {
                                graphics.setColor(64, 64, 64);
                            }
                        }
                        graphics.fillRect(0, 0, MOBCanvas.CANVAS_WIDTH, MOBCanvas.CANVAS_HEIGHT);
                        break;
                    }
                    case 5: {
                        graphics.drawRegion(imgSparks, 8 * (explosionParam[n2 + 4] / 3), 0, 8, 8, 0, explosionParam[n2 + 1], explosionParam[n2 + 2], 0x10 | 4);
                        break;
                    }
                    case 6: {
                        graphics.drawRegion(imgSmoke, 20 * (explosionParam[n2 + 4] / 3), 0, 20, 20, 0, explosionParam[n2 + 1], explosionParam[n2 + 2], 0x10 | 4);
                        break;
                    }
                    case 7: {
                        graphics.drawImage(imgRock, explosionParam[n2 + 1], explosionParam[n2 + 2], 0x10 | 4);
                        break;
                    }
                    case 8: {
                        graphics.drawRegion(imgLaserGlare, 30 * (Math.abs(Enemy.rnd.nextInt()) % 3), 0, 30, 30, 0, explosionParam[n2 + 1], explosionParam[n2 + 2], 0x10 | 4);
                    }
                }
            }
            ++n;
            n2 += 7;
        }
    }
}

