/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Shot {
    public static final int MAX_LASER_LENGTH = 380;
    public static final int LASER_WIDTH = 3;
    public static final int LASER_DELTA_Y = 22;
    public static final int HERO_LASER_DELTA = 20;
    public static final int ADJUST_SHOT_DISTANCE_LASER = -4;
    public static final int ADJUST_ENEMY_DISTANCE_LASER = -16;
    public static final int FRAG_PLASMA_SPEED_X = 3;
    public static final int FRAG_PLASMA_SPEED_Y = -16;
    public static final int ROTOMINE_MAX_SPEED_X = 15;
    public static final int ROTOMINE_MAX_SPEED_Y = 8;
    public static final int MAX_BOMB_SPEED = 6;
    public static final int ADJUST_COLL_PARAM = 2;
    public static final int MAX_WEIGHT_PLASMA2 = 14;
    public static final int MAX_AUTOBOMB_SPEED = 4;
    public static final int MAX_MISSILE_SPEED = 5;
    public static final int PLASMA_BURST_SPEED = 5;
    public static final int BASIC_WEAPON_FRAMES = 10;
    public static Image imgHeroBullets;
    public static Image imgHeroRockets;
    public static Image imgHeroMissiles;
    public static Image imgHeroFlak;
    public static Image imgHeroMegaLaser;
    public static int[] heroShotParam;
    public static int heroShotCurrentMax;
    public static int heroLaserLength;
    public static int heroLaserNormalLength;
    public static int heroThunderStep;
    public static int heroThunderEnemy;
    public static int heroThunderStartPosX;
    public static int heroThunderStartPosY;
    public static int heroThunderEndPosX;
    public static int heroThunderEndPosY;
    public static int heroThunderAngle;
    public static int heroThunderLength;
    public static int addThunderStart;
    public static int addThunderEnd;
    public static final int SHOT_PARAM_TYPE = 0;
    public static final int SHOT_PARAM_XPOS = 1;
    public static final int SHOT_PARAM_YPOS = 2;
    public static final int SHOT_PARAM_WIDTH = 3;
    public static final int SHOT_PARAM_HEIGHT = 4;
    public static final int SHOT_PARAM_SPEED = 5;
    public static final int SHOT_PARAM_ANGLE = 6;
    public static final int SHOT_PARAM_POWER = 7;
    public static final int SHOT_PARAM_TARGET = 8;
    public static final int SHOT_PARAM_MAX = 9;
    public static final int MAX_SHOT = 80;
    public static final int SHOT_TYPE_NONE = -1;
    public static final int SHOT_HERO_NORMAL = 0;
    public static final int SHOT_HERO_ROCKET = 1;
    public static final int SHOT_HERO_HOMING = 2;
    public static final int SHOT_HERO_NUKE = 3;
    public static final int SHOT_HERO_FLAK = 4;
    public static final int SHOT_HERO_LASER = 5;
    public static final int SHOT_HERO_MEGALASER = 6;
    public static final int HOMING_ADDED_ANGLE = 4;
    public static Image imgEnemyBomb;
    public static Image imgEnemyIron;
    public static Image imgEnemyFrag;
    public static Image imgEnemyFat;
    public static Image imgEnemyPlasma;
    public static Image imgEnemyAutoBomb;
    public static Image imgEnemyMissile;
    public static Image imgEnemyRocket;
    public static Image imgEnemyMine;
    public static Image imgEnemyBoulder;
    public static Image imgEnemyMeteor;
    public static Image imgEnemyBurst;
    public static Image imgEnemyBolt;
    public static Image imgEnemyLaser;
    public static Image imgEnemyLaserBeam;
    public static final int SHOT_ENEMY_PARAM_MAX = 9;
    public static final int MAX_ENEMY_SHOT = 20;
    public static final int SHOT_ENEMY_NONE = -1;
    public static final int SHOT_ENEMY_BOMB = 0;
    public static final int SHOT_ENEMY_IRON = 1;
    public static final int SHOT_ENEMY_FRAG = 2;
    public static final int SHOT_ENEMY_FAT = 3;
    public static final int SHOT_ENEMY_PLASMA = 4;
    public static final int SHOT_ENEMY_AUTOBOMB = 5;
    public static final int SHOT_ENEMY_MISSILE = 6;
    public static final int SHOT_ENEMY_PLASMA2 = 7;
    public static final int SHOT_ENEMY_PLASMA3 = 8;
    public static final int SHOT_ENEMY_PLASMA4 = 9;
    public static final int SHOT_ENEMY_LASER = 10;
    public static final int SHOT_ENEMY_ROCKET = 11;
    public static final int SHOT_ENEMY_MINE = 12;
    public static final int SHOT_ENEMY_BOULDER = 13;
    public static final int SHOT_ENEMY_METEOR = 14;
    public static final int SHOT_ENEMY_BURST = 15;
    public static final int SHOT_ENEMY_BOLT = 16;
    public static final int SHOT_ENEMY_LASERBEAM = 17;
    public static final int SHOT_ENEMY_LASERBEAM2 = 18;
    public static final int AUTOBOMB_ADDED_ANGLE = 2;
    public static final int ENEMY_MISSILE_ADDED_ANGLE = 8;
    public static final short[] shotPoints;
    public static int[] enemyShotParam;
    public static int enemyShotCurrentMax;
    public static int lastLaserBeamRandom;
    public static int nbLaserBeamPoints;

    static void init(int n) {
        switch (n) {
            case 20: {
                imgHeroBullets = gameTopLevel.getImage("/bullets.png");
                break;
            }
            case 21: {
                imgHeroRockets = gameTopLevel.getImage("/rocket.png");
                break;
            }
            case 22: {
                imgHeroMissiles = gameTopLevel.getImage("/missile.png");
                break;
            }
            case 23: {
                imgHeroFlak = gameTopLevel.getImage("/flakflash.png");
                break;
            }
            case 24: {
                imgHeroMegaLaser = gameTopLevel.getImage("/megacircle.png");
                break;
            }
            case 25: {
                imgEnemyBomb = gameTopLevel.getImage("/dumbbomb.png");
                break;
            }
            case 26: {
                imgEnemyIron = gameTopLevel.getImage("/ironbomb.png");
                break;
            }
            case 27: {
                imgEnemyFrag = gameTopLevel.getImage("/fragbomb.png");
                break;
            }
            case 28: {
                imgEnemyFat = gameTopLevel.getImage("/fatboy.png");
                break;
            }
            case 29: {
                imgEnemyPlasma = gameTopLevel.getImage("/bombfrag.png");
                break;
            }
            case 30: {
                imgEnemyAutoBomb = gameTopLevel.getImage("/lgb.png");
                break;
            }
            case 31: {
                imgEnemyMissile = gameTopLevel.getImage("/hellfire.png");
                break;
            }
            case 32: {
                imgEnemyRocket = gameTopLevel.getImage("/rpg.png");
                break;
            }
            case 33: {
                imgEnemyLaser = gameTopLevel.getImage("/laserspark.png");
            }
        }
    }

    static void initLevel() {
        int n;
        heroShotParam = new int[720];
        for (n = 0; n < 80; ++n) {
            Shot.heroShotParam[n * 9 + 0] = -1;
        }
        heroShotCurrentMax = 0;
        enemyShotParam = new int[180];
        for (n = 0; n < 20; ++n) {
            Shot.enemyShotParam[n * 9 + 0] = -1;
        }
        enemyShotCurrentMax = 0;
        heroLaserNormalLength = 380;
        heroThunderStep = 0;
        heroThunderEndPosX = -1;
        heroThunderEnemy = -1;
        switch (inGame.levelNb & 0xFF) {
            case 2: 
            case 11: {
                imgEnemyMine = gameTopLevel.getImage("/airmine.png");
                imgEnemyMeteor = gameTopLevel.getImage("/meteorite.png");
                break;
            }
            case 4: 
            case 13: {
                imgEnemyBurst = gameTopLevel.getImage("/burstrocket.png");
                break;
            }
            case 5: 
            case 14: {
                imgEnemyBolt = gameTopLevel.getImage("/bolt.png");
                break;
            }
            case 12: 
            case 16: {
                imgEnemyBoulder = gameTopLevel.getImage("/boulder.png");
                break;
            }
            case 18: {
                imgEnemyLaserBeam = gameTopLevel.getImage("/laserbeam.png");
            }
        }
    }

    static void closeLevel() {
        heroShotParam = null;
        enemyShotParam = null;
        imgEnemyMine = null;
        imgEnemyBoulder = null;
        imgEnemyMeteor = null;
        imgEnemyBurst = null;
        imgEnemyBolt = null;
        imgEnemyLaserBeam = null;
    }

    static void generate(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        while (n7 < 80 && heroShotParam[n8 + 0] != -1) {
            ++n7;
            n8 += 9;
        }
        if (n7 != 80) {
            if (heroShotCurrentMax < n7 + 1) {
                heroShotCurrentMax = n7 + 1;
            }
            Shot.heroShotParam[n8 + 0] = n3;
            Shot.heroShotParam[n8 + 1] = n * 1024;
            Shot.heroShotParam[n8 + 2] = n2 * 1024;
            Shot.heroShotParam[n8 + 6] = n5;
            Shot.heroShotParam[n8 + 5] = n4;
            Shot.heroShotParam[n8 + 7] = n6;
            switch (n3) {
                case 0: {
                    Shot.heroShotParam[n8 + 3] = imgHeroBullets.getWidth() / 11;
                    Shot.heroShotParam[n8 + 4] = imgHeroBullets.getHeight() / 5;
                    break;
                }
                case 1: {
                    Shot.heroShotParam[n8 + 3] = imgHeroRockets.getWidth() / 11;
                    Shot.heroShotParam[n8 + 4] = imgHeroRockets.getHeight();
                    break;
                }
                case 2: {
                    Shot.heroShotParam[n8 + 3] = imgHeroMissiles.getWidth() / 20;
                    Shot.heroShotParam[n8 + 4] = imgHeroMissiles.getHeight();
                    Shot.heroShotParam[n8 + 8] = Enemy.getTarget(heroShotParam[n8 + 2] >> 10);
                    break;
                }
                case 3: {
                    Shot.heroShotParam[n8 + 3] = MOBCanvas.CANVAS_WIDTH;
                    Shot.heroShotParam[n8 + 4] = MOBCanvas.CANVAS_HEIGHT;
                    Shot.heroShotParam[n8 + 8] = 0;
                    break;
                }
                case 4: {
                    Shot.heroShotParam[n8 + 3] = imgHeroFlak.getWidth() / 3;
                    Shot.heroShotParam[n8 + 4] = imgHeroFlak.getHeight();
                    Shot.heroShotParam[n8 + 6] = 0;
                    Shot.heroShotParam[n8 + 8] = heroShotParam[n8 + 7] / 2;
                    break;
                }
                case 5: {
                    Shot.heroShotParam[n8 + 3] = 0;
                    Shot.heroShotParam[n8 + 4] = 0;
                    Shot.heroShotParam[n8 + 8] = heroShotParam[n8 + 7];
                    Shot.heroShotParam[n8 + 5] = n4;
                    break;
                }
                case 6: {
                    Shot.heroShotParam[n8 + 3] = imgHeroMegaLaser.getWidth() / 5;
                    Shot.heroShotParam[n8 + 4] = imgHeroMegaLaser.getHeight();
                    Shot.heroShotParam[n8 + 5] = 0;
                }
            }
        }
    }

    static void generateEnemy(int n, int n2, int n3, int n4, int n5) {
        if (n3 == -1) {
            return;
        }
        int n6 = 0;
        int n7 = 0;
        while (n6 < 20 && enemyShotParam[n7 + 0] != -1) {
            ++n6;
            n7 += 9;
        }
        if (n6 != 20) {
            if (enemyShotCurrentMax < n6 + 1) {
                enemyShotCurrentMax = n6 + 1;
            }
            Shot.enemyShotParam[n7 + 0] = n3;
            Shot.enemyShotParam[n7 + 1] = n * 1024;
            Shot.enemyShotParam[n7 + 2] = n2 * 1024;
            Shot.enemyShotParam[n7 + 7] = 1;
            block0 : switch (n3) {
                case 0: {
                    Shot.enemyShotParam[n7 + 3] = imgEnemyBomb.getWidth() / 10;
                    Shot.enemyShotParam[n7 + 4] = imgEnemyBomb.getHeight();
                    break;
                }
                case 1: {
                    Shot.enemyShotParam[n7 + 3] = imgEnemyIron.getWidth() / 10;
                    Shot.enemyShotParam[n7 + 4] = imgEnemyIron.getHeight();
                    break;
                }
                case 2: {
                    Shot.enemyShotParam[n7 + 3] = imgEnemyFrag.getWidth() / 10;
                    Shot.enemyShotParam[n7 + 4] = imgEnemyFrag.getHeight();
                    break;
                }
                case 3: {
                    Shot.enemyShotParam[n7 + 7] = 30;
                    Shot.enemyShotParam[n7 + 3] = imgEnemyFat.getWidth() / 10;
                    Shot.enemyShotParam[n7 + 4] = imgEnemyFat.getHeight();
                    break;
                }
                case 4: 
                case 7: 
                case 8: {
                    Shot.enemyShotParam[n7 + 7] = 65535;
                    Shot.enemyShotParam[n7 + 3] = imgEnemyPlasma.getWidth();
                    Shot.enemyShotParam[n7 + 4] = imgEnemyPlasma.getHeight();
                    break;
                }
                case 9: {
                    Shot.enemyShotParam[n7 + 7] = 65535;
                    Shot.enemyShotParam[n7 + 3] = imgEnemyPlasma.getWidth();
                    Shot.enemyShotParam[n7 + 4] = imgEnemyPlasma.getHeight();
                    break;
                }
                case 5: {
                    Shot.enemyShotParam[n7 + 3] = imgEnemyAutoBomb.getWidth() / 10;
                    Shot.enemyShotParam[n7 + 4] = imgEnemyAutoBomb.getHeight();
                    break;
                }
                case 6: {
                    Shot.enemyShotParam[n7 + 3] = imgEnemyMissile.getWidth() / 6;
                    Shot.enemyShotParam[n7 + 4] = imgEnemyMissile.getHeight() / 2;
                    Shot.enemyShotParam[n7 + 8] = 0;
                    break;
                }
                case 12: {
                    Shot.enemyShotParam[n7 + 7] = 8;
                    Shot.enemyShotParam[n7 + 3] = imgEnemyMine.getWidth();
                    Shot.enemyShotParam[n7 + 4] = imgEnemyMine.getHeight();
                    break;
                }
                case 15: {
                    Shot.enemyShotParam[n7 + 7] = 50;
                    Shot.enemyShotParam[n7 + 3] = imgEnemyBurst.getWidth() / 3;
                    Shot.enemyShotParam[n7 + 4] = imgEnemyBurst.getHeight();
                    break;
                }
                case 11: {
                    Shot.enemyShotParam[n7 + 3] = imgEnemyRocket.getWidth() / 10;
                    Shot.enemyShotParam[n7 + 4] = imgEnemyRocket.getHeight();
                    break;
                }
                case 13: {
                    Shot.enemyShotParam[n7 + 3] = imgEnemyBoulder.getWidth();
                    Shot.enemyShotParam[n7 + 4] = imgEnemyBoulder.getHeight();
                    break;
                }
                case 14: {
                    Shot.enemyShotParam[n7 + 7] = 65535;
                    Shot.enemyShotParam[n7 + 3] = imgEnemyMeteor.getWidth() / 4;
                    Shot.enemyShotParam[n7 + 4] = imgEnemyMeteor.getHeight();
                    break;
                }
                case 16: {
                    Shot.enemyShotParam[n7 + 7] = 65535;
                    Shot.enemyShotParam[n7 + 3] = imgEnemyBolt.getWidth();
                    Shot.enemyShotParam[n7 + 4] = imgEnemyBolt.getHeight();
                    break;
                }
                case 17: {
                    lastLaserBeamRandom = Math.abs(Enemy.rnd.nextInt()) % 3;
                    nbLaserBeamPoints = 1;
                    Shot.enemyShotParam[n7 + 7] = 65535;
                    switch (lastLaserBeamRandom) {
                        case 0: {
                            n5 = 192;
                            Shot.enemyShotParam[n7 + 3] = imgEnemyLaserBeam.getWidth();
                            Shot.enemyShotParam[n7 + 4] = imgEnemyLaserBeam.getHeight() * 4;
                            break;
                        }
                        case 1: {
                            n5 = 224;
                            Shot.enemyShotParam[n7 + 3] = imgEnemyLaserBeam.getWidth() * 3;
                            Shot.enemyShotParam[n7 + 4] = imgEnemyLaserBeam.getHeight() * 3;
                            break;
                        }
                        case 2: {
                            n5 = 192;
                            Shot.enemyShotParam[n7 + 3] = imgEnemyLaserBeam.getWidth() * 3;
                            Shot.enemyShotParam[n7 + 4] = imgEnemyLaserBeam.getHeight() * 3;
                            Shot.enemyShotParam[n7 + 8] = 3;
                        }
                    }
                    break;
                }
                case 18: {
                    Shot.enemyShotParam[n7 + 7] = 65535;
                    switch (lastLaserBeamRandom) {
                        case 0: {
                            n5 = 192;
                            Shot.enemyShotParam[n7 + 3] = imgEnemyLaserBeam.getWidth();
                            Shot.enemyShotParam[n7 + 4] = imgEnemyLaserBeam.getHeight() * 4;
                            break block0;
                        }
                        case 1: {
                            n5 = 160;
                            Shot.enemyShotParam[n7 + 3] = imgEnemyLaserBeam.getWidth() * 3;
                            Shot.enemyShotParam[n7 + 4] = imgEnemyLaserBeam.getHeight() * 3;
                            break block0;
                        }
                        case 2: {
                            n5 = 192;
                            Shot.enemyShotParam[n7 + 3] = imgEnemyLaserBeam.getWidth() * 3;
                            Shot.enemyShotParam[n7 + 4] = imgEnemyLaserBeam.getHeight() * 3;
                            Shot.enemyShotParam[n7 + 8] = -3;
                        }
                    }
                }
            }
            if (n3 == 4 || n3 == 14) {
                if (n3 == 14) {
                    Shot.enemyShotParam[n7 + 6] = (Enemy.rnd.nextInt() & 7) == 0 ? gameTopLevel.ratan2(n2 - (Hero.tankPosY + Hero.tankHeight / 2), Hero.tankPosX + Hero.tankWidth / 2 - n) / 16 : gameTopLevel.ratan2(n2 - (Hero.tankPosY + Hero.tankHeight / 2), Math.abs(Enemy.rnd.nextInt() % MOBCanvas.CANVAS_WIDTH) - n) / 16;
                } else {
                    Shot.enemyShotParam[n7 + 6] = gameTopLevel.ratan2(n2 - (Hero.tankPosY + Hero.tankHeight / 2), Hero.tankPosX + Hero.tankWidth / 2 - n) / 16;
                    if (enemyShotParam[n7 + 6] < 160) {
                        Shot.enemyShotParam[n7 + 6] = 160;
                    }
                    if (enemyShotParam[n7 + 6] > 224) {
                        Shot.enemyShotParam[n7 + 6] = 224;
                    }
                }
                Shot.enemyShotParam[n7 + 5] = Math.abs(n4);
            } else {
                if (n3 == 5) {
                    Shot.enemyShotParam[n7 + 5] = 4;
                } else if (n3 == 6) {
                    Shot.enemyShotParam[n7 + 5] = n4 < 5 ? 5 : n4;
                    Shot.enemyShotParam[n7 + 8] = 0;
                } else {
                    Shot.enemyShotParam[n7 + 5] = n4;
                }
                if (n3 == 8 || n3 == 9) {
                    Shot.enemyShotParam[n7 + 0] = 4;
                }
                Shot.enemyShotParam[n7 + 6] = n5;
            }
        }
    }

    static void generateEnemyEnd(int n, int n2, int n3, int n4, int n5) {
        if (n3 == -1) {
            return;
        }
        if (enemyShotCurrentMax != 20) {
            int n6 = enemyShotCurrentMax * 9;
            ++enemyShotCurrentMax;
            Shot.enemyShotParam[n6 + 0] = n3;
            Shot.enemyShotParam[n6 + 1] = n * 1024;
            Shot.enemyShotParam[n6 + 2] = n2 * 1024;
            Shot.enemyShotParam[n6 + 7] = 1;
            Shot.enemyShotParam[n6 + 5] = n4;
            Shot.enemyShotParam[n6 + 6] = n5;
        }
    }

    static void recomputeMaxHeroShot() {
        if (heroShotCurrentMax > 0) {
            while (heroShotParam[(heroShotCurrentMax - 1) * 9 + 0] == -1) {
                if (--heroShotCurrentMax != 0) continue;
                return;
            }
        }
    }

    static void recomputeMaxEnemyShot() {
        if (enemyShotCurrentMax > 0) {
            while (enemyShotParam[(enemyShotCurrentMax - 1) * 9 + 0] == -1) {
                if (--enemyShotCurrentMax != 0) continue;
                return;
            }
        }
    }

    static void clearNukeShot() {
        int n = 0;
        int n2 = 0;
        while (n < heroShotCurrentMax) {
            if (heroShotParam[n2 + 0] == 3) {
                Shot.heroShotParam[n2 + 0] = -1;
                Shot.recomputeMaxHeroShot();
                return;
            }
            ++n;
            n2 += 9;
        }
    }

    static void clearLaserShot() {
        int n = 0;
        int n2 = 0;
        while (n < heroShotCurrentMax) {
            if (heroShotParam[n2 + 0] == 5) {
                Shot.heroShotParam[n2 + 0] = -1;
                Shot.recomputeMaxHeroShot();
                return;
            }
            ++n;
            n2 += 9;
        }
    }

    static int sqrt(int n) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = n >= 65536 ? 15 : 7;
        int n6 = 1 << n5 * 2;
        int n7 = n5;
        do {
            if ((n2 = n4 + (n3 << n7 + 1) + n6) <= n) {
                n4 = n2;
                n3 |= 1 << n7;
            }
            if (n2 == n) continue;
            n6 >>= 2;
            --n7;
        } while (n7 >= 0 && n2 != n);
        return n3;
    }

    static void destroyLaserShot(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < enemyShotCurrentMax) {
            if (enemyShotParam[n3 + 0] == 10 && enemyShotParam[n3 + 5] == n) {
                Shot.enemyShotParam[n3 + 0] = -1;
                Shot.recomputeMaxEnemyShot();
                return;
            }
            ++n2;
            n3 += 9;
        }
    }

    static void destroyAllEnemyShots() {
        int n = 0;
        int n2 = 0;
        while (n < enemyShotCurrentMax) {
            if (enemyShotParam[n2 + 0] != -1) {
                Explosion.generate(enemyShotParam[n2 + 1] / 1024 - (62 - enemyShotParam[n2 + 3]) / 2, enemyShotParam[n2 + 2] / 1024 - (55 - enemyShotParam[n2 + 4]) / 2, 4, 0);
                Board.score += shotPoints[enemyShotParam[n2 + 0]];
                Board.drawStatus |= 2;
                if (inGame.levelNb != 255) {
                    Bonus.generateString("" + shotPoints[enemyShotParam[n2 + 0]], enemyShotParam[n2 + 1] / 1024, enemyShotParam[n2 + 2] / 1024, true);
                }
                Shot.enemyShotParam[n2 + 0] = -1;
            }
            ++n;
            n2 += 9;
        }
        enemyShotCurrentMax = 0;
    }

    /*
     * Unable to fully structure code
     */
    static void update() {
        if (Hero.staticNb > 0) {
            if ((inGame.gameStatus & 15) != 0) {
                Shot.heroThunderStep = 0;
                Shot.heroThunderEndPosX = -1;
                Shot.heroThunderEnemy = -1;
            } else if (Boss.life == 0 || Boss.active && !Boss.canBeHit || Board.laserused != 0) {
                Shot.heroThunderStep = 0;
                Shot.heroThunderEndPosX = -1;
                Shot.heroThunderEnemy = -1;
            } else {
                if (Shot.heroThunderEndPosX < 0) {
                    Shot.heroThunderEndPosX = Hero.tankPosX + Hero.tankWidth / 2;
                    Shot.heroThunderEndPosY = Hero.tankPosY;
                }
                switch (Shot.heroThunderStep++) {
                    case 0: {
                        var2 = Shot.heroThunderEnemy;
                        Shot.heroThunderStartPosX = Shot.heroThunderEndPosX;
                        Shot.heroThunderStartPosY = Shot.heroThunderEndPosY;
                        Shot.heroThunderEnemy = Enemy.getClosest(Shot.heroThunderEndPosX, Shot.heroThunderEndPosY, var2);
                        if (Shot.heroThunderEnemy == -1) {
                            if (var2 < 0) {
                                Shot.heroThunderAngle = 48 + Math.abs(Enemy.rnd.nextInt()) % 32;
                                Shot.heroThunderLength = 60;
                            } else {
                                var3_1 = Hero.tankPosX + Hero.tankWidth / 2 - Shot.heroThunderEndPosX;
                                var4_2 = Shot.heroThunderEndPosY - Hero.tankPosY;
                                Shot.heroThunderAngle = gameTopLevel.ratan2(var4_2, var3_1) / 16;
                                Shot.heroThunderLength = Shot.sqrt(var3_1 * var3_1 + var4_2 * var4_2) / 4;
                                Shot.heroThunderEnemy = -2;
                            }
                        } else {
                            var3_1 = Enemy.getCenterX(Shot.heroThunderEnemy) - Shot.heroThunderEndPosX;
                            var4_2 = Shot.heroThunderEndPosY - Enemy.getCenterY(Shot.heroThunderEnemy);
                            Shot.heroThunderAngle = gameTopLevel.ratan2(var4_2, var3_1) / 16;
                            Shot.heroThunderLength = Shot.sqrt(var3_1 * var3_1 + var4_2 * var4_2) / 4;
                        }
                        Shot.heroThunderEndPosX = Shot.heroThunderStartPosX + Shot.heroThunderLength * gameTopLevel.cos(Shot.heroThunderAngle) / 1024;
                        Shot.heroThunderEndPosY = Shot.heroThunderStartPosY - Shot.heroThunderLength * gameTopLevel.sin(Shot.heroThunderAngle) / 1024;
                        Shot.addThunderStart = 1;
                        break;
                    }
                    case 1: {
                        Shot.heroThunderStartPosX = Shot.heroThunderEndPosX;
                        Shot.heroThunderStartPosY = Shot.heroThunderEndPosY;
                        Shot.heroThunderEndPosX = Shot.heroThunderStartPosX + Shot.heroThunderLength * gameTopLevel.cos(Shot.heroThunderAngle) / 1024;
                        Shot.heroThunderEndPosY = Shot.heroThunderStartPosY - Shot.heroThunderLength * gameTopLevel.sin(Shot.heroThunderAngle) / 1024;
                        Shot.addThunderEnd = 1;
                        break;
                    }
                    case 2: {
                        Shot.heroThunderStartPosX = Shot.heroThunderEndPosX;
                        Shot.heroThunderStartPosY = Shot.heroThunderEndPosY;
                        Shot.heroThunderLength = 20;
                        Shot.heroThunderEndPosX = Shot.heroThunderStartPosX + Shot.heroThunderLength * gameTopLevel.cos(Shot.heroThunderAngle -= 72) / 1024;
                        Shot.heroThunderEndPosY = Shot.heroThunderStartPosY - Shot.heroThunderLength * gameTopLevel.sin(Shot.heroThunderAngle) / 1024;
                        break;
                    }
                    case 3: {
                        Shot.heroThunderStartPosX = Shot.heroThunderEndPosX;
                        Shot.heroThunderStartPosY = Shot.heroThunderEndPosY;
                        if (Shot.heroThunderEnemy < 0) {
                            if (Shot.heroThunderEnemy == -1) {
                                Shot.heroThunderLength = 70;
                                Shot.heroThunderAngle += 72;
                            }
                            if (Shot.heroThunderEnemy == -2) {
                                var3_1 = Hero.tankPosX + Hero.tankWidth / 2 - Shot.heroThunderEndPosX;
                                var4_2 = Shot.heroThunderEndPosY - Hero.tankPosY;
                                Shot.heroThunderAngle = gameTopLevel.ratan2(var4_2, var3_1) / 16;
                                Shot.heroThunderLength = Shot.sqrt(var3_1 * var3_1 + var4_2 * var4_2) / 2;
                                Shot.heroThunderEnemy = -2;
                            }
                        } else {
                            var3_1 = Enemy.getCenterX(Shot.heroThunderEnemy) - Shot.heroThunderEndPosX;
                            var4_2 = Shot.heroThunderEndPosY - Enemy.getCenterY(Shot.heroThunderEnemy);
                            Shot.heroThunderAngle = gameTopLevel.ratan2(var4_2, var3_1) / 16;
                            Shot.heroThunderLength = Shot.sqrt(var3_1 * var3_1 + var4_2 * var4_2) / 2;
                        }
                        Shot.heroThunderEndPosX = Shot.heroThunderStartPosX + Shot.heroThunderLength * gameTopLevel.cos(Shot.heroThunderAngle) / 1024;
                        Shot.heroThunderEndPosY = Shot.heroThunderStartPosY - Shot.heroThunderLength * gameTopLevel.sin(Shot.heroThunderAngle) / 1024;
                        break;
                    }
                    case 4: {
                        Shot.heroThunderStartPosX = Shot.heroThunderEndPosX;
                        Shot.heroThunderStartPosY = Shot.heroThunderEndPosY;
                        if (Shot.heroThunderEnemy < 0) {
                            if (Shot.heroThunderEnemy == -1) {
                                Shot.heroThunderEndPosX = Shot.heroThunderStartPosX + Shot.heroThunderLength * gameTopLevel.cos(Shot.heroThunderAngle) / 1024;
                                Shot.heroThunderEndPosY = Shot.heroThunderStartPosY - Shot.heroThunderLength * gameTopLevel.sin(Shot.heroThunderAngle) / 1024;
                            }
                            if (Shot.heroThunderEnemy == -2) {
                                Shot.heroThunderEndPosX = Hero.tankPosX + Hero.tankWidth / 2;
                                Shot.heroThunderEndPosY = Hero.tankPosY;
                            }
                        } else {
                            Shot.heroThunderEndPosX = Enemy.getCenterX(Shot.heroThunderEnemy);
                            Shot.heroThunderEndPosY = Enemy.getCenterY(Shot.heroThunderEnemy);
                        }
                        Shot.addThunderEnd = 0;
                        break;
                    }
                    case 5: {
                        if (Shot.heroThunderEnemy < 0) break;
                        Shot.heroThunderStep = 0;
                        var1_3 = Shot.heroThunderEnemy * 15;
                        v0 = var1_3 + 12;
                        Enemy.enemyParams[v0] = Enemy.enemyParams[v0] - Hero.staticNb;
                        if (Enemy.enemyParams[var1_3 + 12] > 0) break;
                        Enemy.dead(var1_3, -1);
                        break;
                    }
                    case 10: {
                        Shot.heroThunderStep = 0;
                        Shot.heroThunderEndPosX = -1;
                        Shot.heroThunderEnemy = -1;
                    }
                }
            }
        }
        var0_4 = 0;
        var1_3 = 0;
        while (var0_4 < Shot.heroShotCurrentMax) {
            block130: {
                if (Shot.heroShotParam[var1_3 + 0] == -1) break block130;
                if (Shot.heroShotParam[var1_3 + 0] == 2) {
                    if (Shot.heroShotParam[var1_3 + 8] < 0) {
                        if (Shot.heroShotParam[var1_3 + 8] == -1) {
                            Shot.heroShotParam[var1_3 + 8] = Enemy.getTarget(Shot.heroShotParam[var1_3 + 2] >> 10);
                        }
                    } else {
                        var2 = Shot.heroShotParam[var1_3 + 8];
                        if (Enemy.enemyParams[var2 * 15 + 0] == -1 && (inGame.gameStatus & 64) == 0) {
                            Shot.heroShotParam[var1_3 + 8] = Enemy.getTarget(Shot.heroShotParam[var1_3 + 2] >> 10);
                        } else {
                            var3_1 = Enemy.getAngle(Shot.heroShotParam[var1_3 + 1] / 1024, Shot.heroShotParam[var1_3 + 2] / 1024, var2);
                            var4_2 = Shot.heroShotParam[var1_3 + 6];
                            var5_5 = var4_2 - var3_1;
                            var6_6 = var4_2 + 256 - var3_1;
                            var7_7 = var4_2 - (var3_1 + 256);
                            var8_8 = var5_5;
                            if (Math.abs(var6_6) < Math.abs(var8_8)) {
                                var8_8 = var6_6;
                            }
                            if (Math.abs(var7_7) < Math.abs(var8_8)) {
                                var8_8 = var7_7;
                            }
                            if (var8_8 < 0) {
                                v1 = var1_3 + 6;
                                Shot.heroShotParam[v1] = Shot.heroShotParam[v1] + 4;
                                if (Shot.heroShotParam[var1_3 + 6] > 256) {
                                    v2 = var1_3 + 6;
                                    Shot.heroShotParam[v2] = Shot.heroShotParam[v2] - 256;
                                }
                            } else if (var8_8 > 0) {
                                v3 = var1_3 + 6;
                                Shot.heroShotParam[v3] = Shot.heroShotParam[v3] - 4;
                                if (Shot.heroShotParam[var1_3 + 6] < 0) {
                                    v4 = var1_3 + 6;
                                    Shot.heroShotParam[v4] = Shot.heroShotParam[v4] + 256;
                                }
                            }
                        }
                    }
                }
                if (Shot.heroShotParam[var1_3 + 0] != 4) ** GOTO lbl-1000
                v5 = var1_3 + 6;
                Shot.heroShotParam[v5] = Shot.heroShotParam[v5] + 1;
                if (Shot.heroShotParam[var1_3 + 6] != 3) ** GOTO lbl-1000
                Shot.heroShotParam[var1_3 + 6] = 0;
                v6 = var1_3 + 8;
                Shot.heroShotParam[v6] = Shot.heroShotParam[v6] - 1;
                if (Shot.heroShotParam[var1_3 + 8] == 0) {
                    Shot.heroShotParam[var1_3 + 0] = -1;
                } else if (Shot.heroShotParam[var1_3 + 0] == 5) {
                    Shot.heroShotParam[var1_3 + 1] = (Hero.tankPosX + Hero.tankWidth / 2) * 1024;
                    var2 = (Shot.heroShotParam[var1_3 + 1] + 20 * gameTopLevel.cos(Hero.targetAngle)) / 1024;
                    var3_1 = (Shot.heroShotParam[var1_3 + 2] - 20 * gameTopLevel.sin(Hero.targetAngle)) / 1024;
                    var4_2 = gameTopLevel.ratan2(var3_1 - Hero.targetPosY, Hero.targetPosX - var2);
                    var4_2 = (var4_2 & 15) > 7 ? (var4_2 /= 16) : (var4_2 /= 16);
                    Shot.heroShotParam[var1_3 + 6] = ++var4_2;
                    v7 = var1_3 + 5;
                    Shot.heroShotParam[v7] = Shot.heroShotParam[v7] + 1;
                    if (Shot.heroShotParam[var1_3 + 5] == 10) {
                        Shot.heroShotParam[var1_3 + 0] = -1;
                    }
                } else {
                    if (Shot.heroShotParam[var1_3 + 0] == 1 || Shot.heroShotParam[var1_3 + 0] == 2) {
                        if (Shot.heroShotParam[var1_3 + 0] == 2) {
                            var2 = Shot.imgHeroMissiles.getWidth() / 6;
                            var3_1 = Shot.imgHeroMissiles.getHeight() / 2;
                        } else {
                            var2 = Shot.imgHeroRockets.getWidth() / 11 + 1;
                            var3_1 = Shot.imgHeroRockets.getHeight() + 1;
                        }
                        Explosion.generate((Shot.heroShotParam[var1_3 + 1] >> 10) - 4, (Shot.heroShotParam[var1_3 + 2] >> 10) - 4, 3, 0);
                    }
                    v8 = var1_3 + 1;
                    Shot.heroShotParam[v8] = Shot.heroShotParam[v8] + Shot.heroShotParam[var1_3 + 5] * gameTopLevel.cos(Shot.heroShotParam[var1_3 + 6]);
                    v9 = var1_3 + 2;
                    Shot.heroShotParam[v9] = Shot.heroShotParam[v9] - Shot.heroShotParam[var1_3 + 5] * gameTopLevel.sin(Shot.heroShotParam[var1_3 + 6]);
                    if (Shot.heroShotParam[var1_3 + 1] / 1024 < -20 || Shot.heroShotParam[var1_3 + 1] / 1024 > MOBCanvas.CANVAS_WIDTH + 20 || Shot.heroShotParam[var1_3 + 2] / 1024 < Board.imgHUD.getHeight() - 10 || Shot.heroShotParam[var1_3 + 2] / 1024 > MOBCanvas.CANVAS_HEIGHT) {
                        Shot.heroShotParam[var1_3 + 0] = -1;
                    }
                }
            }
            ++var0_4;
            var1_3 += 9;
        }
        Shot.recomputeMaxHeroShot();
        var0_4 = 0;
        var1_3 = 0;
        while (var0_4 < Shot.enemyShotCurrentMax) {
            if (Shot.enemyShotParam[var1_3 + 0] != -1) {
                switch (Shot.enemyShotParam[var1_3 + 0]) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        var2 = Shot.enemyShotParam[var1_3 + 6];
                        if (var2 < 184) {
                            v10 = var1_3 + 6;
                            Shot.enemyShotParam[v10] = Shot.enemyShotParam[v10] + 2;
                        }
                        if (var2 > 200) {
                            v11 = var1_3 + 6;
                            Shot.enemyShotParam[v11] = Shot.enemyShotParam[v11] - 2;
                        }
                        if ((var2 == 144 || var2 == 160 || var2 == 176 || var2 == 240 || var2 == 224 || var2 == 208) && Shot.enemyShotParam[var1_3 + 5] < 6) {
                            v12 = var1_3 + 5;
                            Shot.enemyShotParam[v12] = Shot.enemyShotParam[v12] + 1;
                        }
                        v13 = var1_3 + 1;
                        Shot.enemyShotParam[v13] = Shot.enemyShotParam[v13] + Shot.enemyShotParam[var1_3 + 5] * gameTopLevel.cos(Shot.enemyShotParam[var1_3 + 6]);
                        v14 = var1_3 + 2;
                        Shot.enemyShotParam[v14] = Shot.enemyShotParam[v14] - Shot.enemyShotParam[var1_3 + 5] * gameTopLevel.sin(Shot.enemyShotParam[var1_3 + 6]);
                        if (Shot.enemyShotParam[var1_3 + 2] / 1024 > Hero.tankPosY + Hero.tankHeight) {
                            if (Shot.enemyShotParam[var1_3 + 0] == 3) {
                                Explosion.generate(Shot.enemyShotParam[var1_3 + 1] / 1024 - (62 - Shot.enemyShotParam[var1_3 + 3]) / 2, RandomObject.randomObjectPosY - (55 - Shot.enemyShotParam[var1_3 + 4]) / 2, 0, 0);
                                Explosion.generate(0, 0, 1, 0);
                                if ((inGame.gameStatus & 12) == 0) {
                                    Hero.dead();
                                }
                            } else {
                                Explosion.generate(Shot.enemyShotParam[var1_3 + 1] / 1024 - (62 - Shot.enemyShotParam[var1_3 + 3]) / 2, RandomObject.randomObjectPosY - (55 - Shot.enemyShotParam[var1_3 + 4]) / 2, 4, 0);
                                if (Shot.enemyShotParam[var1_3 + 0] == 2) {
                                    Shot.generateEnemyEnd(Shot.enemyShotParam[var1_3 + 1] / 1024, Shot.enemyShotParam[var1_3 + 2] / 1024, 7, -3, -16);
                                    Shot.generateEnemyEnd(Shot.enemyShotParam[var1_3 + 1] / 1024, Shot.enemyShotParam[var1_3 + 2] / 1024, 7, 0, -16);
                                    Shot.generateEnemyEnd(Shot.enemyShotParam[var1_3 + 1] / 1024, Shot.enemyShotParam[var1_3 + 2] / 1024, 7, 3, -16);
                                }
                            }
                            RandomObject.addCrater(Shot.enemyShotParam[var1_3 + 1] / 1024 + Shot.enemyShotParam[var1_3 + 3] / 2, false);
                            Shot.enemyShotParam[var1_3 + 0] = -1;
                        }
                        if (Shot.enemyShotParam[var1_3 + 1] / 1024 >= -8 && Shot.enemyShotParam[var1_3 + 1] / 1024 <= MOBCanvas.CANVAS_WIDTH + 8) break;
                        Shot.enemyShotParam[var1_3 + 0] = -1;
                        break;
                    }
                    case 10: {
                        Shot.enemyShotParam[var1_3 + 1] = Enemy.getCenterX(Shot.enemyShotParam[var1_3 + 5]) - 1 << 10;
                        Shot.enemyShotParam[var1_3 + 2] = Enemy.getCenterY(Shot.enemyShotParam[var1_3 + 5]) + 22 << 10;
                        v15 = var1_3 + 6;
                        Shot.enemyShotParam[v15] = Shot.enemyShotParam[v15] - 1;
                        if (Shot.enemyShotParam[var1_3 + 6] == 0) {
                            Shot.enemyShotParam[var1_3 + 0] = -1;
                        }
                        if (Enemy.enemyParams[Shot.enemyShotParam[var1_3 + 5] * 15 + 0] == 19) break;
                        Shot.enemyShotParam[var1_3 + 0] = -1;
                        break;
                    }
                    case 16: {
                        v16 = var1_3 + 6;
                        Shot.enemyShotParam[v16] = Shot.enemyShotParam[v16] - 1;
                        if (Shot.enemyShotParam[var1_3 + 6] != 0) break;
                        Shot.enemyShotParam[var1_3 + 0] = -1;
                        break;
                    }
                    case 5: 
                    case 6: {
                        var2 = gameTopLevel.ratan2(Shot.enemyShotParam[var1_3 + 2] / 1024 - (Hero.tankPosY + Hero.tankHeight / 2), Hero.tankPosX + Hero.tankWidth / 2 - Shot.enemyShotParam[var1_3 + 1] / 1024) / 16;
                        if (Shot.enemyShotParam[var1_3 + 0] == 5) {
                            if (Shot.enemyShotParam[var1_3 + 6] < 160) {
                                v17 = var1_3 + 6;
                                Shot.enemyShotParam[v17] = Shot.enemyShotParam[v17] + 2;
                            } else if (Shot.enemyShotParam[var1_3 + 6] > 224) {
                                v18 = var1_3 + 6;
                                Shot.enemyShotParam[v18] = Shot.enemyShotParam[v18] - 2;
                            } else {
                                if (var2 < Shot.enemyShotParam[var1_3 + 6]) {
                                    v19 = var1_3 + 6;
                                    Shot.enemyShotParam[v19] = Shot.enemyShotParam[v19] - 2;
                                }
                                if (var2 > Shot.enemyShotParam[var1_3 + 6]) {
                                    v20 = var1_3 + 6;
                                    Shot.enemyShotParam[v20] = Shot.enemyShotParam[v20] + 2;
                                }
                            }
                        } else {
                            var3_1 = Shot.enemyShotParam[var1_3 + 6];
                            var4_2 = var3_1 - var2;
                            var5_5 = var3_1 + 256 - var2;
                            var6_6 = var3_1 - (var2 + 256);
                            var8_8 = var4_2;
                            if (Math.abs(var5_5) < Math.abs(var8_8)) {
                                var8_8 = var5_5;
                            }
                            if (Math.abs(var6_6) < Math.abs(var8_8)) {
                                var8_8 = var6_6;
                            }
                            v21 = var1_3 + 8;
                            Shot.enemyShotParam[v21] = Shot.enemyShotParam[v21] + 1;
                            var7_7 = Shot.enemyShotParam[var1_3 + 8] > 15 ? (Shot.enemyShotParam[var1_3 + 8] > 65535 ? 0 : 1) : 8;
                            if (var8_8 < 0) {
                                if (Shot.enemyShotParam[var1_3 + 6] <= 228 && Shot.enemyShotParam[var1_3 + 6] + var7_7 > 228) {
                                    Shot.enemyShotParam[var1_3 + 6] = 228;
                                } else {
                                    v22 = var1_3 + 6;
                                    Shot.enemyShotParam[v22] = Shot.enemyShotParam[v22] + var7_7;
                                }
                                if (Shot.enemyShotParam[var1_3 + 6] > 256) {
                                    v23 = var1_3 + 6;
                                    Shot.enemyShotParam[v23] = Shot.enemyShotParam[v23] - 256;
                                }
                            } else if (var8_8 > 0) {
                                if (Shot.enemyShotParam[var1_3 + 6] >= 156 && Shot.enemyShotParam[var1_3 + 6] - var7_7 < 156) {
                                    Shot.enemyShotParam[var1_3 + 6] = 156;
                                } else {
                                    v24 = var1_3 + 6;
                                    Shot.enemyShotParam[v24] = Shot.enemyShotParam[v24] - var7_7;
                                }
                                if (Shot.enemyShotParam[var1_3 + 6] < 0) {
                                    v25 = var1_3 + 6;
                                    Shot.enemyShotParam[v25] = Shot.enemyShotParam[v25] + 256;
                                }
                            }
                            if (var7_7 != 0) {
                                if (Shot.enemyShotParam[var1_3 + 6] == var2) {
                                    Shot.enemyShotParam[var1_3 + 8] = 65535;
                                } else if (Shot.enemyShotParam[var1_3 + 6] >= var2 - 8 && Shot.enemyShotParam[var1_3 + 6] <= var2 + 8) {
                                    Shot.enemyShotParam[var1_3 + 8] = 16;
                                }
                            }
                            Explosion.generate((Shot.enemyShotParam[var1_3 + 1] >> 10) - 4, (Shot.enemyShotParam[var1_3 + 2] >> 10) - 4, 9, 0);
                        }
                        v26 = var1_3 + 1;
                        Shot.enemyShotParam[v26] = Shot.enemyShotParam[v26] + Shot.enemyShotParam[var1_3 + 5] * gameTopLevel.cos(Shot.enemyShotParam[var1_3 + 6]);
                        v27 = var1_3 + 2;
                        Shot.enemyShotParam[v27] = Shot.enemyShotParam[v27] - Shot.enemyShotParam[var1_3 + 5] * gameTopLevel.sin(Shot.enemyShotParam[var1_3 + 6]);
                        if (Shot.enemyShotParam[var1_3 + 2] / 1024 > Hero.tankPosY + Hero.tankHeight) {
                            Explosion.generate(Shot.enemyShotParam[var1_3 + 1] / 1024 - (62 - Shot.enemyShotParam[var1_3 + 3]) / 2, RandomObject.randomObjectPosY - (55 - Shot.enemyShotParam[var1_3 + 4]) / 2, 4, 0);
                            RandomObject.addCrater(Shot.enemyShotParam[var1_3 + 1] / 1024 + Shot.enemyShotParam[var1_3 + 3] / 2, false);
                            Shot.enemyShotParam[var1_3 + 0] = -1;
                        }
                        if (Shot.enemyShotParam[var1_3 + 1] / 1024 >= -8 && Shot.enemyShotParam[var1_3 + 1] / 1024 <= MOBCanvas.CANVAS_WIDTH + 8) break;
                        Shot.enemyShotParam[var1_3 + 0] = -1;
                        break;
                    }
                    case 4: 
                    case 14: {
                        v28 = var1_3 + 1;
                        Shot.enemyShotParam[v28] = Shot.enemyShotParam[v28] + Shot.enemyShotParam[var1_3 + 5] * gameTopLevel.cos(Shot.enemyShotParam[var1_3 + 6]);
                        v29 = var1_3 + 2;
                        Shot.enemyShotParam[v29] = Shot.enemyShotParam[v29] - Shot.enemyShotParam[var1_3 + 5] * gameTopLevel.sin(Shot.enemyShotParam[var1_3 + 6]);
                        if (Shot.enemyShotParam[var1_3 + 2] / 1024 > Hero.tankPosY + Hero.tankHeight) {
                            if (Shot.enemyShotParam[var1_3 + 0] == 4) {
                                RandomObject.addCrater(Shot.enemyShotParam[var1_3 + 1] / 1024 + Shot.enemyShotParam[var1_3 + 3] / 2, true);
                            } else {
                                Explosion.generate(Shot.enemyShotParam[var1_3 + 1] / 1024 - (62 - Shot.enemyShotParam[var1_3 + 3]) / 2, RandomObject.randomObjectPosY - (55 - Shot.enemyShotParam[var1_3 + 4]) / 2, 4, 0);
                                RandomObject.addCrater(Shot.enemyShotParam[var1_3 + 1] / 1024 + Shot.enemyShotParam[var1_3 + 3] / 2, false);
                            }
                            Shot.enemyShotParam[var1_3 + 0] = -1;
                        }
                        if (Shot.enemyShotParam[var1_3 + 1] / 1024 >= -8 && Shot.enemyShotParam[var1_3 + 1] / 1024 <= MOBCanvas.CANVAS_WIDTH + 8) break;
                        Shot.enemyShotParam[var1_3 + 0] = -1;
                        break;
                    }
                    case 7: {
                        v30 = var1_3 + 1;
                        Shot.enemyShotParam[v30] = Shot.enemyShotParam[v30] + Shot.enemyShotParam[var1_3 + 5] * 1024;
                        v31 = var1_3 + 2;
                        Shot.enemyShotParam[v31] = Shot.enemyShotParam[v31] + Shot.enemyShotParam[var1_3 + 6] / 2 * 1024;
                        if (Shot.enemyShotParam[var1_3 + 6] < 14) {
                            v32 = var1_3 + 6;
                            Shot.enemyShotParam[v32] = Shot.enemyShotParam[v32] + 1;
                        }
                        if (Shot.enemyShotParam[var1_3 + 2] / 1024 > Hero.tankPosY + Hero.tankHeight) {
                            RandomObject.addCrater(Shot.enemyShotParam[var1_3 + 1] / 1024 + Shot.enemyShotParam[var1_3 + 3] / 2, true);
                            Shot.enemyShotParam[var1_3 + 0] = -1;
                        }
                        if (Shot.enemyShotParam[var1_3 + 1] / 1024 >= -8 && Shot.enemyShotParam[var1_3 + 1] / 1024 <= MOBCanvas.CANVAS_WIDTH + 8) break;
                        Shot.enemyShotParam[var1_3 + 0] = -1;
                        break;
                    }
                    case 12: {
                        v33 = var1_3 + 1;
                        Shot.enemyShotParam[v33] = Shot.enemyShotParam[v33] + Shot.enemyShotParam[var1_3 + 5] / 3 * 1024;
                        v34 = var1_3 + 2;
                        Shot.enemyShotParam[v34] = Shot.enemyShotParam[v34] + Shot.enemyShotParam[var1_3 + 6] / 2 * 1024;
                        if (Shot.enemyShotParam[var1_3 + 6] < 8) {
                            v35 = var1_3 + 6;
                            Shot.enemyShotParam[v35] = Shot.enemyShotParam[v35] + 1;
                        }
                        if (Shot.enemyShotParam[var1_3 + 1] / 1024 > Hero.tankPosX) {
                            if (Shot.enemyShotParam[var1_3 + 5] >= 0) {
                                v36 = var1_3 + 5;
                                Shot.enemyShotParam[v36] = Shot.enemyShotParam[v36] - 1;
                            } else {
                                v37 = var1_3 + 5;
                                Shot.enemyShotParam[v37] = Shot.enemyShotParam[v37] - 2;
                            }
                        } else if (Shot.enemyShotParam[var1_3 + 5] <= 0) {
                            v38 = var1_3 + 5;
                            Shot.enemyShotParam[v38] = Shot.enemyShotParam[v38] + 1;
                        } else {
                            v39 = var1_3 + 5;
                            Shot.enemyShotParam[v39] = Shot.enemyShotParam[v39] + 2;
                        }
                        if (Shot.enemyShotParam[var1_3 + 5] > 15) {
                            Shot.enemyShotParam[var1_3 + 5] = 15;
                        }
                        if (Shot.enemyShotParam[var1_3 + 5] < -15) {
                            Shot.enemyShotParam[var1_3 + 5] = -15;
                        }
                        if (Shot.enemyShotParam[var1_3 + 2] / 1024 <= Hero.tankPosY + Hero.tankHeight) break;
                        Explosion.generate(Shot.enemyShotParam[var1_3 + 1] / 1024 - (62 - Shot.enemyShotParam[var1_3 + 3]) / 2, RandomObject.randomObjectPosY - (55 - Shot.enemyShotParam[var1_3 + 4]) / 2, 4, 0);
                        RandomObject.addCrater(Shot.enemyShotParam[var1_3 + 1] / 1024 + Shot.enemyShotParam[var1_3 + 3] / 2, false);
                        Shot.enemyShotParam[var1_3 + 0] = -1;
                        break;
                    }
                    case 13: {
                        v40 = var1_3 + 1;
                        Shot.enemyShotParam[v40] = Shot.enemyShotParam[v40] + Shot.enemyShotParam[var1_3 + 5] * 1024;
                        v41 = var1_3 + 2;
                        Shot.enemyShotParam[v41] = Shot.enemyShotParam[v41] + Shot.enemyShotParam[var1_3 + 6] / 2 * 1024;
                        if (Shot.enemyShotParam[var1_3 + 6] < 14) {
                            v42 = var1_3 + 6;
                            Shot.enemyShotParam[v42] = Shot.enemyShotParam[v42] + 1;
                        }
                        if (Shot.enemyShotParam[var1_3 + 2] / 1024 <= Hero.tankPosY + Hero.tankHeight) break;
                        RandomObject.addCrater(Shot.enemyShotParam[var1_3 + 1] / 1024 + Shot.enemyShotParam[var1_3 + 3] / 2, false);
                        Explosion.generate(Shot.enemyShotParam[var1_3 + 1] / 1024 - (62 - Shot.enemyShotParam[var1_3 + 3]) / 2, RandomObject.randomObjectPosY - (55 - Shot.enemyShotParam[var1_3 + 4]) / 2, 4, 0);
                        Shot.enemyShotParam[var1_3 + 0] = -1;
                        break;
                    }
                    case 11: {
                        if (Shot.enemyShotParam[var1_3 + 5] < 0) {
                            Explosion.generate((Shot.enemyShotParam[var1_3 + 1] >> 10) - 4 - Shot.enemyShotParam[var1_3 + 5], (Shot.enemyShotParam[var1_3 + 2] >> 10) - 4 - Shot.enemyShotParam[var1_3 + 6] / 3, 3, 0);
                        } else {
                            Explosion.generate((Shot.enemyShotParam[var1_3 + 1] >> 10) - 4 - Shot.enemyShotParam[var1_3 + 5], (Shot.enemyShotParam[var1_3 + 2] >> 10) - 4 - Shot.enemyShotParam[var1_3 + 6] / 3, 3, 0);
                        }
                        v43 = var1_3 + 1;
                        Shot.enemyShotParam[v43] = Shot.enemyShotParam[v43] + Shot.enemyShotParam[var1_3 + 5] * 1024;
                        v44 = var1_3 + 2;
                        Shot.enemyShotParam[v44] = Shot.enemyShotParam[v44] + Shot.enemyShotParam[var1_3 + 6] / 3 * 1024;
                        if (Shot.enemyShotParam[var1_3 + 6] < 13) {
                            v45 = var1_3 + 6;
                            Shot.enemyShotParam[v45] = Shot.enemyShotParam[v45] + 1;
                        }
                        if (Shot.enemyShotParam[var1_3 + 2] / 1024 > Hero.tankPosY + Hero.tankHeight) {
                            Explosion.generate(Shot.enemyShotParam[var1_3 + 1] / 1024 - (62 - Shot.enemyShotParam[var1_3 + 3]) / 2, RandomObject.randomObjectPosY - (55 - Shot.enemyShotParam[var1_3 + 4]) / 2, 4, 0);
                            RandomObject.addCrater(Shot.enemyShotParam[var1_3 + 1] / 1024 + Shot.enemyShotParam[var1_3 + 3] / 2, false);
                            Shot.enemyShotParam[var1_3 + 0] = -1;
                        }
                        if (Shot.enemyShotParam[var1_3 + 1] / 1024 >= -8 && Shot.enemyShotParam[var1_3 + 1] / 1024 <= MOBCanvas.CANVAS_WIDTH + 8) break;
                        Shot.enemyShotParam[var1_3 + 0] = -1;
                        break;
                    }
                    case 15: {
                        if (Shot.enemyShotParam[var1_3 + 1] >> 10 <= Hero.tankPosX + Hero.tankWidth / 2 && Shot.enemyShotParam[var1_3 + 5] < 0 || Shot.enemyShotParam[var1_3 + 1] >> 10 >= Hero.tankPosX + Hero.tankWidth / 2 && Shot.enemyShotParam[var1_3 + 5] > 0) {
                            Explosion.generate(Shot.enemyShotParam[var1_3 + 1] / 1024 - (62 - Shot.enemyShotParam[var1_3 + 3]) / 2, Shot.enemyShotParam[var1_3 + 2] / 1024 - (62 - Shot.enemyShotParam[var1_3 + 4]) / 2, 0, 0);
                            Shot.enemyShotParam[var1_3 + 0] = -1;
                            Shot.recomputeMaxEnemyShot();
                            Shot.generateEnemy(Shot.enemyShotParam[var1_3 + 1] / 1024, Shot.enemyShotParam[var1_3 + 2] / 1024, 7, 0, -16);
                            Shot.generateEnemy(Shot.enemyShotParam[var1_3 + 1] / 1024, Shot.enemyShotParam[var1_3 + 2] / 1024, 8, 5, 224);
                            Shot.generateEnemy(Shot.enemyShotParam[var1_3 + 1] / 1024, Shot.enemyShotParam[var1_3 + 2] / 1024, 8, 5, 192);
                            Shot.generateEnemy(Shot.enemyShotParam[var1_3 + 1] / 1024, Shot.enemyShotParam[var1_3 + 2] / 1024, 8, 5, 160);
                        } else {
                            v46 = var1_3 + 1;
                            Shot.enemyShotParam[v46] = Shot.enemyShotParam[v46] + Shot.enemyShotParam[var1_3 + 5] * 1024;
                        }
                        if (Shot.enemyShotParam[var1_3 + 1] / 1024 >= -(Shot.imgEnemyBurst.getWidth() / 3) && Shot.enemyShotParam[var1_3 + 1] / 1024 <= MOBCanvas.CANVAS_WIDTH) break;
                        Shot.enemyShotParam[var1_3 + 0] = -1;
                        break;
                    }
                    case 17: {
                        switch (Shot.lastLaserBeamRandom) {
                            case 0: 
                            case 1: {
                                v47 = var1_3 + 1;
                                Shot.enemyShotParam[v47] = Shot.enemyShotParam[v47] + Shot.enemyShotParam[var1_3 + 5] * gameTopLevel.cos(Shot.enemyShotParam[var1_3 + 6]);
                                v48 = var1_3 + 2;
                                Shot.enemyShotParam[v48] = Shot.enemyShotParam[v48] - Shot.enemyShotParam[var1_3 + 5] * gameTopLevel.sin(Shot.enemyShotParam[var1_3 + 6]);
                                break;
                            }
                            case 2: {
                                v49 = var1_3 + 1;
                                Shot.enemyShotParam[v49] = Shot.enemyShotParam[v49] + Shot.enemyShotParam[var1_3 + 5] * gameTopLevel.cos(Shot.enemyShotParam[var1_3 + 6]) * 2;
                                v50 = var1_3 + 2;
                                Shot.enemyShotParam[v50] = Shot.enemyShotParam[v50] - Shot.enemyShotParam[var1_3 + 5] * gameTopLevel.sin(Shot.enemyShotParam[var1_3 + 6]) / 2;
                                v51 = var1_3 + 6;
                                Shot.enemyShotParam[v51] = Shot.enemyShotParam[v51] + Shot.enemyShotParam[var1_3 + 8];
                                if (Shot.enemyShotParam[var1_3 + 6] <= 168) {
                                    Shot.enemyShotParam[var1_3 + 8] = -Shot.enemyShotParam[var1_3 + 8];
                                }
                                if (Shot.enemyShotParam[var1_3 + 6] < 216) break;
                                Shot.enemyShotParam[var1_3 + 8] = -Shot.enemyShotParam[var1_3 + 8];
                            }
                        }
                        if (Shot.enemyShotParam[var1_3 + 2] / 1024 <= MOBCanvas.CANVAS_HEIGHT) break;
                        Shot.enemyShotParam[var1_3 + 0] = -1;
                        break;
                    }
                    case 18: {
                        switch (Shot.lastLaserBeamRandom) {
                            case 0: 
                            case 1: {
                                v52 = var1_3 + 1;
                                Shot.enemyShotParam[v52] = Shot.enemyShotParam[v52] + Shot.enemyShotParam[var1_3 + 5] * gameTopLevel.cos(Shot.enemyShotParam[var1_3 + 6]);
                                v53 = var1_3 + 2;
                                Shot.enemyShotParam[v53] = Shot.enemyShotParam[v53] - Shot.enemyShotParam[var1_3 + 5] * gameTopLevel.sin(Shot.enemyShotParam[var1_3 + 6]);
                                break;
                            }
                            case 2: {
                                v54 = var1_3 + 1;
                                Shot.enemyShotParam[v54] = Shot.enemyShotParam[v54] + Shot.enemyShotParam[var1_3 + 5] * gameTopLevel.cos(Shot.enemyShotParam[var1_3 + 6]) * 2;
                                v55 = var1_3 + 2;
                                Shot.enemyShotParam[v55] = Shot.enemyShotParam[v55] - Shot.enemyShotParam[var1_3 + 5] * gameTopLevel.sin(Shot.enemyShotParam[var1_3 + 6]) / 2;
                                v56 = var1_3 + 6;
                                Shot.enemyShotParam[v56] = Shot.enemyShotParam[v56] + Shot.enemyShotParam[var1_3 + 8];
                                if (Shot.enemyShotParam[var1_3 + 6] <= 168) {
                                    Shot.enemyShotParam[var1_3 + 8] = -Shot.enemyShotParam[var1_3 + 8];
                                }
                                if (Shot.enemyShotParam[var1_3 + 6] < 216) break;
                                Shot.enemyShotParam[var1_3 + 8] = -Shot.enemyShotParam[var1_3 + 8];
                            }
                        }
                        if (Shot.enemyShotParam[var1_3 + 2] / 1024 <= MOBCanvas.CANVAS_HEIGHT) break;
                        Shot.enemyShotParam[var1_3 + 0] = -1;
                    }
                }
            }
            ++var0_4;
            var1_3 += 9;
        }
        Shot.recomputeMaxEnemyShot();
    }

    static void checkCollision() {
        int n;
        int n2;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        while (n4 < enemyShotCurrentMax) {
            if (enemyShotParam[n5 + 0] != -1) {
                if (enemyShotParam[n5 + 0] != 4 && enemyShotParam[n5 + 0] != 7 && enemyShotParam[n5 + 0] != 14 && enemyShotParam[n5 + 0] != 10 && enemyShotParam[n5 + 0] != 16 && enemyShotParam[n5 + 0] != 17 && enemyShotParam[n5 + 0] != 18) {
                    n2 = 0;
                    n = 0;
                    while (n2 < heroShotCurrentMax) {
                        if (heroShotParam[n + 0] != -1) {
                            if (heroShotParam[n + 0] == 5) {
                                n3 = n2;
                            } else if (inGame.collision(enemyShotParam[n5 + 1] / 1024 + 2, enemyShotParam[n5 + 2] / 1024 + 2, enemyShotParam[n5 + 3] - 4, enemyShotParam[n5 + 4] - 4, heroShotParam[n + 1] / 1024 + 2, heroShotParam[n + 2] / 1024 + 2, heroShotParam[n + 3] - 4, heroShotParam[n + 4] - 4)) {
                                int n6 = n5 + 7;
                                enemyShotParam[n6] = enemyShotParam[n6] - heroShotParam[n + 7];
                                if (enemyShotParam[n5 + 7] <= 0) {
                                    if (enemyShotParam[n5 + 0] == 3) {
                                        Explosion.generate(enemyShotParam[n5 + 1] / 1024 - (62 - enemyShotParam[n5 + 3]) / 2, enemyShotParam[n5 + 2] / 1024 - (55 - enemyShotParam[n5 + 4]) / 2, 0, 0);
                                    } else {
                                        Explosion.generate(enemyShotParam[n5 + 1] / 1024 - (62 - enemyShotParam[n5 + 3]) / 2, enemyShotParam[n5 + 2] / 1024 - (55 - enemyShotParam[n5 + 4]) / 2, 4, 0);
                                    }
                                    Board.score += shotPoints[enemyShotParam[n5 + 0]];
                                    Board.drawStatus |= 2;
                                    if (inGame.levelNb != 255) {
                                        Bonus.generateString("" + shotPoints[enemyShotParam[n5 + 0]], enemyShotParam[n5 + 1] / 1024, enemyShotParam[n5 + 2] / 1024, true);
                                    }
                                    Shot.enemyShotParam[n5 + 0] = -1;
                                    Shot.recomputeMaxEnemyShot();
                                } else {
                                    Explosion.generate(heroShotParam[n + 1] / 1024, heroShotParam[n + 2] / 1024, 2, 0);
                                }
                                if (heroShotParam[n + 0] == 3) break;
                                Shot.heroShotParam[n + 0] = -1;
                                Shot.recomputeMaxHeroShot();
                                break;
                            }
                        }
                        ++n2;
                        n += 9;
                    }
                } else {
                    n2 = 0;
                    n = 0;
                    while (n2 < heroShotCurrentMax) {
                        if (heroShotParam[n + 0] == 5) {
                            n3 = n2;
                        } else if (heroShotParam[n + 0] == 3) {
                            Explosion.generate(enemyShotParam[n5 + 1] / 1024 - (62 - enemyShotParam[n5 + 3]) / 2, enemyShotParam[n5 + 2] / 1024 - (55 - enemyShotParam[n5 + 4]) / 2, 4, 0);
                            Board.score += shotPoints[enemyShotParam[n5 + 0]];
                            Board.drawStatus |= 2;
                            if (inGame.levelNb != 255) {
                                Bonus.generateString("" + shotPoints[enemyShotParam[n5 + 0]], enemyShotParam[n5 + 1] / 1024, enemyShotParam[n5 + 2] / 1024, true);
                            }
                            Shot.enemyShotParam[n5 + 0] = -1;
                            Shot.recomputeMaxEnemyShot();
                        } else if (heroShotParam[n + 0] == 6 && enemyShotParam[n5 + 0] != 10 && inGame.collision(enemyShotParam[n5 + 1] / 1024 + 2, enemyShotParam[n5 + 2] / 1024 + 2, enemyShotParam[n5 + 3] - 4, enemyShotParam[n5 + 4] - 4, heroShotParam[n + 1] / 1024 + 2, heroShotParam[n + 2] / 1024 + 2, heroShotParam[n + 3] - 4, heroShotParam[n + 4] - 4)) {
                            Explosion.generate(enemyShotParam[n5 + 1] / 1024 - (62 - enemyShotParam[n5 + 3]) / 2, enemyShotParam[n5 + 2] / 1024 - (55 - enemyShotParam[n5 + 4]) / 2, 4, 0);
                            Board.score += shotPoints[enemyShotParam[n5 + 0]];
                            Board.drawStatus |= 2;
                            if (inGame.levelNb != 255) {
                                Bonus.generateString("" + shotPoints[enemyShotParam[n5 + 0]], enemyShotParam[n5 + 1] / 1024, enemyShotParam[n5 + 2] / 1024, true);
                            }
                            Shot.enemyShotParam[n5 + 0] = -1;
                            Shot.recomputeMaxEnemyShot();
                        }
                        ++n2;
                        n += 9;
                    }
                }
            }
            ++n4;
            n5 += 9;
        }
        if (n3 == -1 && enemyShotCurrentMax == 0) {
            n2 = 0;
            n = 0;
            while (n2 < heroShotCurrentMax) {
                if (heroShotParam[n + 0] == 5) {
                    n3 = n2;
                    break;
                }
                ++n2;
                n += 9;
            }
        }
        if (heroLaserNormalLength < 380 && (heroLaserNormalLength += 32) > 380) {
            heroLaserNormalLength = 380;
        }
        heroLaserLength = heroLaserNormalLength;
        if (n3 != -1) {
            int n7;
            int n8;
            int n9;
            int n10 = -1;
            int n11 = heroLaserLength * heroLaserLength;
            int n12 = -1;
            int n13 = n11;
            n4 = 0;
            n5 = 0;
            while (n4 < enemyShotCurrentMax) {
                if (enemyShotParam[n5 + 0] != -1 && enemyShotParam[n5 + 0] != 4 && enemyShotParam[n5 + 0] != 7 && enemyShotParam[n5 + 0] != 10 && enemyShotParam[n5 + 0] != 17 && enemyShotParam[n5 + 0] != 18) {
                    n9 = 2;
                    n8 = gameTopLevel.ratan2(Hero.tankPosY - enemyShotParam[n5 + 2] / 1024, enemyShotParam[n5 + 1] / 1024 - (Hero.tankPosX + Hero.tankWidth / 2)) / 16;
                    if (enemyShotParam[n5 + 0] == 3) {
                        n9 = 4;
                    }
                    if (n8 - n9 <= Hero.targetAngle && n8 + n9 >= Hero.targetAngle && (n7 = (Hero.tankPosY - enemyShotParam[n5 + 2] / 1024) * (Hero.tankPosY - enemyShotParam[n5 + 2] / 1024) + (Hero.tankPosX + Hero.tankWidth / 2 - enemyShotParam[n5 + 1] / 1024) * (Hero.tankPosX + Hero.tankWidth / 2 - enemyShotParam[n5 + 1] / 1024)) < n11) {
                        n10 = n4;
                        n11 = n7;
                    }
                }
                ++n4;
                n5 += 9;
            }
            if ((inGame.gameStatus & 0x40) == 0) {
                n4 = 0;
                n5 = 0;
                while (n4 < 12) {
                    if ((Enemy.enemyParams[n5 + 0] != 10 || Enemy.enemyParams[n5 + 9] >= 0) && Enemy.enemyParams[n5 + 0] != -1) {
                        n8 = gameTopLevel.ratan2(Hero.tankPosY + Hero.tankHeight / 2 - Enemy.enemyParams[n5 + 2], Enemy.enemyParams[n5 + 1] - (Hero.tankPosX + Hero.tankWidth / 2)) / 16;
                        int n14 = gameTopLevel.ratan2(Hero.tankPosY + Hero.tankHeight / 2 - (Enemy.enemyParams[n5 + 2] + Enemy.enemyParams[n5 + 6]), Enemy.enemyParams[n5 + 1] - (Hero.tankPosX + Hero.tankWidth / 2)) / 16;
                        if (n14 > 192) {
                            n14 -= 256;
                        }
                        int n15 = gameTopLevel.ratan2(Hero.tankPosY + Hero.tankHeight / 2 - Enemy.enemyParams[n5 + 2], Enemy.enemyParams[n5 + 1] + Enemy.enemyParams[n5 + 5] - (Hero.tankPosX + Hero.tankWidth / 2)) / 16;
                        int n16 = gameTopLevel.ratan2(Hero.tankPosY + Hero.tankHeight / 2 - (Enemy.enemyParams[n5 + 2] + Enemy.enemyParams[n5 + 6]), Enemy.enemyParams[n5 + 1] + Enemy.enemyParams[n5 + 5] - (Hero.tankPosX + Hero.tankWidth / 2)) / 16;
                        if (n16 > 192) {
                            n16 -= 256;
                        }
                        if (n14 > n8) {
                            n8 = n14;
                        }
                        if (n16 < n15) {
                            n15 = n16;
                        }
                        if (++n8 >= Hero.targetAngle && --n15 <= Hero.targetAngle && (n9 = (Hero.tankPosY + Hero.tankHeight / 2 - (Enemy.enemyParams[n5 + 2] + Enemy.enemyParams[n5 + 6] / 2)) * (Hero.tankPosY + Hero.tankHeight / 2 - (Enemy.enemyParams[n5 + 2] + Enemy.enemyParams[n5 + 6] / 2)) + (Hero.tankPosX + Hero.tankWidth / 2 - (Enemy.enemyParams[n5 + 1] + Enemy.enemyParams[n5 + 5] / 2)) * (Hero.tankPosX + Hero.tankWidth / 2 - (Enemy.enemyParams[n5 + 1] + Enemy.enemyParams[n5 + 5] / 2))) < n13) {
                            n12 = n4;
                            n13 = n9;
                        }
                    }
                    ++n4;
                    n5 += 15;
                }
            } else {
                n9 = Boss.bossCollisionOffset;
                n4 = 0;
                while (n4 < Boss.bossNbCollisions) {
                    if (Boss.currentBoss[n9 + 4] != 0) {
                        n8 = gameTopLevel.ratan2(Hero.tankPosY + Hero.tankHeight / 2 - (Boss.bossY + Boss.getCollY(n4)), Boss.bossX + Boss.getCollX(n4) - (Hero.tankPosX + Hero.tankWidth / 2)) / 16;
                        int n17 = gameTopLevel.ratan2(Hero.tankPosY + Hero.tankHeight / 2 - (Boss.bossY + Boss.getCollY(n4) + Boss.getCollHeight(n4)), Boss.bossX + Boss.getCollX(n4) - (Hero.tankPosX + Hero.tankWidth / 2)) / 16;
                        if (n8 <= 128 || n17 <= 128) {
                            if (n17 > 192) {
                                n17 -= 256;
                            }
                            int n18 = gameTopLevel.ratan2(Hero.tankPosY + Hero.tankHeight / 2 - (Boss.bossY + Boss.getCollY(n4)), Boss.bossX + Boss.getCollX(n4) + Boss.getCollWidth(n4) - (Hero.tankPosX + Hero.tankWidth / 2)) / 16;
                            int n19 = gameTopLevel.ratan2(Hero.tankPosY + Hero.tankHeight / 2 - (Boss.bossY + Boss.getCollY(n4) + Boss.getCollHeight(n4)), Boss.bossX + Boss.getCollX(n4) + Boss.getCollWidth(n4) - (Hero.tankPosX + Hero.tankWidth / 2)) / 16;
                            if (n19 > 192) {
                                n19 -= 256;
                            }
                            if (n17 > n8) {
                                n8 = n17;
                            }
                            if (n19 < n18) {
                                n18 = n19;
                            }
                            if (n8 >= Hero.targetAngle && n18 <= Hero.targetAngle && (n7 = (Hero.tankPosY + Hero.tankHeight / 2 - (Boss.bossY + Boss.getCollY(n4) + Boss.getCollHeight(n4) / 2)) * (Hero.tankPosY + Hero.tankHeight / 2 - (Boss.bossY + Boss.getCollY(n4) + Boss.getCollHeight(n4) / 2)) + (Hero.tankPosX + Hero.tankWidth / 2 - (Boss.bossX + Boss.getCollX(n4) + Boss.getCollWidth(n4) / 2)) * (Hero.tankPosX + Hero.tankWidth / 2 - (Boss.bossX + Boss.getCollX(n4) + Boss.getCollWidth(n4) / 2))) < n13) {
                                n12 = n4;
                                n13 = n7;
                            }
                        }
                    }
                    ++n4;
                    n9 += 11;
                }
            }
            if (n12 != -1 && n10 != -1) {
                if (n13 > n11) {
                    n12 = -1;
                } else {
                    n10 = -1;
                }
            }
            if (n10 != -1) {
                heroLaserNormalLength = heroLaserLength = Shot.sqrt(n11) + -4;
                n5 = n10 * 9;
                n = n3 * 9;
                int n20 = n5 + 7;
                enemyShotParam[n20] = enemyShotParam[n20] - heroShotParam[n + 7];
                if (enemyShotParam[n5 + 7] <= 0) {
                    if (enemyShotParam[n5 + 0] == 3) {
                        Explosion.generate(enemyShotParam[n5 + 1] / 1024 - (62 - enemyShotParam[n5 + 3]) / 2, enemyShotParam[n5 + 2] / 1024 - (55 - enemyShotParam[n5 + 4]) / 2, 0, 0);
                    } else {
                        Explosion.generate(enemyShotParam[n5 + 1] / 1024 - (62 - enemyShotParam[n5 + 3]) / 2, enemyShotParam[n5 + 2] / 1024 - (55 - enemyShotParam[n5 + 4]) / 2, 4, 0);
                    }
                    Board.score += shotPoints[enemyShotParam[n5 + 0]];
                    Board.drawStatus |= 2;
                    if (inGame.levelNb != 255) {
                        Bonus.generateString("" + shotPoints[enemyShotParam[n5 + 0]], enemyShotParam[n5 + 1] / 1024, enemyShotParam[n5 + 2] / 1024, true);
                    }
                    Shot.enemyShotParam[n5 + 0] = -1;
                    Shot.recomputeMaxEnemyShot();
                }
                Explosion.generate((heroShotParam[n10 + 1] + heroLaserLength * gameTopLevel.cos(heroShotParam[n10 + 6])) / 1024, (heroShotParam[n10 + 2] - heroLaserLength * gameTopLevel.sin(heroShotParam[n10 + 6])) / 1024, 8, 0);
            }
            if (n12 != -1) {
                heroLaserNormalLength = heroLaserLength = Shot.sqrt(n13) + -16;
                n = n3 * 9;
                if ((inGame.gameStatus & 0x40) == 0) {
                    n5 = n12 * 15;
                    int n21 = n5 + 12;
                    Enemy.enemyParams[n21] = Enemy.enemyParams[n21] - heroShotParam[n + 7];
                    if (Enemy.enemyParams[n5 + 12] <= 0) {
                        Enemy.dead(n5, n);
                    } else {
                        Enemy.notDead(n5, n);
                    }
                } else {
                    Explosion.generate((heroShotParam[n + 1] + heroLaserLength * gameTopLevel.cos(heroShotParam[n + 6])) / 1024, (heroShotParam[n + 2] - heroLaserLength * gameTopLevel.sin(heroShotParam[n + 6])) / 1024, 8, 0);
                    if (Boss.currentBoss[Boss.bossCollisionOffset + n12 * 11 + 4] < 0) {
                        Boss.life -= heroShotParam[n + 7];
                    } else {
                        int n22 = Boss.bossCollisionOffset + n12 * 11 + 4;
                        Boss.currentBoss[n22] = Boss.currentBoss[n22] - heroShotParam[n + 7];
                        if (Boss.currentBoss[Boss.bossCollisionOffset + n12 * 11 + 4] < 1) {
                            Boss.currentBoss[Boss.bossCollisionOffset + n12 * 11 + 4] = 1;
                        }
                    }
                }
            }
        }
    }

    static void draw(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        if (Hero.staticNb > 0 && heroThunderStep > 0 && heroThunderStep < 6) {
            if (Hero.staticNb > 1) {
                graphics.setColor(255, 255, 255);
            } else {
                graphics.setColor(224, 224, 224);
            }
            graphics.drawLine(heroThunderStartPosX, heroThunderStartPosY, heroThunderEndPosX, heroThunderEndPosY);
            graphics.drawLine(heroThunderStartPosX + addThunderStart, heroThunderStartPosY, heroThunderEndPosX + addThunderEnd, heroThunderEndPosY);
            graphics.drawLine(heroThunderStartPosX, heroThunderStartPosY + addThunderStart, heroThunderEndPosX, heroThunderEndPosY + addThunderEnd);
            if (Hero.staticNb > 2) {
                graphics.drawLine(heroThunderStartPosX - addThunderStart, heroThunderStartPosY, heroThunderEndPosX - addThunderEnd, heroThunderEndPosY);
                graphics.drawLine(heroThunderStartPosX, heroThunderStartPosY - addThunderStart, heroThunderEndPosX, heroThunderEndPosY - addThunderEnd);
            }
        }
        int n5 = 0;
        int n6 = 0;
        while (n5 < heroShotCurrentMax) {
            switch (heroShotParam[n6 + 0]) {
                case 0: {
                    n4 = 20 - heroShotParam[n6 + 6] * 20 / 128;
                    if (n4 > 20) {
                        n4 = 20;
                    }
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    n3 = imgHeroBullets.getWidth() / 11;
                    n2 = imgHeroBullets.getHeight() / 5;
                    if (n4 < 11) {
                        graphics.drawRegion(imgHeroBullets, n3 * n4, n2 * (heroShotParam[n6 + 7] - 2), n3, n2, 0, (heroShotParam[n6 + 1] >> 10) - (n3 >> 1), (heroShotParam[n6 + 2] >> 10) - (n2 >> 1), 0x10 | 4);
                        break;
                    }
                    graphics.drawRegion(imgHeroBullets, n3 * (20 - n4), n2 * (heroShotParam[n6 + 7] - 2), n3, n2, 2, (heroShotParam[n6 + 1] >> 10) - (n3 >> 1), (heroShotParam[n6 + 2] >> 10) - (n2 >> 1), 0x10 | 4);
                    break;
                }
                case 1: {
                    n4 = 20 - heroShotParam[n6 + 6] * 20 / 128;
                    if (n4 > 20) {
                        n4 = 20;
                    }
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    n3 = imgHeroRockets.getWidth() / 11;
                    n2 = imgHeroRockets.getHeight();
                    if (n4 < 11) {
                        graphics.drawRegion(imgHeroRockets, n3 * n4, 0, n3, n2, 0, (heroShotParam[n6 + 1] >> 10) - (n3 >> 1), (heroShotParam[n6 + 2] >> 10) - (n2 >> 1), 0x10 | 4);
                        break;
                    }
                    graphics.drawRegion(imgHeroRockets, n3 * (20 - n4), 0, n3, n2, 2, (heroShotParam[n6 + 1] >> 10) - (n3 >> 1), (heroShotParam[n6 + 2] >> 10) - (n2 >> 1), 0x10 | 4);
                    break;
                }
                case 2: {
                    n = 0;
                    int n7 = 0;
                    n3 = imgHeroMissiles.getWidth() / 6;
                    n2 = imgHeroMissiles.getHeight() / 2;
                    n4 = heroShotParam[n6 + 6] * 20 / 256;
                    if (n4 > 19) {
                        n4 = 19;
                    }
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (n4 >= 10) {
                        n = n2;
                        n4 -= 10;
                    }
                    if (n4 > 5) {
                        n4 = 10 - n4;
                        n7 = 2;
                    }
                    graphics.drawRegion(imgHeroMissiles, n3 * n4, n, n3, n2, n7, (heroShotParam[n6 + 1] >> 10) - (n3 >> 1), (heroShotParam[n6 + 2] >> 10) - (n2 >> 1), 0x10 | 4);
                    break;
                }
                case 4: {
                    n3 = imgHeroFlak.getWidth() / 3;
                    n2 = imgHeroFlak.getHeight();
                    graphics.drawRegion(imgHeroFlak, n3 * heroShotParam[n6 + 6], 0, n3, n2, 0, (heroShotParam[n6 + 1] >> 10) - (n3 >> 1), (heroShotParam[n6 + 2] >> 10) - (n2 >> 1), 0x10 | 4);
                    break;
                }
                case 5: {
                    n = heroShotParam[n6 + 1] + 20 * gameTopLevel.cos(heroShotParam[n6 + 6]);
                    int n7 = heroShotParam[n6 + 2] - 20 * gameTopLevel.sin(heroShotParam[n6 + 6]);
                    n3 = heroShotParam[n6 + 1] + heroLaserLength * gameTopLevel.cos(heroShotParam[n6 + 6]);
                    n2 = heroShotParam[n6 + 2] - heroLaserLength * gameTopLevel.sin(heroShotParam[n6 + 6]);
                    graphics.setColor(154, 251, 205);
                    graphics.drawLine(n / 1024 - 1, n7 / 1024 + 1, n3 / 1024 - 1, n2 / 1024 + 1);
                    graphics.drawLine(n / 1024 - 1, n7 / 1024, n3 / 1024 - 1, n2 / 1024);
                    graphics.drawLine(n / 1024, n7 / 1024 - 1, n3 / 1024, n2 / 1024 - 1);
                    graphics.drawLine(n / 1024 + 1, n7 / 1024 + 1, n3 / 1024 + 1, n2 / 1024 + 1);
                    graphics.drawLine(n / 1024 + 1, n7 / 1024, n3 / 1024 + 1, n2 / 1024);
                    graphics.drawLine(n / 1024, n7 / 1024 + 1, n3 / 1024, n2 / 1024 + 1);
                    if (Hero.laserNb > 2) {
                        graphics.drawLine(n / 1024 - 2, n7 / 1024 + 2, n3 / 1024 - 2, n2 / 1024 + 2);
                        graphics.drawLine(n / 1024 - 2, n7 / 1024 + 1, n3 / 1024 - 2, n2 / 1024 + 1);
                        graphics.drawLine(n / 1024 - 2, n7 / 1024, n3 / 1024 - 2, n2 / 1024);
                        graphics.drawLine(n / 1024, n7 / 1024 - 2, n3 / 1024, n2 / 1024 - 2);
                        graphics.drawLine(n / 1024 + 2, n7 / 1024 + 2, n3 / 1024 + 2, n2 / 1024 + 2);
                        graphics.drawLine(n / 1024 + 2, n7 / 1024 + 1, n3 / 1024 + 2, n2 / 1024 + 1);
                        graphics.drawLine(n / 1024 + 2, n7 / 1024, n3 / 1024 + 2, n2 / 1024);
                        graphics.drawLine(n / 1024, n7 / 1024 + 2, n3 / 1024, n2 / 1024 + 2);
                    }
                    graphics.setColor(255, 255, 255);
                    graphics.drawLine(n / 1024, n7 / 1024, n3 / 1024, n2 / 1024);
                    break;
                }
                case 6: {
                    n3 = imgHeroMegaLaser.getWidth() / 5;
                    n2 = imgHeroMegaLaser.getHeight();
                    graphics.drawRegion(imgHeroMegaLaser, n3 * (Math.abs(Enemy.rnd.nextInt()) % 5), 0, n3, n2, 0, heroShotParam[n6 + 1] >> 10, heroShotParam[n6 + 2] >> 10, 0x10 | 4);
                    Shot.heroShotParam[n6 + 0] = -1;
                    Shot.recomputeMaxHeroShot();
                }
            }
            ++n5;
            n6 += 9;
        }
        n5 = 0;
        n6 = 0;
        while (n5 < enemyShotCurrentMax) {
            switch (enemyShotParam[n6 + 0]) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    n = enemyShotParam[n6 + 6];
                    Image image = imgEnemyBomb;
                    if (enemyShotParam[n6 + 0] == 1) {
                        image = imgEnemyIron;
                    }
                    if (enemyShotParam[n6 + 0] == 2) {
                        image = imgEnemyFrag;
                    }
                    if (enemyShotParam[n6 + 0] == 3) {
                        image = imgEnemyFat;
                    }
                    if (enemyShotParam[n6 + 0] == 5) {
                        image = imgEnemyAutoBomb;
                    }
                    if ((n4 = n > 196 ? (256 - enemyShotParam[n6 + 6]) * 9 / 64 : (enemyShotParam[n6 + 6] - 128) * 9 / 64) > 9) {
                        n4 = 9;
                    }
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    n3 = image.getWidth() / 10;
                    n2 = image.getHeight();
                    if (n < 192) {
                        graphics.drawRegion(image, n3 * n4, 0, n3, n2, 2, (enemyShotParam[n6 + 1] >> 10) - (n3 >> 1), (enemyShotParam[n6 + 2] >> 10) - (n2 >> 1), 0x10 | 4);
                        break;
                    }
                    graphics.drawRegion(image, n3 * n4, 0, n3, n2, 0, (enemyShotParam[n6 + 1] >> 10) - (n3 >> 1), (enemyShotParam[n6 + 2] >> 10) - (n2 >> 1), 0x10 | 4);
                    break;
                }
                case 6: {
                    n = 0;
                    int n8 = 0;
                    n3 = imgEnemyMissile.getWidth() / 6;
                    n2 = imgEnemyMissile.getHeight() / 2;
                    n4 = enemyShotParam[n6 + 6] * 20 / 256;
                    if (n4 >= 10) {
                        n = n2;
                        n4 -= 10;
                    }
                    if (n4 > 5) {
                        n4 = 10 - n4;
                        n8 = 2;
                    }
                    graphics.drawRegion(imgEnemyMissile, n3 * n4, n, n3, n2, n8, (enemyShotParam[n6 + 1] >> 10) - (n3 >> 1), (enemyShotParam[n6 + 2] >> 10) - (n2 >> 1), 0x10 | 4);
                    break;
                }
                case 4: 
                case 7: {
                    graphics.drawImage(imgEnemyPlasma, (enemyShotParam[n6 + 1] >> 10) - (imgEnemyPlasma.getWidth() >> 1), (enemyShotParam[n6 + 2] >> 10) - (imgEnemyPlasma.getHeight() >> 1), 0x10 | 4);
                    break;
                }
                case 14: {
                    int n9;
                    n = enemyShotParam[n6 + 1];
                    int n10 = enemyShotParam[n6 + 2];
                    for (n9 = 0; n9 < 5; ++n9) {
                        graphics.drawRegion(imgEnemyMeteor, n9 * (imgEnemyMeteor.getWidth() / 5), 0, imgEnemyMeteor.getWidth() / 5, imgEnemyMeteor.getHeight(), 0, (n >> 10) - (imgEnemyMeteor.getWidth() / 5 >> 1), (n10 >> 10) - (imgEnemyMeteor.getHeight() >> 1), 0x10 | 4);
                        n -= enemyShotParam[n6 + 5] / 2 * gameTopLevel.cos(enemyShotParam[n6 + 6]);
                        n10 += enemyShotParam[n6 + 5] / 2 * gameTopLevel.sin(enemyShotParam[n6 + 6]);
                    }
                    break;
                }
                case 13: {
                    graphics.drawImage(imgEnemyBoulder, (enemyShotParam[n6 + 1] >> 10) - (imgEnemyBoulder.getWidth() >> 1), (enemyShotParam[n6 + 2] >> 10) - (imgEnemyBoulder.getHeight() >> 1), 0x10 | 4);
                    break;
                }
                case 11: {
                    int n9;
                    n3 = imgEnemyRocket.getWidth() / 10;
                    n2 = imgEnemyRocket.getHeight();
                    if (enemyShotParam[n6 + 5] < 0) {
                        n9 = enemyShotParam[n6 + 6] + 13;
                        if ((n9 /= 3) < 0) {
                            n9 = 0;
                        }
                        if (n9 > 9) {
                            n9 = 9;
                        }
                        graphics.drawRegion(imgEnemyRocket, n3 * n9, 0, n3, n2, 2, (enemyShotParam[n6 + 1] >> 10) - (n3 >> 1), (enemyShotParam[n6 + 2] >> 10) - (n2 >> 1), 0x10 | 4);
                        break;
                    }
                    graphics.drawRegion(imgEnemyRocket, n3 * ((enemyShotParam[n6 + 6] + 13) / 3), 0, n3, n2, 0, (enemyShotParam[n6 + 1] >> 10) - (n3 >> 1), (enemyShotParam[n6 + 2] >> 10) - (n2 >> 1), 0x10 | 4);
                    break;
                }
                case 12: {
                    n3 = imgEnemyMine.getWidth();
                    n2 = imgEnemyMine.getHeight();
                    graphics.drawRegion(imgEnemyMine, 0, 0, n3, n2, 0, (enemyShotParam[n6 + 1] >> 10) - (n3 >> 1), (enemyShotParam[n6 + 2] >> 10) - (n2 >> 1), 0x10 | 4);
                    break;
                }
                case 10: {
                    if (enemyShotParam[n6 + 6] > 30) {
                        graphics.drawRegion(imgEnemyLaser, enemyShotParam[n6 + 6] % 3 * (imgEnemyLaser.getWidth() / 3), 0, imgEnemyLaser.getWidth() / 3, imgEnemyLaser.getHeight(), 0, (enemyShotParam[n6 + 1] >> 10) - (imgEnemyLaser.getWidth() / 3 >> 1), enemyShotParam[n6 + 2] >> 10, 0x10 | 4);
                        break;
                    }
                    int n9 = Hero.tankPosY + Hero.tankHeight - (enemyShotParam[n6 + 2] >> 10);
                    graphics.setColor(154, 251, 205);
                    graphics.fillRect(enemyShotParam[n6 + 1] >> 10, enemyShotParam[n6 + 2] >> 10, 3, n9);
                    graphics.setColor(255, 255, 255);
                    graphics.fillRect((enemyShotParam[n6 + 1] >> 10) + 1, enemyShotParam[n6 + 2] >> 10, 1, n9);
                    break;
                }
                case 16: {
                    if ((enemyShotParam[n6 + 6] & 1) != 0) break;
                    graphics.drawImage(imgEnemyBolt, (enemyShotParam[n6 + 1] >> 10) - (imgEnemyBolt.getWidth() >> 1), enemyShotParam[n6 + 2] >> 10, 0x10 | 4);
                    break;
                }
                case 15: {
                    n3 = imgEnemyBurst.getWidth() / 3;
                    n2 = imgEnemyBurst.getHeight();
                    if (enemyShotParam[n6 + 5] < 0) {
                        graphics.drawRegion(imgEnemyBurst, Enemy.rotorFrame % 3 * n3, 0, n3, n2, 2, (enemyShotParam[n6 + 1] >> 10) - (n3 >> 1), (enemyShotParam[n6 + 2] >> 10) - (n2 >> 1), 0x10 | 4);
                        break;
                    }
                    graphics.drawRegion(imgEnemyBurst, Enemy.rotorFrame % 3 * n3, 0, n3, n2, 0, (enemyShotParam[n6 + 1] >> 10) - (n3 >> 1), (enemyShotParam[n6 + 2] >> 10) - (n2 >> 1), 0x10 | 4);
                    break;
                }
                case 17: {
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    int n9;
                    switch (lastLaserBeamRandom) {
                        case 0: 
                        case 1: {
                            n14 = enemyShotParam[n6 + 1];
                            n13 = enemyShotParam[n6 + 2];
                            for (n9 = 0; n9 < nbLaserBeamPoints; ++n9) {
                                graphics.drawImage(imgEnemyLaserBeam, n14 >> 10, n13 >> 10, 0x10 | 4);
                                n14 += imgEnemyLaserBeam.getWidth() / 2 * gameTopLevel.cos(enemyShotParam[n6 + 6]);
                                n13 -= imgEnemyLaserBeam.getHeight() / 2 * gameTopLevel.sin(enemyShotParam[n6 + 6]);
                            }
                            break;
                        }
                        case 2: {
                            n12 = enemyShotParam[n6 + 6];
                            n11 = enemyShotParam[n6 + 8];
                            n14 = enemyShotParam[n6 + 1];
                            n13 = enemyShotParam[n6 + 2];
                            for (n9 = 0; n9 < nbLaserBeamPoints; ++n9) {
                                graphics.drawImage(imgEnemyLaserBeam, n14 >> 10, n13 >> 10, 0x10 | 4);
                                n14 += imgEnemyLaserBeam.getWidth() / 2 * gameTopLevel.cos(n12) * 2;
                                n13 -= imgEnemyLaserBeam.getHeight() / 2 * gameTopLevel.sin(n12) / 2;
                                if ((n12 += n11) <= 168) {
                                    n11 = -n11;
                                }
                                if (n12 < 216) continue;
                                n11 = -n11;
                            }
                            break;
                        }
                    }
                    break;
                }
                case 18: {
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    int n9;
                    switch (lastLaserBeamRandom) {
                        case 0: {
                            n14 = enemyShotParam[n6 + 1];
                            n13 = enemyShotParam[n6 + 2];
                            for (n9 = 0; n9 < nbLaserBeamPoints; ++n9) {
                                graphics.drawImage(imgEnemyLaserBeam, n14 >> 10, n13 >> 10, 0x10 | 4);
                                n14 += imgEnemyLaserBeam.getWidth() / 2 * gameTopLevel.cos(enemyShotParam[n6 + 6]);
                                n13 -= imgEnemyLaserBeam.getHeight() / 2 * gameTopLevel.sin(enemyShotParam[n6 + 6]);
                            }
                            break;
                        }
                        case 1: {
                            n14 = enemyShotParam[n6 + 1] + (imgEnemyLaserBeam.getWidth() * 2 << 10);
                            n13 = enemyShotParam[n6 + 2];
                            for (n9 = 0; n9 < nbLaserBeamPoints; ++n9) {
                                graphics.drawImage(imgEnemyLaserBeam, n14 >> 10, n13 >> 10, 0x10 | 4);
                                n14 += imgEnemyLaserBeam.getWidth() / 2 * gameTopLevel.cos(enemyShotParam[n6 + 6]);
                                n13 -= imgEnemyLaserBeam.getHeight() / 2 * gameTopLevel.sin(enemyShotParam[n6 + 6]);
                            }
                            break;
                        }
                        case 2: {
                            n12 = enemyShotParam[n6 + 6];
                            n11 = enemyShotParam[n6 + 8];
                            n14 = enemyShotParam[n6 + 1];
                            n13 = enemyShotParam[n6 + 2];
                            for (n9 = 0; n9 < nbLaserBeamPoints; ++n9) {
                                graphics.drawImage(imgEnemyLaserBeam, n14 >> 10, n13 >> 10, 0x10 | 4);
                                n14 += imgEnemyLaserBeam.getWidth() / 2 * gameTopLevel.cos(n12) * 2;
                                n13 -= imgEnemyLaserBeam.getHeight() / 2 * gameTopLevel.sin(n12) / 2;
                                if ((n12 += n11) <= 168) {
                                    n11 = -n11;
                                }
                                if (n12 < 216) continue;
                                n11 = -n11;
                            }
                            break;
                        }
                    }
                    if (nbLaserBeamPoints >= 8) break;
                    ++nbLaserBeamPoints;
                }
            }
            ++n5;
            n6 += 9;
        }
    }

    static {
        shotPoints = new short[]{10, 20, 15, 200, 10, 15, 20, 10, 10, 10, 0, 20, 40, 0, 10, 100, 0, 500, 500};
    }
}

