/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Hero {
    public static final int NORMAL_HERO_SPEED = 4;
    public static final int SHOT_SPEED = 8;
    public static final int SHOT_FREQ = 6;
    public static final int HOMING_SPEED = 10;
    public static final int MIN_TANK_POSX = 4;
    public static final int POWER_HOMING = 8;
    public static final int POWER_ROCKET = 11;
    public static final int TARGET_PARAM_X = 190;
    public static final int TARGET_PARAM_Y = 130;
    public static final int ROCKET_PARAM_MAX = 14;
    public static final int HOMING_PARAM_MAX = 24;
    public static final int LASER_PARAM_MAX = 20;
    public static final int CASING_MAX_SPEED = 6;
    public static final int CASING_ORG_SPEED_X = -18;
    public static final int CASING_ORG_SPEED_Y = -4;
    public static final int DISTANCE_2PODS = 13;
    public static final int DISTANCE_3PODS = 15;
    public static final int TANK_SHADOW_DELTAY = 17;
    public static final int TANK_TRACK_DELTAY = 20;
    public static final int TANK_GUN_DELTAY = -1;
    public static final int TANK_SHOT_DELTA_Y = 6;
    public static final int TANK_DISTANCE_ORB = 23;
    public static final int TANK_LASER_DELTAY = 3;
    public static final int TANK_FLAK_DELTAY = 2;
    public static final int TANK_ORIGINAL_SPEED = 2;
    public static final int TANK_ORIGINAL_GUNWIDTH = 40;
    public static final int TANK_ORIGINAL_LASERWIDTH = 28;
    public static final int TANK_ORIGINAL_FLAKWIDTH = 40;
    public static final int TANK_COLLISION_REDUCTION_X = 7;
    public static final int TANK_COLLISION_REDUCTION_Y = 6;
    public static final int ENEMY_COLLISION_REDUCTION_X = 4;
    public static final int ENEMY_COLLISION_REDUCTION_Y = 4;
    public static final int SHOTORB_COLLISION_REDUCTION_X = 2;
    public static final int SHOTORB_COLLISION_REDUCTION_Y = 2;
    public static final int SHOTENEMY_COLLISION_REDUCTION_X = 6;
    public static final int SHOTENEMY_COLLISION_REDUCTION_Y = 6;
    public static final int FLAK_CANNON_INC_PARAM = 16;
    public static final int MUZZLEFLASH_DIST_X = 24;
    public static final int MUZZLEFLASH_DIST_Y = 20;
    public static final int MUZZLEFLASH_DELTA_Y = -6;
    public static final int ROCKET_DELTA_Y = 4;
    public static final int ROCKET2_DELTA_Y = 5;
    public static final int HOMING_DELTA_Y = -2;
    public static final int TARGET_SIZE_X = 28;
    public static final int MEGABASE_WIDTH = 28;
    public static final int TANK_LASER_DELTA_Y = 8;
    public static final int POWER_MEGALASER = 65535;
    public static Image imgTank;
    public static Image imgGun;
    public static Image imgTankShadow;
    public static Image imgTracks;
    public static Image imgOrb;
    public static Image imgHoming;
    public static Image imgLaser;
    public static Image imgRocketPod;
    public static Image imgFlakCanon;
    public static Image imgStatic;
    public static Image imgCasing;
    public static Image imgShield;
    public static Image imgShieldColor;
    public static Image imgMuzzle;
    public static Image imgMegaMuzzle;
    public static Image imgTarget;
    public static int targetFrame;
    public static int targetAddFrame;
    public static final int TARGET_NBFRAMES = 3;
    public static final int TARGET_NBFAKEFRAMES = 6;
    public static int invincibleTimer;
    public static int invincibleTimer2;
    public static final int MAX_INVINCIBLE_TIMER = 75;
    public static final int SHORT_INVINCIBLE_TIMER = 5;
    public static int targetAngle;
    public static int targetAngleAccel;
    public static int targetAnglePos;
    public static int targetPosX;
    public static int targetPosY;
    public static boolean targetDuck;
    public static int targetAngleDuck;
    public static int targetDuckAdd;
    public static boolean searchForBestPos;
    public static int tankPosX;
    public static int tankPosY;
    public static int tankInertia;
    public static int tankWidth;
    public static int tankHeight;
    public static int tankMaxPosX;
    public static int homingNb;
    public static int speedHomingParam;
    public static int orbNb;
    public static int orbAngle;
    public static int[] orbPos;
    public static int staticNb;
    public static int rocketNb;
    public static int speedRocketParam;
    public static int laserNb;
    public static int speedLaserParam;
    public static int flakNb;
    public static int speed;
    public static int power;
    public static int shotNb;
    public static int shieldNb;
    public static int speedShot;
    public static int speedShotParam;
    public static int decSpeedShotParam;
    public static int[] casingParam;
    public static int casingCurrentMax;
    public static final int CASING_ACTIVE = 0;
    public static final int CASING_POSX = 1;
    public static final int CASING_POSY = 2;
    public static final int CASING_SPEEDX = 3;
    public static final int CASING_SPEEDY = 4;
    public static final int CASING_MAXPARAMS = 5;
    public static final int MAX_CASING = 8;
    public static final int ORIGINAL_ANGLE = 64;

    static void init(int n) {
        switch (n) {
            case 3: {
                imgGun = gameTopLevel.getImage("/gun.png");
                break;
            }
            case 4: {
                imgTank = gameTopLevel.getImage("/tank.png");
                tankWidth = imgTank.getWidth() / 10;
                tankHeight = imgTank.getHeight();
                break;
            }
            case 5: {
                imgHoming = gameTopLevel.getImage("/homing.png");
                break;
            }
            case 6: {
                imgRocketPod = gameTopLevel.getImage("/rocketpod.png");
                break;
            }
            case 7: {
                imgFlakCanon = gameTopLevel.getImage("/flakguns.png");
                break;
            }
            case 8: {
                imgLaser = gameTopLevel.getImage("/lasers.png");
                break;
            }
            case 9: {
                imgTankShadow = gameTopLevel.getImage("/tankshadow.png");
                break;
            }
            case 10: {
                imgOrb = gameTopLevel.getImage("/orb.png");
                orbPos = new int[6];
                break;
            }
            case 11: {
                imgStatic = gameTopLevel.getImage("/staticstrike.png");
                break;
            }
            case 12: {
                imgTracks = gameTopLevel.getImage("/tracks.png");
                break;
            }
            case 13: {
                imgTarget = gameTopLevel.getImage("/target.png");
                break;
            }
            case 14: {
                imgCasing = gameTopLevel.getImage("/casing.png");
                break;
            }
            case 15: {
                imgShield = gameTopLevel.getImage("/shield.png");
                imgShieldColor = gameTopLevel.getImage("/shieldcolor.png");
                break;
            }
            case 16: {
                imgMuzzle = gameTopLevel.getImage("/muzzleflash.png");
                break;
            }
            case 17: {
                imgMegaMuzzle = gameTopLevel.getImage("/megabase.png");
            }
        }
    }

    static void initNewGame() {
        speed = 4;
        if (inGame.levelNb == 255) {
            speed += 2;
        }
        homingNb = 0;
        orbNb = 0;
        staticNb = 0;
        rocketNb = 0;
        power = 2;
        shotNb = 1;
        shieldNb = 1;
        speedShot = 6;
        laserNb = 0;
        flakNb = 0;
    }

    static void initCasing() {
        casingParam = new int[40];
        for (int i = 0; i < 8; ++i) {
            Hero.casingParam[i * 5 + 0] = 0;
        }
        casingCurrentMax = 0;
    }

    static void initLevel(int n) {
        tankPosX = -tankWidth;
        tankPosY = MOBCanvas.CANVAS_HEIGHT - tankHeight - Landscape.imgGround.getHeight() + n;
        tankMaxPosX = 0;
        tankInertia = 6;
        if (shieldNb == 0 && inGame.levelNb < 255) {
            shieldNb = 1;
        }
        targetAngle = 64;
        targetAnglePos = 64;
        targetAngleAccel = 0;
        targetAngleDuck = targetAnglePos;
        targetPosX = MOBCanvas.CANVAS_WIDTH / 2;
        targetPosY = tankPosY + 6 - 130;
        targetDuck = false;
        Hero.initCasing();
        speedShotParam = speedShot;
        speedRocketParam = 16;
        speedHomingParam = 24 - (homingNb - 1) * 5;
        speedLaserParam = 20 - (laserNb - 1) * 2;
        orbAngle = 0;
        targetFrame = 0;
        targetAddFrame = 1;
        decSpeedShotParam = 1;
        invincibleTimer = 0;
        invincibleTimer2 = 0;
    }

    static void closeLevel() {
        casingParam = null;
    }

    static void dead() {
        inGame.gameStatus = --Board.liveNb < 0 ? (inGame.gameStatus |= 8) : (inGame.gameStatus |= 4);
        Board.drawStatus |= 1;
        Explosion.generate(tankPosX + (tankWidth - 62) / 2, tankPosY + (tankHeight - 55) / 2, 0, 0);
        RandomObject.addCrater(tankPosX + tankWidth / 2, false);
        Shot.clearLaserShot();
        speedShotParam = speedShot;
        speedRocketParam = 16;
        speedHomingParam = 24 - (homingNb - 1) * 5;
        speedLaserParam = 20 - (laserNb - 1) * 2;
        tankPosX = -(tankWidth * 4);
        shieldNb = 1;
        tankInertia = 6;
        targetAngle = 64;
        targetAnglePos = 64;
        targetAngleAccel = 0;
        targetAngleDuck = targetAnglePos;
        targetPosX = MOBCanvas.CANVAS_WIDTH / 2;
        targetPosY = tankPosY + 6 - 130;
        targetDuck = false;
        searchForBestPos = false;
        Board.nukeNb = 0;
        Board.laserused = 0;
        Board.laser = 0;
    }

    static void recomputeMaxCasing() {
        if (casingCurrentMax > 0) {
            while (casingParam[(casingCurrentMax - 1) * 5 + 0] == 0) {
                if (--casingCurrentMax != 0) continue;
                return;
            }
        }
    }

    static void updateCasing() {
        int n = 0;
        int n2 = 0;
        while (n < casingCurrentMax) {
            if (casingParam[n2 + 0] == 1) {
                int n3 = n2 + 1;
                casingParam[n3] = casingParam[n3] + casingParam[n2 + 3] / 6;
                int n4 = n2 + 2;
                casingParam[n4] = casingParam[n4] + casingParam[n2 + 4];
                if (casingParam[n2 + 3] < 0) {
                    int n5 = n2 + 3;
                    casingParam[n5] = casingParam[n5] + 1;
                }
                if (casingParam[n2 + 4] < 6) {
                    int n6 = n2 + 4;
                    casingParam[n6] = casingParam[n6] + 1;
                }
                if (casingParam[n2 + 2] > MOBCanvas.CANVAS_HEIGHT) {
                    Hero.casingParam[n2 + 0] = 0;
                    Hero.recomputeMaxCasing();
                }
            }
            ++n;
            n2 += 5;
        }
    }

    static void addCasing(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n3 < 8 && casingParam[n4 + 0] != 0) {
            ++n3;
            n4 += 5;
        }
        if (n3 < 8) {
            if (casingCurrentMax < n3 + n3) {
                casingCurrentMax = n3 + 1;
            }
            Hero.casingParam[n4 + 1] = n;
            Hero.casingParam[n4 + 2] = n2;
            Hero.casingParam[n4 + 3] = -18;
            Hero.casingParam[n4 + 4] = -4;
            Hero.casingParam[n4 + 0] = 1;
        }
    }

    static void updateTarget() {
        if ((inGame.gameStatus & 0xF) != 0) {
            return;
        }
        if (!targetDuck) {
            int n;
            boolean bl;
            if (searchForBestPos) {
                boolean bl2;
                int n2 = targetPosX;
                targetPosX = MOBCanvas.CANVAS_WIDTH / 2 + 190 * gameTopLevel.cos(targetAngleDuck -= targetDuckAdd) / 1024;
                targetPosY = tankPosY + 6 - 130 * gameTopLevel.sin(targetAngleDuck) / 1024;
                if (targetPosX > tankPosX + tankWidth / 2 && n2 < tankPosX + tankWidth / 2) {
                    bl2 = false;
                    searchForBestPos = false;
                    while (targetPosX > tankPosX + tankWidth / 2) {
                        targetPosX = MOBCanvas.CANVAS_WIDTH / 2 + 190 * gameTopLevel.cos(++targetAngleDuck) / 1024;
                        bl2 = true;
                    }
                    targetPosY = tankPosY + 6 - 130 * gameTopLevel.sin(targetAngleDuck) / 1024;
                    targetAnglePos = targetAngleDuck;
                    if (bl2) {
                        --targetAnglePos;
                        targetPosX = tankPosX + tankWidth / 2;
                    }
                }
                if (targetPosX < tankPosX + tankWidth / 2 && n2 > tankPosX + tankWidth / 2) {
                    bl2 = false;
                    searchForBestPos = false;
                    while (targetPosX < tankPosX + tankWidth / 2) {
                        targetPosX = MOBCanvas.CANVAS_WIDTH / 2 + 190 * gameTopLevel.cos(--targetAngleDuck) / 1024;
                        bl2 = true;
                    }
                    targetPosY = tankPosY + 6 - 130 * gameTopLevel.sin(targetAngleDuck) / 1024;
                    targetAnglePos = targetAngleDuck;
                    if (bl2) {
                        ++targetAnglePos;
                        targetPosX = tankPosX + tankWidth / 2;
                    }
                }
                if (targetPosX == tankPosX + tankWidth / 2) {
                    searchForBestPos = false;
                }
                return;
            }
            if ((gameTopLevel.keyDown & 0x8100) != 0) {
                int n3 = Enemy.getGroundEnemyX();
                targetDuck = true;
                targetDuckAdd = n3 == -65535 ? (tankPosX + tankWidth / 2 < MOBCanvas.CANVAS_WIDTH / 2 ? -8 : 8) : (n3 > tankPosX ? -8 : 8);
                targetAngleDuck = targetAnglePos;
                return;
            }
            if ((gameTopLevel.keyDown & 0x80) != 0) {
                targetDuck = true;
                targetDuckAdd = 8;
            }
            if ((gameTopLevel.keyDown & 0x200) != 0) {
                targetDuck = true;
                targetDuckAdd = -8;
            }
            if ((gameTopLevel.keyDown & 0x400E) != 0) {
                if (targetPosX > tankPosX + tankWidth / 2) {
                    targetDuckAdd = -8;
                    searchForBestPos = true;
                    return;
                }
                if (targetPosX < tankPosX + tankWidth / 2) {
                    targetDuckAdd = 8;
                    searchForBestPos = true;
                    return;
                }
            }
            if ((gameTopLevel.keyPressed & 0x3050) == 0) {
                targetAngleAccel = 0;
            }
            if ((gameTopLevel.keyPressed & 0x1010) != 0) {
                bl = false;
                if (++targetAngleAccel > (6 + (speed - 4) / 2) * 2) {
                    targetAngleAccel = (6 + (speed - 4) / 2) * 2;
                }
                if ((n = MOBCanvas.CANVAS_WIDTH / 2 + 190 * gameTopLevel.cos(targetAnglePos += targetAngleAccel / 2) / 1024) < targetPosX) {
                    targetPosX = n;
                }
                while (targetPosX < 0) {
                    targetPosX = MOBCanvas.CANVAS_WIDTH / 2 + 190 * gameTopLevel.cos(--targetAnglePos) / 1024;
                    bl = true;
                }
                if (bl) {
                    ++targetAnglePos;
                    targetPosX = 0;
                }
            }
            if ((gameTopLevel.keyPressed & 0x2040) != 0) {
                bl = false;
                if (++targetAngleAccel > (6 + (speed - 4) / 2) * 2) {
                    targetAngleAccel = (6 + (speed - 4) / 2) * 2;
                }
                if ((n = MOBCanvas.CANVAS_WIDTH / 2 + 190 * gameTopLevel.cos(targetAnglePos -= targetAngleAccel / 2) / 1024) > targetPosX) {
                    targetPosX = n;
                }
                while (targetPosX > MOBCanvas.CANVAS_WIDTH) {
                    targetPosX = MOBCanvas.CANVAS_WIDTH / 2 + 190 * gameTopLevel.cos(++targetAnglePos) / 1024;
                    bl = true;
                }
                if (bl) {
                    --targetAnglePos;
                    targetPosX = MOBCanvas.CANVAS_WIDTH;
                }
            }
            targetPosY = tankPosY + 6 - 130 * gameTopLevel.sin(targetAnglePos) / 1024;
            targetAngleDuck = targetAnglePos;
        } else {
            if ((gameTopLevel.keyDown & 0x400E) != 0) {
                targetDuck = false;
                searchForBestPos = true;
                return;
            }
            if ((gameTopLevel.keyDown & 0x80) != 0) {
                targetDuck = true;
                targetDuckAdd = 8;
            }
            if ((gameTopLevel.keyDown & 0x200) != 0) {
                targetDuck = true;
                targetDuckAdd = -8;
            }
            if ((gameTopLevel.keyDown & 0x8100) != 0) {
                int n = Enemy.getGroundEnemyX();
                targetDuckAdd = n == -65535 ? (tankPosX + tankWidth / 2 < MOBCanvas.CANVAS_WIDTH / 2 ? -8 : 8) : (n > tankPosX ? -8 : 8);
            }
            targetAngleDuck += targetDuckAdd;
            if (targetDuckAdd < 0) {
                if (targetAngleDuck < 0) {
                    targetAngleDuck = 0;
                }
            } else if (targetAngleDuck > 128) {
                targetAngleDuck = 128;
            }
            targetPosX = MOBCanvas.CANVAS_WIDTH / 2 + MOBCanvas.CANVAS_WIDTH / 2 * gameTopLevel.cos(targetAngleDuck) / 1024;
            targetPosY = tankPosY + 6 - 130 * gameTopLevel.sin(targetAngleDuck) / 1024;
        }
    }

    static void updateOrbs() {
        if (orbNb > 0) {
            int n = 256 / orbNb;
            int n2 = orbAngle;
            int n3 = 0;
            while (n3 < orbNb) {
                Hero.orbPos[n3 * 2] = tankPosX + (tankWidth - imgOrb.getWidth()) / 2 + 23 * gameTopLevel.cos(n2) / 1024;
                Hero.orbPos[n3 * 2 + 1] = tankPosY + (tankHeight - imgOrb.getHeight()) / 2 - 23 * gameTopLevel.sin(n2) / 1024;
                ++n3;
                n2 += n;
            }
        }
    }

    static void update() {
        int n;
        int n2 = tankPosX;
        if (invincibleTimer > 0) {
            --invincibleTimer;
        }
        if (invincibleTimer2 > 0) {
            --invincibleTimer2;
        }
        if ((targetFrame += targetAddFrame) == 0 || targetFrame == 5) {
            targetAddFrame = -targetAddFrame;
        }
        if (Landscape.landscapePos + tankPosX + tankWidth / 2 + tankWidth / 4 > tankMaxPosX && (inGame.gameStatus & 8) == 0) {
            tankMaxPosX = Landscape.landscapePos + tankPosX + tankWidth / 2 + tankWidth / 4;
        }
        Hero.updateCasing();
        switch (orbNb) {
            case 1: {
                orbAngle += 18;
                break;
            }
            case 2: {
                orbAngle += 12;
                break;
            }
            case 3: {
                orbAngle += 6;
            }
        }
        Hero.updateOrbs();
        if ((inGame.gameStatus & 1) != 0) {
            Hero.updateTarget();
            if ((tankPosX += 2) >= MOBCanvas.CANVAS_WIDTH - tankWidth >> 1) {
                inGame.gameStatus &= 0xFFFFFFFE;
                if (inGame.levelNb > 512) {
                    Enemy.addEnemy(11, 256);
                } else if (inGame.levelNb < 512) {
                    soundGame.playMusic(14);
                }
            }
            return;
        }
        if ((inGame.gameStatus & 4) != 0) {
            if (tankPosX + tankWidth < 0 && tankPosX + tankWidth + 2 >= 0) {
                soundGame.stopMusic(14);
                soundGame.playSound(7);
                inGame.addGameText(gameTopLevel.topLevel.getUtfText(178), null);
            }
            Hero.updateTarget();
            if ((tankPosX += 2) >= MOBCanvas.CANVAS_WIDTH - tankWidth >> 1) {
                invincibleTimer = 75;
                if (((inGame.gameStatus &= 0xFFFFFFFB) & 0x40) != 0) {
                    soundGame.playMusic(12);
                } else {
                    soundGame.playMusic(14);
                }
                return;
            }
            if (tankPosX > 0 && (gameTopLevel.keyPressed & 0x3050) != 0) {
                invincibleTimer = 75;
                if (((inGame.gameStatus &= 0xFFFFFFFB) & 0x40) != 0) {
                    soundGame.playMusic(12);
                } else {
                    soundGame.playMusic(14);
                }
            }
            return;
        }
        if ((inGame.gameStatus & 8) != 0) {
            if (tankPosX < 0 && tankPosX + 2 >= 0) {
                soundGame.stopMusic(14);
                soundGame.playSound(8);
                inGame.addGameText(gameTopLevel.topLevel.getUtfText(179), null);
            }
            Hero.updateTarget();
            if ((tankPosX += 2) >= (MOBCanvas.CANVAS_WIDTH >> 1) + tankWidth) {
                inGame.gameStatus |= 0x10;
            }
            return;
        }
        if ((inGame.gameStatus & 2) != 0) {
            if (targetAnglePos > 64) {
                --targetAnglePos;
            } else if (targetAnglePos < 64) {
                ++targetAnglePos;
            }
            decSpeedShotParam = 0;
            targetDuck = false;
            targetPosX = MOBCanvas.CANVAS_WIDTH / 2 + 190 * gameTopLevel.cos(targetAnglePos) / 1024;
            targetPosY = tankPosY + 6 - 130 * gameTopLevel.sin(targetAnglePos) / 1024;
            n = 0;
            if (tankPosX + tankWidth / 2 > targetPosX) {
                n = (targetPosX - (tankPosX + tankWidth / 2)) / 2;
                if (n == 0) {
                    n = -1;
                }
                if (n < -speed) {
                    n = -speed;
                }
            }
            if (tankPosX + tankWidth / 2 < targetPosX) {
                n = (targetPosX - (tankPosX + tankWidth / 2)) / 2;
                if (n == 0) {
                    n = 1;
                }
                if (n > speed) {
                    n = speed;
                }
            }
            n2 = tankPosX + n;
        } else {
            if (Boss.life == 0 || Boss.active && !Boss.canBeHit) {
                speedShotParam = speedShot;
                speedRocketParam = 14;
                speedLaserParam = 20 - (laserNb - 1) * 2;
                speedHomingParam = 24 - (homingNb - 1) * 5;
            }
            Hero.updateTarget();
            if (!targetDuck) {
                if (targetAngleDuck == targetAnglePos) {
                    n = 0;
                    if ((gameTopLevel.keyPressed & 0x1010) != 0) {
                        n = -speed;
                    }
                    if ((gameTopLevel.keyPressed & 0x2040) != 0) {
                        n = speed;
                    }
                    n2 = tankPosX + n;
                }
            } else {
                n = 0;
                if ((gameTopLevel.keyPressed & 0x1010) != 0) {
                    n2 = tankPosX - speed;
                }
                if ((gameTopLevel.keyPressed & 0x2040) != 0) {
                    n2 = tankPosX + speed;
                }
            }
            if (n2 < 4) {
                n2 = 4;
            }
            if (n2 + tankWidth > MOBCanvas.CANVAS_WIDTH - 4) {
                n2 = MOBCanvas.CANVAS_WIDTH - 4 - tankWidth;
            }
        }
        int n3 = 0;
        int n4 = 0;
        while (n3 < 11) {
            if ((Enemy.enemyParams[n4 + 11] & 4) != 0 && Enemy.enemyParams[n4 + 0] != -1 && inGame.collision(n2, tankPosY, tankWidth, tankHeight, Enemy.enemyParams[n4 + 1], Enemy.enemyParams[n4 + 2], Enemy.enemyParams[n4 + 5], Enemy.enemyParams[n4 + 6])) {
                if (n2 < Enemy.enemyParams[n4 + 1]) {
                    n2 = Enemy.enemyParams[n4 + 1] - tankWidth;
                    break;
                }
                if (n2 > Enemy.enemyParams[n4 + 1]) {
                    n2 = Enemy.enemyParams[n4 + 1] + Enemy.enemyParams[n4 + 5];
                    break;
                }
            }
            ++n3;
            n4 += 15;
        }
        if (tankPosX != n2) {
            if (tankInertia > 1) {
                --tankInertia;
            }
            tankPosX += (n2 - tankPosX) / tankInertia;
        } else {
            tankInertia = 6 + (speed - 4);
        }
        targetAngle = gameTopLevel.ratan2(tankPosY + 6 - targetPosY, targetPosX - (tankPosX + tankWidth / 2)) / 16 + 1;
        if (targetAngle < 0) {
            targetAngle = 0;
        }
        if (Board.laserused == 0) {
            int n5;
            int n6;
            int n7;
            if ((speedShotParam -= decSpeedShotParam) == 0) {
                speedShotParam = speedShot;
                Hero.addCasing(tankPosX, tankPosY);
                n = 0;
                n7 = tankPosX + tankWidth / 2 + 15 * gameTopLevel.cos(targetAngle) / 1024;
                n6 = tankPosY + 6 - 8 * gameTopLevel.sin(targetAngle) / 1024;
                n5 = gameTopLevel.ratan2(n6 - targetPosY, targetPosX - n7);
                n5 = (n5 & 0xF) > 7 ? (n5 /= 16) : (n5 /= 16);
                int[] nArray = new int[]{++n5};
                switch (shotNb) {
                    case 2: {
                        nArray = new int[]{n5 - 4, n5 + 3};
                        break;
                    }
                    case 3: {
                        nArray = new int[]{n5 - 6, n5, n5 + 5};
                        break;
                    }
                    case 4: {
                        nArray = new int[]{n5 - 8, n5 - 4, n5 + 3, n5 + 8};
                        break;
                    }
                    case 5: {
                        nArray = new int[]{n5 - 9, n5 - 5, n5, n5 + 4, n5 + 9};
                    }
                }
                for (n3 = 0; n3 < shotNb; ++n3) {
                    Shot.generate(tankPosX + tankWidth / 2 + 16 * gameTopLevel.cos(targetAngle) / 1024, tankPosY + 6 - 14 * gameTopLevel.sin(targetAngle) / 1024, 0, 8, nArray[n3], power);
                }
            }
            if (flakNb > 0 && Boss.life != 0 && (!Boss.active || Boss.canBeHit) && speedShotParam % 3 == 0) {
                Shot.generate(targetPosX + Enemy.rnd.nextInt() % (flakNb * 16), targetPosY + Enemy.rnd.nextInt() % (flakNb * 16), 4, 0, 0, flakNb * 2);
            }
            if (rocketNb > 0 && (speedRocketParam -= decSpeedShotParam) == 0) {
                n = 13;
                if ((rocketNb & 1) != 0) {
                    n5 = tankPosX + tankWidth / 2;
                    int n8 = tankPosY + 4;
                    Shot.generate(n5, n8, 1, 8, targetAngle, 11);
                }
                if (rocketNb > 1) {
                    if (rocketNb > 2) {
                        n = 15;
                    }
                    n7 = tankPosX + tankWidth / 2;
                    n6 = tankPosY + 4;
                    n5 = n7 + n * gameTopLevel.cos(targetAngle + 64) / 1024;
                    int n9 = n6 - n * gameTopLevel.sin(targetAngle + 64) / 1024;
                    Shot.generate(n5, n9, 1, 8, targetAngle, 11);
                    n5 = n7 + n * gameTopLevel.cos(targetAngle - 64) / 1024;
                    n9 = n6 - n * gameTopLevel.sin(targetAngle - 64) / 1024;
                    Shot.generate(n5, n9, 1, 8, targetAngle, 11);
                }
                speedRocketParam = 14;
            }
            if (laserNb > 0 && (speedLaserParam -= decSpeedShotParam) == 0) {
                n = tankPosX + tankWidth / 2;
                n7 = tankPosY + 8;
                n6 = (n + 20 * gameTopLevel.cos(targetAngle)) / 1024;
                n5 = (n7 - 20 * gameTopLevel.sin(targetAngle)) / 1024;
                int n10 = gameTopLevel.ratan2(n5 - targetPosY, targetPosX - n6);
                if ((n10 & 0xF) > 7) {
                    n10 /= 16;
                    ++n10;
                } else {
                    n10 /= 16;
                }
                Shot.generate(n, n7, 5, 0, n10, laserNb);
                speedLaserParam = 20 - (laserNb - 1) * 2;
            }
            if (homingNb > 0 && (speedHomingParam -= decSpeedShotParam) == 0) {
                n = tankPosX + tankWidth / 2;
                n7 = tankPosY + 4 - Shot.imgHeroRockets.getHeight() / 2;
                Shot.generate(n, n7, 2, 10, 64, 8);
                speedHomingParam = 24 - (homingNb - 1) * 5;
            }
        } else {
            int n11 = Shot.imgHeroMegaLaser.getWidth() / 5 / 2;
            speedShotParam = speedShot;
            n = tankPosX + (tankWidth - 28) / 2 + 24 * gameTopLevel.cos(targetAngle) / 1024;
            int n12 = tankPosY + -6 - 20 * gameTopLevel.sin(targetAngle) / 1024;
            for (int i = 0; i < 24; ++i) {
                Shot.generate(n + (n11 * i + menuGame.menuSelectionCounter * 7 % n11) * gameTopLevel.cos(targetAngle) / 1024, n12 - (n11 * i + menuGame.menuSelectionCounter * 7 % n11) * gameTopLevel.sin(targetAngle) / 1024, 6, 0, 0, 65535);
            }
        }
    }

    static void checkCollision() {
        int n = 0;
        int n2 = 0;
        while (n < Shot.enemyShotCurrentMax) {
            if (Shot.enemyShotParam[n2 + 0] != -1) {
                if (Shot.enemyShotParam[n2 + 0] != 10 && Shot.enemyShotParam[n2 + 0] != 16 && Shot.enemyShotParam[n2 + 0] != 14 && Shot.enemyShotParam[n2 + 0] != 17 && Shot.enemyShotParam[n2 + 0] != 18) {
                    for (int i = 0; i < orbNb; ++i) {
                        if (!inGame.collision(Shot.enemyShotParam[n2 + 1] / 1024 + 2, Shot.enemyShotParam[n2 + 2] / 1024 + 2, Shot.enemyShotParam[n2 + 3] - 4, Shot.enemyShotParam[n2 + 4] - 4, orbPos[i * 2] + 2, orbPos[i * 2 + 1] + 2, imgOrb.getWidth() - 4, imgOrb.getHeight() - 4)) continue;
                        if (Shot.enemyShotParam[n2 + 0] == 3) {
                            Explosion.generate(Shot.enemyShotParam[n2 + 1] / 1024 - (62 - Shot.enemyShotParam[n2 + 3]) / 2, Shot.enemyShotParam[n2 + 2] / 1024 - (55 - Shot.enemyShotParam[n2 + 4]) / 2, 0, 0);
                        } else {
                            Explosion.generate(Shot.enemyShotParam[n2 + 1] / 1024 - (62 - Shot.enemyShotParam[n2 + 3]) / 2, Shot.enemyShotParam[n2 + 2] / 1024 - (55 - Shot.enemyShotParam[n2 + 4]) / 2, 4, 0);
                        }
                        Shot.enemyShotParam[n2 + 0] = -1;
                        Shot.recomputeMaxEnemyShot();
                    }
                }
                if (Shot.enemyShotParam[n2 + 0] == 10 || Shot.enemyShotParam[n2 + 0] == 16) {
                    if ((Shot.enemyShotParam[n2 + 0] != 10 || Shot.enemyShotParam[n2 + 6] <= 30) && inGame.collision(Shot.enemyShotParam[n2 + 1] / 1024, Shot.enemyShotParam[n2 + 2] / 1024, 4, 280, tankPosX + 7, tankPosY + 6, tankWidth - 14, tankHeight - 12)) {
                        Explosion.generate(Shot.enemyShotParam[n2 + 1] / 1024 - (62 - Shot.enemyShotParam[n2 + 3]) / 2, Shot.enemyShotParam[n2 + 2] / 1024 - (55 - Shot.enemyShotParam[n2 + 4]) / 2, 0, 0);
                        if (invincibleTimer == 0) {
                            Hero.dead();
                        }
                    }
                } else if (inGame.collision(Shot.enemyShotParam[n2 + 1] / 1024 + 6, Shot.enemyShotParam[n2 + 2] / 1024 + 6, Shot.enemyShotParam[n2 + 3] - 12, Shot.enemyShotParam[n2 + 4] - 12, tankPosX + 7, tankPosY + 6, tankWidth - 14, tankHeight - 6)) {
                    if (Shot.enemyShotParam[n2 + 0] == 3 || Shot.enemyShotParam[n2 + 0] == 17 || Shot.enemyShotParam[n2 + 0] == 18) {
                        Explosion.generate(Shot.enemyShotParam[n2 + 1] / 1024 - (62 - Shot.enemyShotParam[n2 + 3]) / 2, Shot.enemyShotParam[n2 + 2] / 1024 - (55 - Shot.enemyShotParam[n2 + 4]) / 2, 0, 0);
                        Explosion.generate(0, 0, 1, 0);
                        if (invincibleTimer == 0) {
                            Hero.dead();
                        }
                    } else {
                        Explosion.generate(Shot.enemyShotParam[n2 + 1] / 1024 - (62 - Shot.enemyShotParam[n2 + 3]) / 2, Shot.enemyShotParam[n2 + 2] / 1024 - (55 - Shot.enemyShotParam[n2 + 4]) / 2, 4, 0);
                        if (invincibleTimer == 0 && invincibleTimer2 == 0) {
                            if (--shieldNb == 0 && saveGame.gameData[506] == 0) {
                                inGame.pushHint(192);
                                saveGame.gameData[506] = 1;
                            }
                            if (shieldNb < 0) {
                                Hero.dead();
                            } else {
                                invincibleTimer2 = 5;
                            }
                        }
                    }
                    Shot.enemyShotParam[n2 + 0] = -1;
                    Shot.recomputeMaxEnemyShot();
                }
            }
            ++n;
            n2 += 9;
        }
        n = 0;
        n2 = 0;
        while (n < 11) {
            if ((Enemy.enemyParams[n2 + 0] == 20 || Enemy.enemyParams[n2 + 0] == 10 || Enemy.enemyParams[n2 + 0] == 11) && inGame.collision(tankPosX + 7, tankPosY + 6, tankWidth - 14, tankHeight - 12, Enemy.enemyParams[n2 + 1] + 4, Enemy.enemyParams[n2 + 2] + 4, Enemy.enemyParams[n2 + 5] - 8, Enemy.enemyParams[n2 + 6] - 8)) {
                switch (Enemy.enemyParams[n2 + 0]) {
                    case 20: {
                        if (invincibleTimer != 0) break;
                        Hero.dead();
                        break;
                    }
                    case 10: 
                    case 11: {
                        if (invincibleTimer == 0) {
                            if (--shieldNb == 0 && saveGame.gameData[506] == 0) {
                                inGame.pushHint(192);
                                saveGame.gameData[506] = 1;
                            }
                            if (shieldNb < 0) {
                                Hero.dead();
                            } else {
                                invincibleTimer2 = 5;
                            }
                        }
                        int n3 = n2 + 11;
                        Enemy.enemyParams[n3] = Enemy.enemyParams[n3] & 0xFFFFFEFF;
                        Enemy.dead(n2, -2);
                    }
                }
            }
            ++n;
            n2 += 15;
        }
    }

    static void drawCasing(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        while (n < casingCurrentMax) {
            if (casingParam[n2 + 0] == 1) {
                graphics.drawImage(imgCasing, casingParam[n2 + 1], casingParam[n2 + 2], 0x10 | 4);
            }
            ++n;
            n2 += 5;
        }
    }

    static void draw(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = -Landscape.landscapePos;
        n5 %= imgTracks.getWidth();
        while (n5 < tankMaxPosX - Landscape.landscapePos) {
            if (n5 + imgTracks.getWidth() < tankMaxPosX - Landscape.landscapePos) {
                graphics.drawImage(imgTracks, n5, tankPosY + 20, 0x10 | 4);
                n5 += imgTracks.getWidth();
                continue;
            }
            graphics.drawRegion(imgTracks, 0, 0, tankMaxPosX - Landscape.landscapePos - n5, imgTracks.getHeight(), 0, n5, tankPosY + 20, 0x10 | 4);
            n5 += tankMaxPosX - Landscape.landscapePos - n5;
        }
        if ((inGame.gameStatus & 8) != 0) {
            return;
        }
        if (!(inGame.gamePaused || invincibleTimer == 0 && (inGame.gameStatus & 4) == 0 || (menuGame.menuSelectionCounter / 4 & 1) == 0)) {
            return;
        }
        graphics.drawImage(imgTankShadow, tankPosX - (imgTankShadow.getWidth() - tankWidth) / 2, tankPosY + 17, 0x10 | 4);
        int n6 = shieldNb;
        if (n6 > 4) {
            n6 = 4;
        }
        if (n6 > 0) {
            graphics.drawRegion(imgShieldColor, (n6 - 1) * tankWidth, 0, tankWidth, imgShieldColor.getHeight(), 0, tankPosX, tankPosY + (tankHeight - imgShieldColor.getHeight()) / 2, 0x10 | 4);
        }
        for (n6 = (Landscape.landscapePos + tankPosX) / 2; n6 < 0; n6 += 10) {
        }
        graphics.drawRegion(imgTank, n6 % 10 * tankWidth, 0, tankWidth, tankHeight, 0, tankPosX, tankPosY, 0x10 | 4);
        if (speedShotParam == 1) {
            graphics.drawImage(imgMuzzle, tankPosX + (tankWidth - imgMuzzle.getWidth()) / 2 + 24 * gameTopLevel.cos(targetAngle) / 1024, tankPosY + -6 - 20 * gameTopLevel.sin(targetAngle) / 1024, 0x10 | 4);
        }
        if (Board.laserused != 0) {
            graphics.drawImage(imgMegaMuzzle, tankPosX + (tankWidth - imgMegaMuzzle.getWidth()) / 2 + 24 * gameTopLevel.cos(targetAngle) / 1024, tankPosY + -6 - 20 * gameTopLevel.sin(targetAngle) / 1024, 0x10 | 4);
        }
        int n7 = 21 - (targetAngle + 3) * 21 / 128;
        if (flakNb > 0) {
            n4 = 40;
            n3 = imgFlakCanon.getHeight() / 3;
            n2 = imgFlakCanon.getWidth() / 11;
            if (n7 < 11) {
                graphics.drawRegion(imgFlakCanon, n2 * n7, n3 * (flakNb - 1), n2, n3, 0, tankPosX + (tankWidth - n4) / 2, tankPosY - n3 / 2 + 2, 0x10 | 4);
            } else {
                graphics.drawRegion(imgFlakCanon, n2 * (21 - n7), n3 * (flakNb - 1), n2, n3, 2, tankPosX + (tankWidth - n4) / 2 + (n4 - n2), tankPosY - n3 / 2 + 2, 0x10 | 4);
            }
        }
        n4 = 40;
        n3 = imgGun.getHeight() / 5;
        n2 = imgGun.getWidth() / 11;
        if (n7 < 11) {
            graphics.drawRegion(imgGun, n2 * n7, n3 * (shotNb - 1), n2, n3, 0, tankPosX + (tankWidth - n4) / 2, tankPosY - n3 / 2 + -1, 0x10 | 4);
        } else {
            graphics.drawRegion(imgGun, n2 * (21 - n7), n3 * (shotNb - 1), n2, n3, 2, tankPosX + (tankWidth - n4) / 2 + (n4 - n2), tankPosY - n3 / 2 + -1, 0x10 | 4);
        }
        if (laserNb > 0) {
            n4 = 28;
            n3 = imgLaser.getHeight() / 3;
            n2 = imgLaser.getWidth() / 11;
            if (n7 < 11) {
                graphics.drawRegion(imgLaser, n2 * n7, n3 * (laserNb - 1), n2, n3, 0, tankPosX + (tankWidth - n4) / 2, tankPosY - n3 / 2 + 3, 0x10 | 4);
            } else {
                graphics.drawRegion(imgLaser, n2 * (21 - n7), n3 * (laserNb - 1), n2, n3, 2, tankPosX + (tankWidth - n4) / 2 + (n4 - n2), tankPosY - n3 / 2 + 3, 0x10 | 4);
            }
        }
        if (rocketNb > 0 && (rocketNb & 1) != 0) {
            n4 = imgRocketPod.getWidth() / 11;
            n3 = imgRocketPod.getHeight();
            if (n7 < 11) {
                graphics.drawRegion(imgRocketPod, n4 * n7, 0, n4, n3, 0, tankPosX + (tankWidth - n4) / 2, tankPosY + 4 - n3 / 2, 0x10 | 4);
            } else {
                graphics.drawRegion(imgRocketPod, n4 * (21 - n7), 0, n4, n3, 2, tankPosX + (tankWidth - n4) / 2, tankPosY + 4 - n3 / 2, 0x10 | 4);
            }
        }
        if (homingNb > 0) {
            n4 = imgHoming.getWidth() / 3;
            n3 = imgHoming.getHeight();
            graphics.drawRegion(imgHoming, n4 * (homingNb - 1), 0, n4, n3, 0, tankPosX + (tankWidth - n4) / 2, tankPosY + (tankHeight - n3) / 2 + -2, 0x10 | 4);
        }
        if (staticNb > 0) {
            n4 = imgStatic.getWidth();
            n3 = imgStatic.getHeight() / 3;
            graphics.drawRegion(imgStatic, 0, n3 * (staticNb - 1), n4, n3, 0, tankPosX + (tankWidth - n4) / 2, tankPosY + (tankHeight - n3) / 2, 0x10 | 4);
        }
        if (rocketNb > 1) {
            n4 = imgRocketPod.getWidth() / 11;
            n3 = imgRocketPod.getHeight();
            n = 13;
            if (rocketNb > 2) {
                n = 15;
            }
            int n8 = tankPosX + tankWidth / 2;
            int n9 = tankPosY + 5;
            int n10 = n8 + n * gameTopLevel.cos(targetAngle + 64) / 1024;
            int n11 = n9 - n * gameTopLevel.sin(targetAngle + 64) / 1024;
            if (n7 < 11) {
                graphics.drawRegion(imgRocketPod, n4 * n7, 0, n4, n3, 0, n10 - n4 / 2, n11 - n3 / 2, 0x10 | 4);
            } else {
                graphics.drawRegion(imgRocketPod, n4 * (21 - n7), 0, n4, n3, 2, n10 - n4 / 2, n11 - n3 / 2, 0x10 | 4);
            }
            n10 = n8 + n * gameTopLevel.cos(targetAngle - 64) / 1024;
            n11 = n9 - n * gameTopLevel.sin(targetAngle - 64) / 1024;
            if (n7 < 11) {
                graphics.drawRegion(imgRocketPod, n4 * n7, 0, n4, n3, 0, n10 - n4 / 2, n11 - n3 / 2, 0x10 | 4);
            } else {
                graphics.drawRegion(imgRocketPod, n4 * (21 - n7), 0, n4, n3, 2, n10 - n4 / 2, n11 - n3 / 2, 0x10 | 4);
            }
        }
        if (orbNb > 0) {
            for (n = 0; n < orbNb; ++n) {
                graphics.drawImage(imgOrb, orbPos[n * 2], orbPos[n * 2 + 1], 0x10 | 4);
            }
        }
        if (shieldNb > 0) {
            n = Enemy.rotorFrame / 2 % 5;
            n4 = imgShield.getWidth() / 5;
            n3 = imgShield.getHeight();
            graphics.drawRegion(imgShield, n4 * n, 0, n4, n3, 0, tankPosX + (tankWidth - n4) / 2, tankPosY + (tankHeight - n3) / 2, 0x10 | 4);
        }
    }

    static void drawMenu(Graphics graphics) {
        int n;
        graphics.drawImage(imgTankShadow, tankPosX - (imgTankShadow.getWidth() - tankWidth) / 2, tankPosY + 17, 0x10 | 4);
        for (n = tankPosX / 2; n < 0; n += 10) {
        }
        graphics.drawRegion(imgTank, n % 10 * tankWidth, 0, tankWidth, tankHeight, 0, tankPosX, tankPosY, 0x10 | 4);
        if (speedShotParam == 1) {
            graphics.drawImage(imgMuzzle, tankPosX + (tankWidth - imgMuzzle.getWidth()) / 2 + 24 * gameTopLevel.cos(targetAngle) / 1024, tankPosY + -6 - 20 * gameTopLevel.sin(targetAngle) / 1024, 0x10 | 4);
        }
        int n2 = 40;
        int n3 = imgGun.getHeight() / 5;
        int n4 = imgGun.getWidth() / 11;
        int n5 = 20 - targetAngle * 20 / 128;
        if (n5 < 11) {
            graphics.drawRegion(imgGun, n4 * n5, 0, n4, n3, 0, tankPosX + (tankWidth - n2) / 2, tankPosY - n3 / 2 + -1, 0x10 | 4);
        } else {
            graphics.drawRegion(imgGun, n4 * (20 - n5), 0, n4, n3, 2, tankPosX + (tankWidth - n2) / 2 + (n2 - n4), tankPosY - n3 / 2 + -1, 0x10 | 4);
        }
    }

    static void drawTarget(Graphics graphics) {
        if ((inGame.gameStatus & 0xE) == 0) {
            int n = imgTarget.getWidth() / 3;
            int n2 = imgTarget.getHeight();
            graphics.drawRegion(imgTarget, (targetFrame >> 1) * n, 0, n, n2, 0, targetPosX - (n >> 1), targetPosY - (n2 >> 1), 0x10 | 4);
        }
        Hero.drawCasing(graphics);
    }
}

