/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class RandomObject {
    public static final int MILE_DIVIDER = 2500;
    public static final int RANDOM_OBJECT_MIN_DISTANCE = 250;
    public static final int RANDOM_OBJECT_DELTAY = -12;
    public static final int RANDOM_OBJECT_MIN_DISTANCE_TOEND = 300;
    public static final int MILEMARKER_DELTA_X = 8;
    public static final int MILEMARKER_DELTA_Y = 12;
    public static final int GASSTATION_DELTA_Y = -10;
    public static final int CRATER_DELTA_Y = 3;
    public static final int NUKE_ADD_Y = 30;
    public static Image imgMileMarker;
    public static Image imgMileText;
    public static Image imgGasStation;
    public static Image imgNukeTop;
    public static Image imgNukeBottom;
    public static int nukePosX;
    public static int nukePosY;
    public static int nukeParam;
    public static Image imgCraters;
    public static Image imgPlasmaMark;
    public static int randomObjectPosX;
    public static int randomObjectPosY;
    public static int type;
    public static int param;
    public static int width;
    public static int nextDistance;
    public static int objFrequency;
    public static Image[] imgRandomObject;
    public static int oldDistanceToEnd;
    public static int[] cratersParams;
    public static int cratersCurrentMax;
    public static final int CRATERS_PARAM_TYPE = 0;
    public static final int CRATERS_PARAM_POSX = 1;
    public static final int CRATERS_PARAM_TIME = 2;
    public static final int CRATERS_PARAM_MAX = 3;
    public static final int CRATERS_MAX = 24;
    public static final int CRATER_TYPE_NONE = -1;
    public static final int CRATER_TYPE_0 = 0;
    public static final int CRATER_TYPE_1 = 1;
    public static final int CRATER_TYPE_2 = 2;
    public static final int CRATER_TYPE_3 = 3;
    public static final int CRATER_TYPE_4 = 4;
    public static final int CRATER_TYPE_PLASMA = 5;
    public static final int OBJECT_NONE = -1;
    public static final int OBJECT_MILE = 1;
    public static final int OBJECT_NORMAL = 2;
    public static final int OBJECT_GAS = 3;

    static void init(int n) {
        switch (n) {
            case 80: {
                imgMileMarker = gameTopLevel.getImage("/milemarker.png");
                break;
            }
            case 81: {
                imgMileText = gameTopLevel.getImage("/miletext.png");
                break;
            }
            case 82: {
                imgGasStation = gameTopLevel.getImage("/gasstation.png");
                break;
            }
            case 83: {
                imgCraters = gameTopLevel.getImage("/crater.png");
                break;
            }
            case 84: {
                imgPlasmaMark = gameTopLevel.getImage("/bulletglow.png");
                break;
            }
            case 85: {
                imgNukeTop = gameTopLevel.getImage("/nuketop.png");
                break;
            }
            case 86: {
                imgNukeBottom = gameTopLevel.getImage("/nukebot.png");
            }
        }
    }

    static void initLevel(int n, int n2, int n3, int n4) {
        type = -1;
        oldDistanceToEnd = Landscape.distanceLevel - Landscape.landscapePos;
        randomObjectPosY = MOBCanvas.CANVAS_HEIGHT - Landscape.imgGround.getHeight() + n2 + -12;
        objFrequency = n4;
        nextDistance = 250 + Math.abs(Enemy.rnd.nextInt()) % n4;
        cratersParams = new int[72];
        for (int i = 0; i < 24; ++i) {
            RandomObject.cratersParams[i * 3 + 0] = -1;
        }
        cratersCurrentMax = 0;
        nukePosY = -10000;
    }

    static void closeLevel() {
        cratersParams = null;
        gameTopLevel.destruct(imgRandomObject);
        imgRandomObject = null;
    }

    static void generateEnd() {
        if (inGame.levelNb >= 512) {
            return;
        }
        type = 3;
        param = 0;
        randomObjectPosX = MOBCanvas.CANVAS_WIDTH;
        width = imgGasStation.getWidth();
    }

    static void addCrater(int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < 24 && cratersParams[n3 + 0] != -1) {
            ++n2;
            n3 += 3;
        }
        if (n2 < 24) {
            if (cratersCurrentMax < n2 + 1) {
                cratersCurrentMax = n2 + 1;
            }
            if (!bl) {
                RandomObject.cratersParams[n3 + 0] = Math.abs(Enemy.rnd.nextInt() % 2);
                for (int i = 0; i < 5; ++i) {
                    Explosion.generate(n, randomObjectPosY + 3, 7, Math.abs(Enemy.rnd.nextInt() % 5) - 3);
                }
            } else {
                RandomObject.cratersParams[n3 + 0] = 5;
                RandomObject.cratersParams[n3 + 2] = 0;
            }
            RandomObject.cratersParams[n3 + 1] = n - imgCraters.getWidth() / 2 / 2;
        }
    }

    static void recomputeMaxCrater() {
        if (cratersCurrentMax > 0) {
            while (cratersParams[(cratersCurrentMax - 1) * 3 + 0] == -1) {
                if (--cratersCurrentMax != 0) continue;
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void update() {
        int n = Landscape.distanceLevel - Landscape.landscapePos;
        if (nukePosY != -10000) {
            if (nukeParam > 0) {
                nukeParam -= 4;
                for (int i = 0; i < 2; ++i) {
                    Explosion.generate(Math.abs(Enemy.rnd.nextInt() % MOBCanvas.CANVAS_WIDTH), Math.abs(Enemy.rnd.nextInt() % MOBCanvas.CANVAS_HEIGHT), 0, 0);
                }
            }
            if ((nukePosX -= 2) / 4 < -(imgNukeTop.getWidth() * 2) || --nukePosY < -(imgNukeTop.getHeight() + imgNukeBottom.getHeight())) {
                nukePosY = -10000;
            }
        }
        if (n <= 0) {
            int n2 = 0;
            int n3 = 0;
            while (true) {
                if (n2 >= cratersCurrentMax) {
                    return;
                }
                if (cratersParams[n3 + 0] == 5) {
                    int n4 = n3 + 2;
                    cratersParams[n4] = cratersParams[n4] + 1;
                    if (cratersParams[n3 + 2] > 35) {
                        RandomObject.cratersParams[n3 + 0] = -1;
                        RandomObject.recomputeMaxCrater();
                    }
                }
                ++n2;
                n3 += 3;
            }
        }
        int n5 = 0;
        for (int i = 0; i < cratersCurrentMax; ++i, n5 += 3) {
            if (cratersParams[n5 + 0] != -1) {
                int n6 = n5 + 1;
                cratersParams[n6] = cratersParams[n6] - 2;
            }
            if (cratersParams[n5 + 0] == 5) {
                int n7 = n5 + 2;
                cratersParams[n7] = cratersParams[n7] + 1;
                if (cratersParams[n5 + 2] > 35) {
                    RandomObject.cratersParams[n5 + 0] = -1;
                    RandomObject.recomputeMaxCrater();
                    continue;
                }
            }
            if (cratersParams[n5 + 1] >= -(imgCraters.getWidth() / 2)) continue;
            RandomObject.cratersParams[n5 + 0] = -1;
            RandomObject.recomputeMaxCrater();
        }
        if (type != -1) {
            if ((randomObjectPosX -= 2) < -width) {
                type = -1;
            }
            return;
        }
        if ((nextDistance -= 2) < 0) {
            nextDistance = 250 + Math.abs(Enemy.rnd.nextInt()) % objFrequency;
            if (imgRandomObject.length != 0 && n - nextDistance > 300) {
                type = 2;
                param = Math.abs(Enemy.rnd.nextInt()) % imgRandomObject.length;
                randomObjectPosX = MOBCanvas.CANVAS_WIDTH;
                width = imgRandomObject[param].getWidth();
            }
        }
        if (oldDistanceToEnd / 2500 > n / 2500 && n != 0 && inGame.levelNb != 255) {
            type = 1;
            param = n / 2500;
            randomObjectPosX = MOBCanvas.CANVAS_WIDTH;
            width = imgMileMarker.getWidth();
        }
        oldDistanceToEnd = n;
    }

    static void drawNuke(Graphics graphics) {
        if (nukePosY != -10000) {
            graphics.drawImage(imgNukeBottom, nukePosX / 4 + imgNukeTop.getWidth() - imgNukeBottom.getWidth(), nukePosY + imgNukeTop.getHeight(), 0x10 | 4);
            graphics.drawRegion(imgNukeBottom, 0, 0, imgNukeBottom.getWidth(), imgNukeBottom.getHeight(), 2, nukePosX / 4 + imgNukeTop.getWidth(), nukePosY + imgNukeTop.getHeight(), 0x10 | 4);
            graphics.drawImage(imgNukeTop, nukePosX / 4, nukePosY + nukeParam, 0x10 | 4);
            graphics.drawRegion(imgNukeTop, 0, 0, imgNukeTop.getWidth(), imgNukeTop.getHeight(), 2, nukePosX / 4 + imgNukeTop.getWidth(), nukePosY + nukeParam, 0x10 | 4);
        }
    }

    static void activateNuke() {
        nukePosY = Landscape.bgPosY + Landscape.imgBg1.getHeight() - 30 - imgNukeTop.getHeight() - imgNukeBottom.getHeight();
        nukePosX = (MOBCanvas.CANVAS_WIDTH - imgNukeTop.getWidth() * 2) / 2 * 4;
        nukeParam = 64;
    }

    static void draw(Graphics graphics) {
        switch (type) {
            case 1: {
                graphics.drawImage(imgMileMarker, randomObjectPosX, randomObjectPosY - imgMileMarker.getHeight(), 0x10 | 4);
                graphics.drawRegion(imgMileText, imgMileText.getWidth() / 5 * param, 0, imgMileText.getWidth() / 5, imgMileText.getHeight(), 0, randomObjectPosX + 8, randomObjectPosY - imgMileMarker.getHeight() + 12, 0x10 | 4);
                break;
            }
            case 3: {
                graphics.drawImage(imgGasStation, randomObjectPosX, randomObjectPosY - (imgGasStation.getHeight() + -10), 0x10 | 4);
                break;
            }
            case 2: {
                graphics.drawImage(imgRandomObject[param], randomObjectPosX, randomObjectPosY - imgRandomObject[param].getHeight(), 0x10 | 4);
            }
        }
    }

    static void drawCraters(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        while (n < cratersCurrentMax) {
            if (cratersParams[n2 + 0] != -1) {
                if (cratersParams[n2 + 0] < 5) {
                    graphics.drawRegion(imgCraters, (imgCraters.getWidth() >> 1) * cratersParams[n2 + 0], 0, imgCraters.getWidth() >> 1, imgCraters.getHeight(), 0, cratersParams[n2 + 1], randomObjectPosY + 3, 0x10 | 4);
                } else {
                    graphics.drawRegion(imgPlasmaMark, imgPlasmaMark.getWidth() / 3 * (cratersParams[n2 + 2] / 12), 0, imgPlasmaMark.getWidth() / 3, imgPlasmaMark.getHeight(), 0, cratersParams[n2 + 1], randomObjectPosY + 3, 0x10 | 4);
                }
            }
            ++n;
            n2 += 3;
        }
    }
}

