/*
 * Decompiled with CFR 0.152.
 */
public class KeySigEvent {
    private byte sf;
    private byte minor;

    public KeySigEvent(byte sf, byte minor) {
        this.sf = sf;
        this.minor = minor;
    }

    public KeySigEvent(byte[] data) {
        this.sf = data[0];
        this.minor = data[1];
        System.out.println("made key sig... sf = " + this.sf);
    }

    public void setSf(byte sf) {
        this.sf = sf;
    }

    public byte getSf() {
        return this.sf;
    }

    public void setMinor(byte minor) {
        this.minor = minor;
    }

    public byte getMinor() {
        return this.minor;
    }

    public byte[] returnBytes() {
        byte[] toReturn = new byte[]{-1, 89, 2, this.sf, this.minor};
        return toReturn;
    }

    public String toString() {
        String toReturn = "";
        String[] sharpMajorKeyNames = new String[]{"C", "G", "D", "A", "E", "B", "F#", "C#"};
        String[] flatMajorKeyNames = new String[]{"F", "Bb", "Eb", "Ab", "Db", "Gb", "Cb"};
        String[] sharpMinorKeyNames = new String[]{"A", "E", "B", "F#", "C#", "G#", "D#"};
        String[] flatMinorKeyNames = new String[]{"D", "G", "C", "F", "Bb", "Eb", "Ab"};
        if (this.minor == 1) {
            toReturn = this.sf >= 0 ? toReturn + sharpMinorKeyNames[this.sf] : toReturn + flatMinorKeyNames[Math.abs(this.sf) - 1];
            toReturn = toReturn + " minor";
        } else {
            toReturn = this.sf >= 0 ? toReturn + sharpMajorKeyNames[this.sf] : toReturn + flatMajorKeyNames[Math.abs(this.sf) - 1];
            toReturn = toReturn + " major";
        }
        return toReturn;
    }
}

