/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Player;

public class ScoreDrawingCanvas
extends Canvas
implements Runnable {
    private Score theScore;
    private int width;
    private int height;
    public byte noteSize;
    public byte durationIndicatorSize;
    private int i;
    public int currentTrack = 0;
    private int currentTrackBeforePlay = 0;
    private int ticksPerBeat;
    private int ticksPerBar;
    private int drawFromNote = 0;
    private int drawFromBeatTicks = 0;
    private int drawFromBarTicks = 0;
    private int ticksPerCrotchet;
    private int drawFromTotalDeltaTime;
    private int drawFromTicksPerBar;
    private int drawFromTicksPerBeat;
    private int incrementFrom = 0;
    private int highlightedNoteTotalDeltaTime;
    private int highlightedNoteTicksPerBar;
    private int highlightedNoteTicksPerBeat;
    private int highlightedNoteBeatTicks;
    private int highlightedNoteBarTicks;
    private int highlightedNoteDistance = 0;
    private int maxPixelsToHighlightedNote;
    private Font mFont;
    private TimeSigEvent timeSig;
    private KeySigEvent keySig;
    private Vector inKey;
    public int highlightedNote = 0;
    private int editNoteDuration;
    private int insertMode;
    private int insertDT;
    public boolean shift;
    public boolean singleSelect;
    public boolean multiSelect;
    private String highlightedNoteName;
    private String[] sharpNoteNames = new String[]{"C ", "Db ", "D ", "Eb ", "E ", "F ", "Gb ", "G ", "Ab ", "A ", "Hb ", "H "};
    private String[] flatNoteNames = new String[]{"C ", "C# ", "D ", "D# ", "E ", "F ", "F# ", "G ", "G# ", "A ", "A# ", "H "};
    public byte clef;
    public NotePlayer np;
    public int numSelectedNotes;
    private int startMultiSelectIndex;
    private int selectedNoteColour;
    private int unselectedNoteColour;
    private int highlightedNoteColour;
    private int highlightedNoteBeforePlay = 0;
    private int drawFromNoteBeforePlay = 0;
    private int drawFromtTotalDeltaTimeBeforePlay = 0;
    private int highlightedNoteDistanceBeforePlay = 0;
    private int highlightedNoteTotalDeltaTimeBeforePlay = 0;
    public boolean playing;
    private int threadTask = 0;
    private long mediaTime = 0L;
    private byte pauseThread = 0;
    private int lastIterationHighlightedNote = 0;
    private int currentNote = 0;

    public void setTicksPerCrotchet(int tpc) {
        this.ticksPerCrotchet = tpc;
        this.editNoteDuration = tpc;
    }

    public ScoreDrawingCanvas(Score sc) {
        this.mFont = Font.getFont((int)64, (int)1, (int)0);
        this.theScore = sc;
        this.ticksPerCrotchet = this.theScore.getTicksPerCrotchet();
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.maxPixelsToHighlightedNote = this.width / 8 * 3;
        this.noteSize = this.theScore.optionsCanvas.noteSize;
        this.durationIndicatorSize = this.theScore.optionsCanvas.durationIndicatorSize;
        this.drawFromTotalDeltaTime = 0;
        this.editNoteDuration = this.ticksPerCrotchet;
        this.insertMode = 0;
        this.insertDT = 0;
        this.shift = false;
        this.np = new NotePlayer();
        this.numSelectedNotes = 0;
        this.startMultiSelectIndex = 0;
        this.selectedNoteColour = 65280;
        this.unselectedNoteColour = 0;
        this.highlightedNoteColour = 255;
    }

    public void gotoStartOfBar() {
        this.drawFromTotalDeltaTime -= this.drawFromBarTicks;
        while (this.drawFromBarTicks > 0) {
            --this.highlightedNote;
            this.drawFromBarTicks -= this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getDeltaTime();
        }
        this.theScore.tempoTrack.setDeltaTime(this.drawFromTotalDeltaTime);
        this.drawFromBeatTicks = 0;
        this.repaint();
    }

    public void changeTrack(int trackNum) {
        System.out.println("in change track...");
        if (this.playing) {
            System.out.println("playing == true");
            this.pauseThread = 1;
            System.out.println("waiting for pauseThread to be 2");
            while (this.pauseThread != 2) {
            }
            System.out.println("pausethread is 2...");
        }
        this.currentTrack = trackNum;
        this.drawFromTotalDeltaTime = 0;
        this.highlightedNoteDistance = 0;
        this.highlightedNote = 0;
        this.drawFromNote = 0;
        int currentDt = 0;
        int gotoHighlightedNoteTotalDeltaTime = this.highlightedNoteTotalDeltaTime;
        this.highlightedNoteTotalDeltaTime = 0;
        this.highlightedNote = 0;
        while (currentDt < gotoHighlightedNoteTotalDeltaTime) {
            this.updateHighlightedNoteRight(this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getDeltaTime());
            currentDt += this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getDeltaTime();
            ++this.highlightedNote;
            if (this.highlightedNote != this.theScore.getTrack(this.currentTrack).getSize()) continue;
            System.out.println("in sdc.changeTrack, highlightedNote==track.size so adding more rests...");
            for (int i = 0; i < 50; ++i) {
                this.theScore.getTrack(this.currentTrack).addNote(new Note(0, 70, useful.theScore.getTicksPerCrotchet() / 2, useful.theScore.getTicksPerCrotchet() / 2));
            }
        }
        this.lastIterationHighlightedNote = this.highlightedNote;
        this.updateDrawFromNoteRight();
        this.clef = this.theScore.getTrack(this.currentTrack).getClef();
        this.repaint();
        this.np.instrument = this.theScore.getTrack(this.currentTrack).getInstrument();
        this.np.threadTask = 1;
        Thread npSetInstrumentThread = new Thread(this.np);
        npSetInstrumentThread.start();
        this.numSelectedNotes = this.theScore.getTrack(this.currentTrack).getNumSelectedNotes();
        this.startMultiSelectIndex = this.highlightedNote;
        if (this.pauseThread == 2) {
            this.pauseThread = 0;
        }
    }

    public void gotoStart() {
        this.drawFromTotalDeltaTime = 0;
        this.highlightedNoteTotalDeltaTime = 0;
        this.drawFromBarTicks = 0;
        this.drawFromBeatTicks = 0;
        this.theScore.tempoTrack.setDeltaTime(0);
        this.drawFromBeatTicks = 0;
        this.highlightedNote = 0;
        this.drawFromNote = 0;
        this.incrementFrom = 0;
        this.getCurrentTimeSig();
        this.clef = this.theScore.getTrack(this.currentTrack).getClef();
        this.np.channel = this.theScore.getTrack(this.currentTrack).getChannel();
        this.np.instrument = this.theScore.getTrack(this.currentTrack).getInstrument();
        this.np.threadTask = 1;
        Thread npSetInstrumentThread = new Thread(this.np);
        npSetInstrumentThread.start();
        this.numSelectedNotes = this.theScore.getTrack(this.currentTrack).getNumSelectedNotes();
        this.startMultiSelectIndex = 0;
    }

    public void paint(Graphics g) {
        System.out.println("at start of paint...");
        this.theScore.tempoTrack.setDeltaTime(this.drawFromTotalDeltaTime);
        this.getCurrentTimeSig();
        this.theScore.getTrack(this.currentTrack).clearTiedNotes();
        this.currentNote = this.drawFromNote;
        g.setColor(this.theScore.optionsCanvas.colourBackground[0], this.theScore.optionsCanvas.colourBackground[1], this.theScore.optionsCanvas.colourBackground[2]);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(this.theScore.optionsCanvas.colourStave[0], this.theScore.optionsCanvas.colourStave[1], this.theScore.optionsCanvas.colourStave[2]);
        g.setFont(this.mFont);
        int y = this.height / 100 * 30;
        y += this.noteSize * 2;
        this.i = 0;
        while (this.i <= 4) {
            g.drawLine(0, y, this.width, y);
            y += this.noteSize;
            ++this.i;
        }
        y += this.noteSize;
        this.getCurrentTimeSig();
        this.inKey = this.theScore.keySigHandler.getInKey();
        int currentXPosition = 15;
        int[] beamedNotesBeams = new int[16];
        int[] beamedNotesXPos = new int[16];
        int[] beamedNotesYPos = new int[16];
        int beamedNotesPitches = 0;
        boolean beamedNotes = false;
        int currentBeatTicks = this.theScore.tempoTrack.getBeatTicks();
        int i = 0;
        int[] scaleLines = new int[]{0, 0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6};
        int maxY = 0;
        int minY = 1000;
        int currentBarTicks = this.theScore.tempoTrack.getBarTicks();
        y = this.height / 100 * 30;
        y += this.noteSize * 2;
        this.getCurrentTimeSig();
        this.drawFromTicksPerBar = this.ticksPerBar;
        this.drawFromTicksPerBeat = this.ticksPerBeat;
        this.keySig = this.theScore.tempoTrack.getCurrentKeySig();
        if (this.drawFromTotalDeltaTime == 0) {
            currentXPosition = this.clef == 0 ? this.drawTrebleClef(g, currentXPosition, y) : (this.clef == 1 ? this.drawBassClef(g, currentXPosition, y) : (this.clef == 2 ? this.drawCClef(g, currentXPosition, y) : this.drawCClef(g, currentXPosition, y - this.noteSize)));
            boolean temp = this.theScore.tempoTrack.hasKeySigChanged();
            currentXPosition = this.drawKeySig(g, currentXPosition, y + this.noteSize * 2);
            temp = this.theScore.tempoTrack.hasTimeSigChanged();
            this.drawTimeSig(g, currentXPosition, y);
            currentXPosition += this.noteSize;
        }
        while (this.currentNote < this.theScore.getTrack(this.currentTrack).getSize() && currentXPosition < this.width + this.noteSize * 2) {
            beamedNotesBeams = new int[16];
            beamedNotesXPos = new int[16];
            beamedNotesYPos = new int[16];
            beamedNotesPitches = 0;
            beamedNotes = false;
            currentBeatTicks %= this.ticksPerBeat;
            i = 0;
            maxY = 0;
            minY = 1000;
            if (currentBarTicks >= this.ticksPerBar || this.currentNote == this.drawFromNote && currentBarTicks == 0) {
                System.out.println("currentBar ticks = " + currentBarTicks + " and currentNote = " + this.currentNote + " ... going to draw key sig and time sig");
                y = this.height / 100 * 30;
                g.drawLine(currentXPosition, y += this.noteSize * 2, currentXPosition, y + this.noteSize * 4);
                currentBarTicks = 0;
                if (this.currentNote != this.drawFromNote) {
                    this.theScore.tempoTrack.incrementDeltaTime(this.ticksPerBar - this.incrementFrom);
                    this.incrementFrom = 0;
                }
                if (this.theScore.tempoTrack.hasKeySigChanged()) {
                    g.drawLine((int)((double)currentXPosition + (double)this.noteSize * 0.25), y, (int)((double)currentXPosition + (double)this.noteSize * 0.25), y + this.noteSize * 4);
                    this.keySig = this.theScore.tempoTrack.getCurrentKeySig();
                    currentXPosition = this.drawKeySig(g, currentXPosition + this.noteSize * 2, y + this.noteSize * 2);
                }
                this.inKey = this.theScore.keySigHandler.getInKey();
                if (this.theScore.tempoTrack.hasTimeSigChanged()) {
                    this.getCurrentTimeSig();
                    this.drawTimeSig(g, (currentXPosition += (int)((double)this.noteSize * 0.5)) + this.noteSize, y);
                    currentXPosition += this.noteSize * 2;
                }
                currentXPosition += this.noteSize;
            }
            while (currentBeatTicks < this.ticksPerBeat && this.currentNote < this.theScore.getTrack(this.currentTrack).getSize()) {
                Note n = this.theScore.getTrack(this.currentTrack).getNote(this.currentNote);
                if (n.selected) {
                    g.setColor(this.theScore.optionsCanvas.colourSelectedNotes[0], this.theScore.optionsCanvas.colourSelectedNotes[1], this.theScore.optionsCanvas.colourSelectedNotes[2]);
                } else {
                    g.setColor(this.theScore.optionsCanvas.colourNotes[0], this.theScore.optionsCanvas.colourNotes[1], this.theScore.optionsCanvas.colourNotes[2]);
                }
                if (this.currentNote == this.highlightedNote) {
                    System.out.println("currentNote = highlightedNote...");
                    this.highlightedNoteTicksPerBar = this.ticksPerBar;
                    this.highlightedNoteTicksPerBeat = this.ticksPerBeat;
                    this.highlightedNoteBarTicks = currentBarTicks;
                    this.highlightedNoteBeatTicks = currentBeatTicks;
                    this.highlightedNoteName = null;
                    g.setColor(this.theScore.optionsCanvas.colourHighlightedNote[0], this.theScore.optionsCanvas.colourHighlightedNote[1], this.theScore.optionsCanvas.colourHighlightedNote[2]);
                    if (n.getPitch() > 0) {
                        this.highlightedNoteName = this.keySig.getSf() >= 0 ? this.sharpNoteNames[n.getPitch() % 12] : this.flatNoteNames[n.getPitch() % 12];
                        this.highlightedNoteName = this.highlightedNoteName + n.getPitch() / 12;
                    } else {
                        this.highlightedNoteName = "R";
                    }
                    System.out.println("just set hln = " + this.highlightedNoteName);
                } else if (n.selected) {
                    g.setColor(this.theScore.optionsCanvas.colourSelectedNotes[0], this.theScore.optionsCanvas.colourSelectedNotes[1], this.theScore.optionsCanvas.colourSelectedNotes[2]);
                } else {
                    g.setColor(this.theScore.optionsCanvas.colourNotes[0], this.theScore.optionsCanvas.colourNotes[1], this.theScore.optionsCanvas.colourNotes[2]);
                }
                int duration = n.getDuration();
                y = this.height / 100 * 30;
                if (n.getPitch() == 0) {
                    if (duration < this.ticksPerCrotchet && this.ticksPerCrotchet % duration != 0) {
                        this.drawDot(g, currentXPosition, y + (int)((double)this.noteSize * 3.5));
                        duration = duration / 3 * 2;
                    } else if (duration > this.ticksPerCrotchet && this.ticksPerCrotchet * 4 % duration != 0) {
                        this.drawDot(g, currentXPosition, y + (int)(3.5 * (double)this.noteSize));
                        duration = duration / 3 * 2;
                    }
                    if (duration == this.ticksPerCrotchet * 4 || duration == this.ticksPerBar) {
                        g.fillRect(currentXPosition, y += 3 * this.noteSize, (int)this.noteSize, (int)((double)this.noteSize * 0.5));
                    } else if (duration == this.ticksPerCrotchet) {
                        g.drawLine(currentXPosition, y += (int)((double)this.noteSize * 2.5), currentXPosition + this.noteSize, y + (int)(0.5 * (double)this.noteSize));
                        g.drawLine(currentXPosition + this.noteSize, y + (int)(0.5 * (double)this.noteSize), currentXPosition, y + this.noteSize);
                        g.drawLine(currentXPosition, y + this.noteSize, currentXPosition + this.noteSize, y + 2 * this.noteSize);
                        g.drawArc(currentXPosition, y + 2 * this.noteSize, this.noteSize * 2, (int)this.noteSize, 90, 120);
                    } else if (duration == this.ticksPerCrotchet / 2) {
                        g.drawLine(currentXPosition + this.noteSize, y += (int)((double)this.noteSize * 3.5), currentXPosition, y + (int)((double)this.noteSize * 1.5));
                        g.drawArc(currentXPosition, y - (int)(0.5 * (double)this.noteSize), (int)this.noteSize, (int)this.noteSize, 0, -180);
                    } else if (duration == this.ticksPerCrotchet / 4) {
                        g.drawLine(currentXPosition + this.noteSize, y += (int)((double)this.noteSize * 3.5), currentXPosition, y + this.noteSize * 2);
                        g.drawArc(currentXPosition, y - (int)(0.5 * (double)this.noteSize), (int)this.noteSize, (int)this.noteSize, 0, -180);
                        g.drawArc(currentXPosition - (int)(0.25 * (double)this.noteSize), y, (int)this.noteSize, (int)this.noteSize, 0, -180);
                    } else if (duration == this.ticksPerCrotchet / 8) {
                        g.drawLine(currentXPosition + this.noteSize, y += this.noteSize * 3, currentXPosition, y + (int)((double)this.noteSize * 2.5));
                        g.drawArc(currentXPosition, y - (int)(0.5 * (double)this.noteSize), (int)this.noteSize, (int)this.noteSize, 0, -180);
                        g.drawArc(currentXPosition - (int)(0.2 * (double)this.noteSize), y, (int)this.noteSize, (int)this.noteSize, 0, -180);
                        g.drawArc(currentXPosition - (int)(0.4 * (double)this.noteSize), y + (int)(0.5 * (double)this.noteSize), (int)this.noteSize, (int)this.noteSize, 0, -180);
                    } else if (duration == this.ticksPerCrotchet / 16) {
                        g.drawLine(currentXPosition + this.noteSize, y += this.noteSize * 3, currentXPosition, y + (int)((double)this.noteSize * 2.5));
                        g.drawArc(currentXPosition, y - (int)(0.5 * (double)this.noteSize), (int)this.noteSize, (int)this.noteSize, 0, -180);
                        g.drawArc(currentXPosition - (int)(0.2 * (double)this.noteSize), y, (int)this.noteSize, (int)this.noteSize, 0, -180);
                        g.drawArc(currentXPosition - (int)(0.4 * (double)this.noteSize), y + (int)(0.5 * (double)this.noteSize), (int)this.noteSize, (int)this.noteSize, 0, -180);
                        g.drawArc(currentXPosition - (int)(0.6 * (double)this.noteSize), y + this.noteSize, (int)this.noteSize, (int)this.noteSize, 0, -180);
                    } else if (duration == this.ticksPerCrotchet * 2) {
                        g.fillRect(currentXPosition, y += (int)(3.5 * (double)this.noteSize), (int)this.noteSize, (int)((double)this.noteSize * 0.5));
                    }
                } else {
                    y = (int)((double)y + (double)this.noteSize * 24.5);
                    int calcPitch = n.getPitch();
                    while (calcPitch >= 12) {
                        calcPitch -= 12;
                        y -= (int)((double)this.noteSize * 3.5);
                    }
                    y -= (int)((double)(scaleLines[calcPitch] * this.noteSize) * 0.5);
                    y = (int)((double)y - (double)this.noteSize * 0.5);
                    if (this.clef != 0) {
                        y = this.clef == 1 ? (y -= this.noteSize * 6) : (this.clef == 2 ? (y -= this.noteSize * 3) : (y -= this.noteSize * 4));
                    }
                    if (!this.inKey.contains(new Integer(n.getPitch()))) {
                        if (this.theScore.tempoTrack.getCurrentKeySig().getSf() >= 0) {
                            if ((this.theScore.tempoTrack.getCurrentKeySig().getSf() == 7 || this.theScore.tempoTrack.getCurrentKeySig().getSf() == 6 && n.getPitch() % 12 != 0 || n.getPitch() % 12 != 5 && n.getPitch() % 12 != 0) && this.theScore.keySigHandler.sharps.contains(new Integer(calcPitch))) {
                                if (this.theScore.tempoTrack.getCurrentKeySig().getSf() == 7 && (n.getPitch() % 12 == 5 || n.getPitch() % 12 == 0) || this.theScore.tempoTrack.getCurrentKeySig().getSf() == 6 && n.getPitch() % 12 == 5) {
                                    y += (int)((double)this.noteSize * 0.5);
                                }
                                this.drawSharp(g, currentXPosition, y);
                                this.inKey.addElement(new Integer(n.getPitch()));
                            } else if (this.inKey.contains(new Integer(n.getPitch() + 1))) {
                                this.drawNatural(g, currentXPosition, y);
                                this.inKey.removeElement(new Integer(n.getPitch() + 1));
                            }
                        } else if ((this.theScore.tempoTrack.getCurrentKeySig().getSf() == -7 || this.theScore.tempoTrack.getCurrentKeySig().getSf() == -6 && n.getPitch() % 12 != 4 || n.getPitch() % 12 != 11 && n.getPitch() % 12 != 4) && this.theScore.keySigHandler.flats.contains(new Integer(calcPitch))) {
                            this.drawFlat(g, currentXPosition, y -= (int)((double)this.noteSize * 0.5));
                            this.inKey.addElement(new Integer(n.getPitch()));
                        } else if (this.inKey.contains(new Integer(n.getPitch() - 1))) {
                            this.drawNatural(g, currentXPosition, y);
                            this.inKey.removeElement(new Integer(n.getPitch() - 1));
                        }
                    } else if (this.theScore.tempoTrack.getCurrentKeySig().getSf() < 0 && this.theScore.keySigHandler.flats.contains(new Integer(calcPitch))) {
                        y -= (int)((double)this.noteSize * 0.5);
                    } else if (this.theScore.tempoTrack.getCurrentKeySig().getSf() == 7 && (n.getPitch() % 12 == 5 || n.getPitch() % 12 == 0) || this.theScore.tempoTrack.getCurrentKeySig().getSf() == 6 && n.getPitch() % 12 == 5) {
                        y += (int)((double)this.noteSize * 0.5);
                    }
                    if (duration < this.ticksPerCrotchet) {
                        if (this.ticksPerCrotchet % duration != 0) {
                            this.drawDot(g, currentXPosition, y);
                            duration = duration / 3 * 2;
                        }
                        beamedNotesXPos[i] = currentXPosition;
                        beamedNotesYPos[i] = y;
                        if (y < minY) {
                            minY = y;
                        }
                        if (y > maxY) {
                            maxY = y;
                        }
                        beamedNotesPitches = this.clef == 0 ? (beamedNotesPitches += 71 - n.getPitch()) : (this.clef == 1 ? (beamedNotesPitches += 50 - n.getPitch()) : (this.clef == 2 ? (beamedNotesPitches += 57 - n.getPitch()) : (beamedNotesPitches += 60 - n.getPitch())));
                        g.fillArc(currentXPosition, y, (int)this.noteSize, (int)this.noteSize, 0, 360);
                        this.drawLedgerLines(g, currentXPosition, y);
                        if (duration == this.ticksPerCrotchet / 2) {
                            beamedNotesBeams[i] = 1;
                        } else if (duration == this.ticksPerCrotchet / 4) {
                            beamedNotesBeams[i] = 2;
                        } else if (duration == this.ticksPerCrotchet / 8) {
                            beamedNotesBeams[i] = 3;
                        } else if (duration == this.ticksPerCrotchet / 16) {
                            beamedNotesBeams[i] = 4;
                        }
                        ++i;
                    } else {
                        if (this.ticksPerCrotchet * 4 % duration != 0) {
                            this.drawDot(g, currentXPosition, y);
                            duration = duration / 3 * 2;
                        }
                        if (duration == this.ticksPerCrotchet) {
                            g.fillArc(currentXPosition, y, (int)this.noteSize, (int)this.noteSize, 0, 360);
                            this.drawStem(g, currentXPosition, y, n.getPitch());
                        } else if (duration == this.ticksPerCrotchet * 2) {
                            g.drawArc(currentXPosition, y, (int)this.noteSize, (int)this.noteSize, 0, 360);
                            this.drawStem(g, currentXPosition, y, n.getPitch());
                        } else if (duration == this.ticksPerCrotchet * 4) {
                            g.drawArc(currentXPosition, y, (int)this.noteSize, (int)this.noteSize, 0, 360);
                            this.drawLedgerLines(g, currentXPosition, y);
                        }
                    }
                    if (n.getTieBackwards()) {
                        TiedNote tempTiedNote = this.theScore.getTrack(this.currentTrack).findTiedNote(n.getPitch());
                        if (this.clef == 0 && n.getPitch() >= 71 || this.clef == 1 && n.getPitch() >= 50 || this.clef == 2 && n.getPitch() >= 57 || this.clef == 3 && n.getPitch() >= 60) {
                            g.drawArc(tempTiedNote.getX(), y - (int)(0.5 * (double)this.noteSize), (int)((double)currentXPosition + 0.5 * (double)this.noteSize) - tempTiedNote.getX(), (int)this.noteSize, 180, -180);
                        } else {
                            g.drawArc(tempTiedNote.getX(), y + (int)(0.5 * (double)this.noteSize), (int)((double)currentXPosition + 0.5 * (double)this.noteSize) - tempTiedNote.getX(), (int)this.noteSize, 180, 180);
                        }
                    }
                    if (n.getTieForwards()) {
                        TiedNote tn = new TiedNote(currentXPosition + (int)(0.5 * (double)this.noteSize), y, n.getPitch());
                        this.theScore.getTrack(this.currentTrack).addTiedNote(tn);
                    }
                }
                int smallNote = this.ticksPerCrotchet / 32;
                int deltaTime = n.getDeltaTime();
                if (deltaTime > 0) {
                    currentXPosition += (int)((double)this.noteSize * 1.25);
                }
                while (smallNote < deltaTime) {
                    currentXPosition += this.noteSize / 4;
                    smallNote *= 2;
                }
                currentBeatTicks += n.getDeltaTime();
                currentBarTicks += n.getDeltaTime();
                ++this.currentNote;
                if (n.getPitch() != 0 && (n.getDuration() < this.ticksPerCrotchet || n.getDeltaTime() <= 0)) continue;
                break;
            }
            int c = 0;
            if (--i >= 1) {
                int j;
                boolean changed;
                int minTails;
                int lineY = 0;
                if (beamedNotesPitches >= 0) {
                    lineY = minY - 2 * this.noteSize - 2;
                    if (beamedNotesXPos[0] == beamedNotesXPos[i]) {
                        minTails = 100;
                        for (c = 0; c <= i; ++c) {
                            if (beamedNotesBeams[c] >= minTails) continue;
                            minTails = beamedNotesBeams[c];
                        }
                        this.drawSingleTail(g, beamedNotesXPos[0], minY, 1, minTails);
                        g.drawLine(beamedNotesXPos[0] + this.noteSize, maxY + (int)(0.5 * (double)this.noteSize), beamedNotesXPos[0] + this.noteSize, lineY);
                    } else {
                        for (c = 0; c <= i; ++c) {
                            g.drawLine(beamedNotesXPos[c] + this.noteSize, beamedNotesYPos[c] + (int)(0.5 * (double)this.noteSize), beamedNotesXPos[c] + this.noteSize, lineY);
                        }
                        changed = true;
                        while (changed) {
                            c = 0;
                            changed = false;
                            while (c < i) {
                                while (beamedNotesBeams[c] == 0 && c <= i) {
                                    ++c;
                                }
                                if (c > i) continue;
                                changed = true;
                                j = c;
                                while (beamedNotesBeams[c] > 0 && c <= i) {
                                    int n = c++;
                                    beamedNotesBeams[n] = beamedNotesBeams[n] - 1;
                                }
                                if (--c - j == 0) {
                                    if (c == i) {
                                        g.drawLine(beamedNotesXPos[c] + this.noteSize, lineY, beamedNotesXPos[c] + (int)(0.5 * (double)this.noteSize), lineY);
                                        continue;
                                    }
                                    g.drawLine(beamedNotesXPos[c] + this.noteSize, lineY, beamedNotesXPos[c] + (int)((double)this.noteSize * 1.5), lineY);
                                    continue;
                                }
                                if (beamedNotesXPos[j] == beamedNotesXPos[i]) {
                                    g.drawLine(beamedNotesXPos[c] + this.noteSize, lineY, beamedNotesXPos[c] + (int)(0.5 * (double)this.noteSize), lineY);
                                    continue;
                                }
                                g.drawLine(beamedNotesXPos[j] + this.noteSize, lineY, beamedNotesXPos[c] + this.noteSize, lineY);
                            }
                            lineY += (int)((double)this.noteSize * 0.5);
                        }
                    }
                } else {
                    lineY = maxY + 3 * this.noteSize + 2;
                    if (beamedNotesXPos[0] == beamedNotesXPos[i]) {
                        minTails = 100;
                        for (c = 0; c <= i; ++c) {
                            if (beamedNotesBeams[c] >= minTails) continue;
                            minTails = beamedNotesBeams[c];
                        }
                        this.drawSingleTail(g, beamedNotesXPos[0], maxY, -1, minTails);
                        g.drawLine(beamedNotesXPos[0], minY + (int)(0.5 * (double)this.noteSize), beamedNotesXPos[0], lineY);
                    } else {
                        for (c = 0; c <= i; ++c) {
                            g.drawLine(beamedNotesXPos[c], beamedNotesYPos[c] + (int)(0.5 * (double)this.noteSize), beamedNotesXPos[c], lineY);
                        }
                        changed = true;
                        while (changed) {
                            c = 0;
                            changed = false;
                            while (c < i) {
                                while (beamedNotesBeams[c] == 0 && c <= i) {
                                    ++c;
                                }
                                if (c > i) continue;
                                changed = true;
                                j = c;
                                while (beamedNotesBeams[c] > 0 && c <= i) {
                                    int n = c++;
                                    beamedNotesBeams[n] = beamedNotesBeams[n] - 1;
                                }
                                if (--c - j == 0) {
                                    if (c == i) {
                                        g.drawLine(beamedNotesXPos[c], lineY, beamedNotesXPos[c] - (int)(0.5 * (double)this.noteSize), lineY);
                                        continue;
                                    }
                                    g.drawLine(beamedNotesXPos[c], lineY, beamedNotesXPos[c] + (int)((double)this.noteSize * 0.5), lineY);
                                    continue;
                                }
                                if (beamedNotesXPos[j] == beamedNotesXPos[i]) {
                                    g.drawLine(beamedNotesXPos[c], lineY, beamedNotesXPos[c] - (int)(0.5 * (double)this.noteSize), lineY);
                                    continue;
                                }
                                g.drawLine(beamedNotesXPos[j], lineY, beamedNotesXPos[c], lineY);
                            }
                            lineY -= (int)((double)this.noteSize * 0.5);
                        }
                    }
                }
            } else if (i == 0) {
                this.drawSingleTail(g, beamedNotesXPos[0], beamedNotesYPos[0], beamedNotesPitches, beamedNotesBeams[0]);
            }
            g.setColor(this.theScore.optionsCanvas.colourNotes[0], this.theScore.optionsCanvas.colourNotes[1], this.theScore.optionsCanvas.colourNotes[2]);
            int durationIndicatorX = this.width - (15 + this.durationIndicatorSize);
            int durationIndicatorY = this.durationIndicatorSize * 2 + 2;
            if (this.editNoteDuration < this.ticksPerCrotchet) {
                int durationIndicatorBeams = 0;
                durationIndicatorX -= this.durationIndicatorSize;
                if (this.editNoteDuration == this.ticksPerCrotchet / 2) {
                    durationIndicatorBeams = 1;
                } else if (this.editNoteDuration == this.ticksPerCrotchet / 4) {
                    durationIndicatorBeams = 2;
                } else if (this.editNoteDuration == this.ticksPerCrotchet / 8) {
                    durationIndicatorBeams = 3;
                } else if (this.editNoteDuration == this.ticksPerCrotchet / 16) {
                    durationIndicatorBeams = 4;
                }
                int beamCount = 0;
                g.drawLine(durationIndicatorX + this.durationIndicatorSize, durationIndicatorY + (int)(0.5 * (double)this.durationIndicatorSize), durationIndicatorX + this.durationIndicatorSize, durationIndicatorY - this.durationIndicatorSize * 2);
                for (beamCount = 1; beamCount <= durationIndicatorBeams; ++beamCount) {
                    g.drawLine(durationIndicatorX + this.durationIndicatorSize, durationIndicatorY - (int)((double)(this.durationIndicatorSize * 2) - 0.5 * (double)(beamCount - 1) * (double)this.durationIndicatorSize), durationIndicatorX + (int)((double)this.durationIndicatorSize * 1.5), durationIndicatorY - (int)((double)(this.durationIndicatorSize * 2) - (double)this.durationIndicatorSize * 0.5 * (double)beamCount));
                }
                g.drawLine(durationIndicatorX + (int)((double)this.durationIndicatorSize * 1.5), durationIndicatorY - (int)((double)(this.durationIndicatorSize * 2) - 0.5 * (double)this.durationIndicatorSize), durationIndicatorX + (int)((double)this.durationIndicatorSize * 1.5), durationIndicatorY - (int)((double)(this.durationIndicatorSize * 2) - 0.5 * (double)beamCount * (double)this.durationIndicatorSize));
                g.fillArc(durationIndicatorX, durationIndicatorY, (int)this.durationIndicatorSize, (int)this.durationIndicatorSize, 0, 360);
                continue;
            }
            if (this.editNoteDuration == this.ticksPerCrotchet) {
                g.fillArc(durationIndicatorX, durationIndicatorY, (int)this.durationIndicatorSize, (int)this.durationIndicatorSize, 0, 360);
                g.drawLine(durationIndicatorX + this.durationIndicatorSize, durationIndicatorY + (int)(0.5 * (double)this.durationIndicatorSize), durationIndicatorX + this.durationIndicatorSize, durationIndicatorY - this.durationIndicatorSize * 2);
                continue;
            }
            if (this.editNoteDuration == this.ticksPerCrotchet * 2) {
                g.drawArc(durationIndicatorX, durationIndicatorY, (int)this.durationIndicatorSize, (int)this.durationIndicatorSize, 0, 360);
                g.drawLine(durationIndicatorX + this.durationIndicatorSize, durationIndicatorY + (int)(0.5 * (double)this.durationIndicatorSize), durationIndicatorX + this.durationIndicatorSize, durationIndicatorY - this.durationIndicatorSize * 2);
                continue;
            }
            if (this.editNoteDuration != this.ticksPerCrotchet * 4) continue;
            g.drawArc(durationIndicatorX, durationIndicatorY -= this.durationIndicatorSize, (int)this.durationIndicatorSize, (int)this.durationIndicatorSize, 0, 360);
        }
        this.theScore.tempoTrack.setDeltaTime(this.highlightedNoteTotalDeltaTime);
        this.getCurrentTimeSig();
        g.setColor(this.theScore.optionsCanvas.colourText[0], this.theScore.optionsCanvas.colourText[1], this.theScore.optionsCanvas.colourText[2]);
        g.drawString(String.valueOf(this.theScore.tempoTrack.getBarNumber()) + ":" + ((this.theScore.tempoTrack.getBarTicks() + this.insertDT) / this.ticksPerBeat + 1) + "(" + (this.theScore.tempoTrack.getBeatTicks() + this.insertDT) % this.ticksPerBeat + ") -- " + this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getDuration() + " " + this.highlightedNoteName + "(" + this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getDeltaTime() + ") -- (" + String.valueOf(this.numSelectedNotes) + ")", 0, 0, 20);
        if (this.shift) {
            g.drawString("SHIFT", 0, 15, 20);
        }
        if (this.singleSelect) {
            g.drawString("SINGLE", 45, 15, 20);
        } else if (this.multiSelect) {
            g.drawString("MULTI", 45, 15, 20);
        }
        g.drawString(String.valueOf(this.insertMode), this.width - 2, 0, 24);
        g.drawString(String.valueOf(this.theScore.getTrack(this.currentTrack).getInstrument() + 1) + " - " + this.theScore.instrumentNames[this.theScore.getTrack(this.currentTrack).getInstrument()], this.width / 2, this.height, 33);
        g.drawString("Ch " + String.valueOf(this.theScore.getTrack(this.currentTrack).getChannel() + 1) + ": Track " + String.valueOf(this.currentTrack + 1) + " - " + this.theScore.getTrack(this.currentTrack).getTrackName(), this.width / 2, this.height - 15, 33);
        g.drawString("1=" + this.np.error, this.width, this.height - 30, 40);
        g.drawString("mt = " + this.mediaTime, this.width / 2, this.height - 30, 33);
    }

    public int drawKeySig(Graphics g, int currentXPosition, int y) {
        byte key = this.keySig.getSf();
        currentXPosition += this.noteSize;
        if (key > 0) {
            int[] drawSharps = new int[7];
            if (this.clef == 0) {
                drawSharps[0] = 5;
                drawSharps[1] = 2;
                drawSharps[2] = 6;
                drawSharps[3] = 3;
                drawSharps[4] = 0;
                drawSharps[5] = 4;
                drawSharps[6] = 1;
            } else if (this.clef == 1) {
                drawSharps[0] = 3;
                drawSharps[1] = 0;
                drawSharps[2] = 4;
                drawSharps[3] = 1;
                drawSharps[4] = -2;
                drawSharps[5] = 2;
                drawSharps[6] = -1;
            } else if (this.clef == 2) {
                drawSharps[0] = 4;
                drawSharps[1] = 1;
                drawSharps[2] = 5;
                drawSharps[3] = 2;
                drawSharps[4] = -1;
                drawSharps[5] = 3;
                drawSharps[6] = 0;
            } else {
                drawSharps[0] = -1;
                drawSharps[1] = 3;
                drawSharps[2] = 0;
                drawSharps[3] = 4;
                drawSharps[4] = 1;
                drawSharps[5] = 5;
                drawSharps[6] = 2;
            }
            for (int i = 0; i < Math.abs(key); ++i) {
                this.drawSharp(g, currentXPosition, y - (int)((double)this.noteSize * 0.5 * (double)drawSharps[i]));
                currentXPosition += this.noteSize;
            }
        } else {
            int[] drawFlats = new int[7];
            if (this.clef == 0) {
                drawFlats[0] = 1;
                drawFlats[1] = 4;
                drawFlats[2] = 0;
                drawFlats[3] = 3;
                drawFlats[4] = -1;
                drawFlats[5] = 2;
                drawFlats[6] = -2;
            } else if (this.clef == 1) {
                drawFlats[0] = -1;
                drawFlats[1] = 2;
                drawFlats[2] = -2;
                drawFlats[3] = 1;
                drawFlats[4] = -3;
                drawFlats[5] = 0;
                drawFlats[6] = -4;
            } else if (this.clef == 2) {
                drawFlats[0] = 0;
                drawFlats[1] = 3;
                drawFlats[2] = -1;
                drawFlats[3] = 2;
                drawFlats[4] = -2;
                drawFlats[5] = 1;
                drawFlats[6] = -3;
            } else {
                drawFlats[0] = 2;
                drawFlats[1] = 5;
                drawFlats[2] = 1;
                drawFlats[3] = 4;
                drawFlats[4] = 0;
                drawFlats[5] = 3;
                drawFlats[6] = -1;
            }
            for (int i = 0; i < Math.abs(key); ++i) {
                this.drawFlat(g, currentXPosition, y - (int)((double)this.noteSize * 0.5 * (double)drawFlats[i]));
                currentXPosition += this.noteSize;
            }
        }
        return currentXPosition += this.noteSize;
    }

    public void drawSharp(Graphics g, int x, int y) {
        if (this.currentNote != this.highlightedNote && !this.theScore.getTrack((int)this.currentTrack).getNote((int)this.currentNote).selected) {
            g.setColor(this.theScore.optionsCanvas.colourSharps[0], this.theScore.optionsCanvas.colourSharps[1], this.theScore.optionsCanvas.colourSharps[2]);
        }
        g.drawLine(--x - (int)((double)this.noteSize * 0.8), y - (int)(0.4 * (double)this.noteSize), x - (int)(0.8 * (double)this.noteSize), y + (int)((double)this.noteSize * 1.8));
        g.drawLine(x - (int)((double)this.noteSize * 0.2), y - (int)(0.8 * (double)this.noteSize), x - (int)(0.2 * (double)this.noteSize), y + (int)((double)this.noteSize * 1.4));
        g.drawLine(x - (int)((double)this.noteSize * 0.9), y + (int)(0.1 * (double)this.noteSize), x - (int)((double)this.noteSize * 0.1), y - (int)(0.2 * (double)this.noteSize));
        g.drawLine(x - (int)((double)this.noteSize * 0.9), y + (int)(1.1 * (double)this.noteSize), x - (int)((double)this.noteSize * 0.1), y + (int)(0.8 * (double)this.noteSize));
        if (this.currentNote != this.highlightedNote && !this.theScore.getTrack((int)this.currentTrack).getNote((int)this.currentNote).selected) {
            g.setColor(this.theScore.optionsCanvas.colourNotes[0], this.theScore.optionsCanvas.colourNotes[1], this.theScore.optionsCanvas.colourNotes[2]);
        }
    }

    public void drawNatural(Graphics g, int x, int y) {
        if (this.currentNote != this.highlightedNote && !this.theScore.getTrack((int)this.currentTrack).getNote((int)this.currentNote).selected) {
            g.setColor(this.theScore.optionsCanvas.colourNaturals[0], this.theScore.optionsCanvas.colourNaturals[1], this.theScore.optionsCanvas.colourNaturals[2]);
        }
        g.drawLine(--x - (int)((double)this.noteSize * 0.8), y - this.noteSize, x - (int)(0.8 * (double)this.noteSize), y + (int)((double)this.noteSize * 1.1));
        g.drawLine(x - (int)((double)this.noteSize * 0.2), y - (int)(0.1 * (double)this.noteSize), x - (int)(0.2 * (double)this.noteSize), y + (int)((double)this.noteSize * 1.8));
        g.drawLine(x - (int)((double)this.noteSize * 0.8), y + (int)(0.1 * (double)this.noteSize), x - (int)((double)this.noteSize * 0.2), y - (int)(0.2 * (double)this.noteSize));
        g.drawLine(x - (int)((double)this.noteSize * 0.8), y + (int)(1.1 * (double)this.noteSize), x - (int)((double)this.noteSize * 0.2), y + (int)(0.8 * (double)this.noteSize));
        if (this.currentNote != this.highlightedNote && !this.theScore.getTrack((int)this.currentTrack).getNote((int)this.currentNote).selected) {
            g.setColor(this.theScore.optionsCanvas.colourNotes[0], this.theScore.optionsCanvas.colourNotes[1], this.theScore.optionsCanvas.colourNotes[2]);
        }
    }

    public void drawFlat(Graphics g, int x, int y) {
        if (this.currentNote != this.highlightedNote && !this.theScore.getTrack((int)this.currentTrack).getNote((int)this.currentNote).selected) {
            g.setColor(this.theScore.optionsCanvas.colourFlats[0], this.theScore.optionsCanvas.colourFlats[1], this.theScore.optionsCanvas.colourFlats[2]);
        }
        g.drawLine(--x - (int)(0.6 * (double)this.noteSize), y - this.noteSize, x - (int)(0.6 * (double)this.noteSize), y + this.noteSize);
        g.drawArc(x - (int)((double)this.noteSize * 1.2), y, (int)this.noteSize, (int)this.noteSize, 90, -180);
        if (this.currentNote != this.highlightedNote && !this.theScore.getTrack((int)this.currentTrack).getNote((int)this.currentNote).selected) {
            g.setColor(this.theScore.optionsCanvas.colourNotes[0], this.theScore.optionsCanvas.colourNotes[1], this.theScore.optionsCanvas.colourNotes[2]);
        }
    }

    public void drawStem(Graphics g, int x, int y, int pitch) {
        if (this.clef == 0 && pitch >= 71 || this.clef == 1 && pitch >= 50 || this.clef == 2 && pitch >= 57 || this.clef == 3 && pitch >= 60) {
            g.drawLine(x, y + (int)(0.5 * (double)this.noteSize), x, y + this.noteSize * 3);
        } else {
            g.drawLine(x + this.noteSize, y + (int)(0.5 * (double)this.noteSize), x + this.noteSize, y - this.noteSize * 2);
        }
        this.drawLedgerLines(g, x, y);
    }

    public void drawSingleTail(Graphics g, int x, int y, int pitch, int beams) {
        if (pitch < 0) {
            int i;
            g.drawLine(x, y + (int)(0.5 * (double)this.noteSize), x, y + this.noteSize * 3);
            for (i = 1; i <= beams; ++i) {
                g.drawLine(x, y + (int)((double)(this.noteSize * 3) - 0.5 * (double)(i - 1) * (double)this.noteSize), x + (int)((double)this.noteSize * 0.5), y + (int)((double)(this.noteSize * 3) - (double)this.noteSize * 0.5 * (double)i));
            }
            g.drawLine(x + (int)((double)this.noteSize * 0.5), y + (int)((double)(this.noteSize * 3) - 0.5 * (double)this.noteSize), x + (int)((double)this.noteSize * 0.5), y + (int)((double)(this.noteSize * 3) - 0.5 * (double)i * (double)this.noteSize));
        } else {
            int i;
            g.drawLine(x + this.noteSize, y + (int)(0.5 * (double)this.noteSize), x + this.noteSize, y - this.noteSize * 2);
            for (i = 1; i <= beams; ++i) {
                g.drawLine(x + this.noteSize, y - (int)((double)(this.noteSize * 2) - 0.5 * (double)(i - 1) * (double)this.noteSize), x + (int)((double)this.noteSize * 1.5), y - (int)((double)(this.noteSize * 2) - (double)this.noteSize * 0.5 * (double)i));
            }
            g.drawLine(x + (int)((double)this.noteSize * 1.5), y - (int)((double)(this.noteSize * 2) - 0.5 * (double)this.noteSize), x + (int)((double)this.noteSize * 1.5), y - (int)((double)(this.noteSize * 2) - 0.5 * (double)i * (double)this.noteSize));
        }
    }

    public void drawLedgerLines(Graphics g, int x, int y) {
        int drawAt;
        g.setColor(this.theScore.optionsCanvas.colourLedgerLines[0], this.theScore.optionsCanvas.colourLedgerLines[1], this.theScore.optionsCanvas.colourLedgerLines[2]);
        int drawFromY = this.height / 100 * 30;
        if (y < drawFromY + this.noteSize) {
            for (drawAt = drawFromY + this.noteSize * 2; drawAt > y; drawAt -= this.noteSize) {
                g.drawLine((int)((double)x - 0.25 * (double)this.noteSize), drawAt, (int)((double)x + 0.25 * (double)this.noteSize) + this.noteSize, drawAt);
            }
        } else if (y > drawFromY + this.noteSize * 6) {
            drawAt = drawFromY + this.noteSize * 6;
            while (drawAt < y) {
                g.drawLine((int)((double)x - 0.25 * (double)this.noteSize), drawAt += this.noteSize, (int)((double)x + 0.25 * (double)this.noteSize) + this.noteSize, drawAt);
            }
        }
        g.setColor(this.theScore.optionsCanvas.colourNotes[0], this.theScore.optionsCanvas.colourNotes[1], this.theScore.optionsCanvas.colourNotes[2]);
    }

    public void drawDot(Graphics g, int x, int y) {
        g.fillArc(x + (int)((double)this.noteSize * 1.2), y + (int)((double)this.noteSize * 0.2), this.noteSize / 2, this.noteSize / 2, 0, 360);
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == this.theScore.optionsCanvas.keyCodes[0]) {
            this.editNoteDuration /= 2;
            if (this.editNoteDuration < this.theScore.getTicksPerCrotchet() / 8) {
                this.editNoteDuration = this.ticksPerCrotchet * 4;
            }
        } else if (keyCode == this.theScore.optionsCanvas.keyCodes[2]) {
            this.editNoteDuration *= 2;
            if (this.editNoteDuration > this.theScore.getTicksPerCrotchet() * 4) {
                this.editNoteDuration = this.ticksPerCrotchet / 8;
            }
        } else if (keyCode == this.theScore.optionsCanvas.keyCodes[6] && !this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getTieForwards() && this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch() > 0) {
            int tempDuration = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getDuration();
            boolean dotted = false;
            if (tempDuration >= this.ticksPerCrotchet) {
                if ((double)tempDuration == (double)this.ticksPerCrotchet * 1.5 || tempDuration == this.ticksPerCrotchet * 3) {
                    dotted = true;
                }
            } else if (this.ticksPerCrotchet % tempDuration != 0) {
                dotted = true;
            }
            this.theScore.tempoTrack.setDeltaTime(this.highlightedNoteTotalDeltaTime);
            this.getCurrentTimeSig();
            int newDuration = 0;
            if (dotted) {
                newDuration = tempDuration / 3 * 2;
                Note nn = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote);
                Note toAdd = new Note(nn.getPitch(), nn.getVelocity(), nn.getDeltaTime(), newDuration);
                this.theScore.getTrack(this.currentTrack).deleteNote(this.highlightedNote, this.theScore.tempoTrack.getBarTicks());
                this.highlightedNote = this.theScore.getTrack(this.currentTrack).insertNote(toAdd, this.highlightedNoteTotalDeltaTime + this.insertDT);
                if (this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote + 1).getPitch() == 0) {
                    this.theScore.getTrack(this.currentTrack).getNotes().removeElementAt(this.highlightedNote + 1);
                }
                this.theScore.getTrack(this.currentTrack).addRests(this.highlightedNote, this.theScore.tempoTrack.getBarTicks() + this.insertDT, this.highlightedNoteTotalDeltaTime + this.insertDT);
            } else {
                newDuration = tempDuration / 2 * 3;
                if (this.ticksPerBar + this.insertDT - (this.theScore.tempoTrack.getBarTicks() + newDuration) >= 0 && newDuration >= this.theScore.getTicksPerCrotchet() / 4) {
                    this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setDuration(newDuration);
                    this.theScore.getTrack(this.currentTrack).removeRestsDuringNote(this.highlightedNote, this.highlightedNoteTotalDeltaTime);
                }
            }
        } else if (keyCode == this.theScore.optionsCanvas.keyCodes[8]) {
            ++this.insertMode;
            this.insertMode %= 3;
            this.highlightedNoteTotalDeltaTime += this.insertDT;
            this.theScore.tempoTrack.setDeltaTime(this.highlightedNoteTotalDeltaTime);
            this.highlightedNoteBarTicks = this.theScore.tempoTrack.getBarTicks();
            this.highlightedNoteBeatTicks = this.theScore.tempoTrack.getBeatTicks();
            this.insertDT = 0;
        } else if (keyCode == this.theScore.optionsCanvas.keyCodes[4] || keyCode == this.theScore.optionsCanvas.keyCodes[16]) {
            this.theScore.tempoTrack.setDeltaTime(this.highlightedNoteTotalDeltaTime);
            this.getCurrentTimeSig();
            this.highlightedNoteBarTicks = this.theScore.tempoTrack.getBarTicks();
            if (this.singleSelect) {
                if (!this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getTieBackwards()) {
                    this.numSelectedNotes = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).toggleSelected(this.numSelectedNotes);
                    this.tiedNoteToggleSelection();
                }
            } else if (this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch() > 0 && !this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getTieForwards()) {
                int du = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getDuration();
                System.out.println("highlightedNoteBarTicks = " + this.highlightedNoteBarTicks + "editNoteDuration = " + this.editNoteDuration + "insertDt = " + this.insertDT + " ticksperbar = " + this.ticksPerBar);
                if (this.editNoteDuration < du) {
                    Note nn = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote);
                    Note toAdd = new Note(nn.getPitch(), nn.getVelocity(), nn.getDeltaTime(), this.editNoteDuration);
                    this.theScore.getTrack(this.currentTrack).deleteNote(this.highlightedNote, this.highlightedNoteBarTicks);
                    this.highlightedNote = this.theScore.getTrack(this.currentTrack).insertNote(toAdd, this.highlightedNoteTotalDeltaTime + this.insertDT);
                    if (this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote + 1).getPitch() == 0) {
                        this.theScore.getTrack(this.currentTrack).getNotes().removeElementAt(this.highlightedNote + 1);
                    }
                    this.theScore.getTrack(this.currentTrack).addRests(this.highlightedNote, this.highlightedNoteBarTicks + this.insertDT, this.highlightedNoteTotalDeltaTime + this.insertDT);
                } else if (this.editNoteDuration > du && this.highlightedNoteBarTicks + this.editNoteDuration + this.insertDT <= this.highlightedNoteTicksPerBar) {
                    System.out.println("making note longer...\n");
                    this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setDuration(this.editNoteDuration);
                    Queue noteQueue = this.theScore.makeNoteDisplayable(this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote));
                    Note tempNote = (Note)noteQueue.dequeue();
                    this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setDuration(tempNote.getDuration());
                    this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setDeltaTime(tempNote.getDeltaTime());
                    this.theScore.getTrack(this.currentTrack).removeRestsDuringNote(this.highlightedNote, this.highlightedNoteTotalDeltaTime + this.insertDT);
                    if (!noteQueue.isEmpty()) {
                        this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setTieForwards(true);
                    }
                    int tempDT = this.highlightedNoteTotalDeltaTime + this.insertDT + tempNote.getDeltaTime();
                    while (!noteQueue.isEmpty()) {
                        tempNote = (Note)noteQueue.dequeue();
                        Note nn = new Note(tempNote.getPitch(), tempNote.getVelocity(), tempNote.getDeltaTime(), tempNote.getDuration());
                        nn.setTieBackwards(tempNote.getTieBackwards());
                        nn.setTieForwards(tempNote.getTieForwards());
                        this.theScore.getTrack(this.currentTrack).insertNote(nn, tempDT);
                        this.theScore.getTrack(this.currentTrack).removeRestsDuringNote(this.highlightedNote, this.highlightedNoteTotalDeltaTime + tempDT);
                        tempDT += tempNote.getDuration();
                    }
                }
            }
        } else if (keyCode == this.theScore.optionsCanvas.keyCodes[3]) {
            this.shift = !this.shift;
        } else if (keyCode == this.theScore.optionsCanvas.keyCodes[5]) {
            if (!this.singleSelect && !this.multiSelect) {
                this.singleSelect = true;
            } else if (this.singleSelect && !this.multiSelect) {
                this.singleSelect = false;
                this.multiSelect = true;
            } else {
                this.multiSelect = false;
            }
        } else if (keyCode == this.theScore.optionsCanvas.keyCodes[12] && this.highlightedNote > 0) {
            System.out.println("\n\nat start of key code LEFT...  dftdt = " + this.drawFromTotalDeltaTime + "ticksPerBar = " + this.ticksPerBar + "drawFromBarTicks = " + this.drawFromBarTicks + " and drawFromBeatTicks = " + this.drawFromBeatTicks);
            if (this.playing) {
                int newCurrentTrack = this.currentTrack - 1;
                if (newCurrentTrack == -1) {
                    newCurrentTrack = this.theScore.tracks.size() - 1;
                }
                this.changeTrack(newCurrentTrack);
            } else {
                int tempDT;
                if (this.insertMode == 0) {
                    int tempnote;
                    this.theScore.tempoTrack.setDeltaTime(this.highlightedNoteTotalDeltaTime);
                    System.out.println("going to scroll back part of a bar...  hntdt = " + this.highlightedNoteTotalDeltaTime);
                    this.getCurrentTimeSig();
                    int deltaTimeToSubtract = 0;
                    this.highlightedNoteBarTicks = this.theScore.tempoTrack.getBarTicks();
                    System.out.println("hnbt = " + this.highlightedNoteBarTicks + "\n\n");
                    if (this.shift) {
                        if (this.highlightedNoteBarTicks > 0) {
                            while (this.highlightedNoteBarTicks - deltaTimeToSubtract > 0) {
                                --this.highlightedNote;
                                deltaTimeToSubtract += this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getDeltaTime();
                                this.updateHighlightedNoteLeft(this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getDeltaTime());
                                if (!this.multiSelect) continue;
                                this.multiSelectLeft();
                            }
                            while (this.highlightedNote > 0 && this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote - 1).getDeltaTime() == 0) {
                                --this.highlightedNote;
                                if (!this.multiSelect) continue;
                                this.multiSelectLeft();
                            }
                        } else {
                            int tempdt = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote - 1).getDeltaTime();
                            this.theScore.tempoTrack.setDeltaTime(this.highlightedNoteTotalDeltaTime - tempdt);
                            this.getCurrentTimeSig();
                            while (this.ticksPerBar - deltaTimeToSubtract > 0) {
                                --this.highlightedNote;
                                deltaTimeToSubtract += this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getDeltaTime();
                                this.updateHighlightedNoteLeft(this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getDeltaTime());
                                if (!this.multiSelect) continue;
                                this.multiSelectLeft();
                            }
                            while (this.highlightedNote > 0 && this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote - 1).getDeltaTime() == 0) {
                                --this.highlightedNote;
                                if (!this.multiSelect) continue;
                                this.multiSelectLeft();
                            }
                        }
                        this.updateDrawFromNoteLeft();
                    } else {
                        --this.highlightedNote;
                        if (this.multiSelect) {
                            this.multiSelectLeft();
                        }
                        deltaTimeToSubtract = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getDeltaTime();
                        this.updateHighlightedNoteLeft(deltaTimeToSubtract);
                        this.updateDrawFromNoteLeft();
                    }
                    if (!this.multiSelect) {
                        this.startMultiSelectIndex = this.highlightedNote;
                    }
                    if ((tempnote = this.drawFromNote - 1) >= 0 && this.theScore.getTrack(this.currentTrack).getNote(tempnote).getDeltaTime() == 0) {
                        while (tempnote >= 0 && this.theScore.getTrack(this.currentTrack).getNote(tempnote).getDeltaTime() == 0) {
                            --tempnote;
                        }
                        this.drawFromNote = ++tempnote;
                    }
                    System.out.println("drawFromTotaldt = " + this.drawFromTotalDeltaTime + " and dttosubtract = " + deltaTimeToSubtract + "...");
                    this.theScore.tempoTrack.setDeltaTime(this.drawFromTotalDeltaTime);
                    this.getCurrentTimeSig();
                    this.drawFromBarTicks = this.theScore.tempoTrack.getBarTicks();
                    this.drawFromBeatTicks = this.theScore.tempoTrack.getBeatTicks();
                    this.incrementFrom = this.drawFromBarTicks;
                    if (!this.singleSelect && !this.multiSelect) {
                        this.theScore.getTrack(this.currentTrack).deselectAllNotes(this.numSelectedNotes);
                        this.numSelectedNotes = 0;
                    }
                } else if (this.insertMode != 1 && this.insertMode == 2 && this.insertDT > this.theScore.getTicksPerCrotchet() / 8) {
                    boolean temptf = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getTieForwards();
                    byte originalPitch = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch();
                    tempDT = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getDeltaTime();
                    this.theScore.getTrack(this.currentTrack).deleteNote(this.highlightedNote, this.drawFromBarTicks);
                    this.theScore.getTrack(this.currentTrack).removeRestsDuringNote(this.drawFromNote, this.drawFromTotalDeltaTime);
                    if (this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch() == 0) {
                        this.theScore.getTrack(this.currentTrack).getNotes().removeElementAt(this.highlightedNote);
                    }
                    int tempBarTicks = this.drawFromBarTicks;
                    int tempIndex = this.highlightedNote;
                    block8: while (temptf) {
                        int duration = this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getDuration();
                        tempDT = 0;
                        while (tempDT < duration) {
                            tempDT += this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getDeltaTime();
                            tempBarTicks += this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getDeltaTime();
                            ++tempIndex;
                            tempBarTicks %= this.ticksPerBar;
                            this.theScore.tempoTrack.setDeltaTime(this.drawFromTotalDeltaTime);
                            this.getCurrentTimeSig();
                        }
                        while (tempDT == duration) {
                            if (this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getPitch() == originalPitch) {
                                temptf = this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getTieForwards();
                                int otherMoveBack = this.theScore.getTrack(this.currentTrack).removeNote(tempIndex, tempBarTicks);
                                tempDT -= otherMoveBack;
                                if (otherMoveBack != 0) continue block8;
                                --tempIndex;
                                continue block8;
                            }
                            ++tempIndex;
                        }
                    }
                    this.insertDT -= this.theScore.getTicksPerCrotchet() / 8;
                    int newDur = this.editNoteDuration;
                    if (this.drawFromBarTicks + this.insertDT + newDur > this.ticksPerBar) {
                        newDur = this.ticksPerBar - (this.drawFromBarTicks + this.insertDT);
                    }
                    Note toInsert = new Note(originalPitch, 112, 0, newDur);
                    this.highlightedNote = this.theScore.getTrack(this.currentTrack).insertNote(toInsert, this.drawFromTotalDeltaTime + this.insertDT);
                }
                if (this.insertMode == 2) {
                    Queue noteQueue = this.theScore.makeNoteDisplayable(this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote));
                    Note tempNote = (Note)noteQueue.dequeue();
                    this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setDuration(tempNote.getDuration());
                    this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setDeltaTime(tempNote.getDeltaTime());
                    if (!noteQueue.isEmpty()) {
                        this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setTieForwards(true);
                    }
                    tempDT = this.drawFromTotalDeltaTime + this.insertDT + tempNote.getDeltaTime();
                    while (!noteQueue.isEmpty()) {
                        tempNote = (Note)noteQueue.dequeue();
                        Note nn = new Note(tempNote.getPitch(), tempNote.getVelocity(), tempNote.getDeltaTime(), tempNote.getDuration());
                        nn.setTieBackwards(tempNote.getTieBackwards());
                        nn.setTieForwards(tempNote.getTieForwards());
                        this.theScore.getTrack(this.currentTrack).insertNote(nn, tempDT);
                        tempDT += tempNote.getDuration();
                    }
                    this.theScore.getTrack(this.currentTrack).removeRestsDuringNote(this.highlightedNote, this.drawFromTotalDeltaTime + this.insertDT);
                }
                if (this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch() > 0 && (this.theScore.mh.player == null || this.theScore.mh.player.getState() != 400)) {
                    Thread sampleNoteThread = new Thread(this.np);
                    this.np.stop = true;
                    this.np.pitch = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch();
                    sampleNoteThread.start();
                }
            }
        } else if ((keyCode == this.theScore.optionsCanvas.keyCodes[5] || keyCode == this.theScore.optionsCanvas.keyCodes[13]) && this.drawFromNote < this.theScore.getTrack(this.currentTrack).getSize() - 1) {
            System.out.println("\n\nat start of key code RIGHT...  dftdt = " + this.drawFromTotalDeltaTime + " ticksPerBar = " + this.ticksPerBar + "drawFromBarTicks = " + this.drawFromBarTicks + " and drawFromBeatTicks = " + this.drawFromBeatTicks);
            if (this.playing) {
                int newCurrentTrack = this.currentTrack + 1;
                if (newCurrentTrack == this.theScore.tracks.size()) {
                    newCurrentTrack = 0;
                }
                this.changeTrack(newCurrentTrack);
            } else {
                if (this.insertMode == 0) {
                    this.theScore.tempoTrack.setDeltaTime(this.highlightedNoteTotalDeltaTime);
                    this.getCurrentTimeSig();
                    this.highlightedNoteBarTicks = this.theScore.tempoTrack.getBarTicks();
                    System.out.println("read - ticksPerBar = " + this.ticksPerBar + " and drawFromTotalDeltaTime = " + this.drawFromTotalDeltaTime + " and highlightedNoteBarTicks = " + this.highlightedNoteBarTicks);
                    if (this.shift) {
                        int moved = 0;
                        while (this.highlightedNoteBarTicks + moved < this.ticksPerBar && this.highlightedNote < this.theScore.getTrack(this.currentTrack).getSize() - 1) {
                            int dt = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getDeltaTime();
                            moved += dt;
                            this.updateHighlightedNoteRight(dt);
                            if (this.multiSelect) {
                                this.multiSelectRight();
                            }
                            ++this.highlightedNote;
                        }
                        this.updateDrawFromNoteRight();
                    } else {
                        int dt = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getDeltaTime();
                        this.updateHighlightedNoteRight(dt);
                        this.updateDrawFromNoteRight();
                        if (this.multiSelect) {
                            this.multiSelectRight();
                        }
                        ++this.highlightedNote;
                    }
                    if (!this.multiSelect) {
                        this.startMultiSelectIndex = this.highlightedNote;
                    }
                    this.theScore.tempoTrack.setDeltaTime(this.drawFromTotalDeltaTime);
                    this.getCurrentTimeSig();
                    this.incrementFrom = this.drawFromBarTicks;
                    if (!this.singleSelect && !this.multiSelect) {
                        this.theScore.getTrack(this.currentTrack).deselectAllNotes(this.numSelectedNotes);
                        this.numSelectedNotes = 0;
                    }
                } else if (this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch() > 0) {
                    if (this.insertMode == 1) {
                        int newDur = this.editNoteDuration;
                        if (this.highlightedNoteBarTicks + newDur > this.highlightedNoteTicksPerBar) {
                            newDur = this.highlightedNoteTicksPerBar - this.highlightedNoteBarTicks;
                        }
                        Note toInsert = new Note(60, 112, 0, newDur);
                        this.theScore.getTrack(this.currentTrack).insertNote(toInsert, this.highlightedNoteTotalDeltaTime);
                        ++this.highlightedNote;
                    } else if (this.insertMode == 2) {
                        byte originalPitch = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch();
                        if (this.insertDT > 0) {
                            boolean temptf = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getTieForwards();
                            int tempDT = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getDeltaTime();
                            this.theScore.getTrack(this.currentTrack).deleteNote(this.highlightedNote, this.drawFromBarTicks);
                            this.theScore.getTrack(this.currentTrack).removeRestsDuringNote(this.drawFromNote, this.drawFromTotalDeltaTime);
                            if (this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch() == 0) {
                                this.theScore.getTrack(this.currentTrack).getNotes().removeElementAt(this.highlightedNote);
                            }
                            int tempBarTicks = this.drawFromBarTicks;
                            int tempIndex = this.highlightedNote;
                            block13: while (temptf) {
                                int duration = this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getDuration();
                                tempDT = 0;
                                while (tempDT < duration) {
                                    tempDT += this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getDeltaTime();
                                    tempBarTicks += this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getDeltaTime();
                                    ++tempIndex;
                                    tempBarTicks %= this.ticksPerBar;
                                    this.theScore.tempoTrack.setDeltaTime(this.drawFromTotalDeltaTime);
                                    this.getCurrentTimeSig();
                                }
                                while (tempDT == duration) {
                                    if (this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getPitch() == originalPitch) {
                                        temptf = this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getTieForwards();
                                        int otherMoveBack = this.theScore.getTrack(this.currentTrack).removeNote(tempIndex, tempBarTicks);
                                        tempDT -= otherMoveBack;
                                        if (otherMoveBack != 0) continue block13;
                                        --tempIndex;
                                        continue block13;
                                    }
                                    ++tempIndex;
                                }
                            }
                        }
                        int newDur = this.editNoteDuration;
                        if (this.drawFromBarTicks + this.theScore.getTicksPerCrotchet() / 8 <= this.drawFromTicksPerBar) {
                            this.insertDT += this.theScore.getTicksPerCrotchet() / 8;
                        }
                        if (this.drawFromBarTicks + this.insertDT + newDur > this.ticksPerBar) {
                            newDur = this.ticksPerBar - (this.drawFromBarTicks + this.insertDT);
                        }
                        Note toInsert = new Note(originalPitch, 112, 0, newDur);
                        this.highlightedNote = this.theScore.getTrack(this.currentTrack).insertNote(toInsert, this.drawFromTotalDeltaTime + this.insertDT);
                    }
                    if (this.insertMode == 1 || this.insertMode == 2) {
                        Queue noteQueue = this.theScore.makeNoteDisplayable(this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote));
                        Note tempNote = (Note)noteQueue.dequeue();
                        this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setDuration(tempNote.getDuration());
                        this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setDeltaTime(tempNote.getDeltaTime());
                        if (!noteQueue.isEmpty()) {
                            this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setTieForwards(true);
                        }
                        int tempDT = this.drawFromTotalDeltaTime + this.insertDT + tempNote.getDeltaTime();
                        while (!noteQueue.isEmpty()) {
                            try {
                                tempNote = (Note)noteQueue.dequeue();
                                Note nn = new Note(tempNote.getPitch(), tempNote.getVelocity(), tempNote.getDeltaTime(), tempNote.getDuration());
                                nn.setTieBackwards(tempNote.getTieBackwards());
                                nn.setTieForwards(tempNote.getTieForwards());
                                this.theScore.getTrack(this.currentTrack).insertNote(nn, tempDT);
                                tempDT += tempNote.getDuration();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        this.theScore.getTrack(this.currentTrack).removeRestsDuringNote(this.highlightedNote, this.drawFromTotalDeltaTime + this.insertDT);
                    }
                }
                if (this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch() > 0 && (this.theScore.mh.player == null || this.theScore.mh.player.getState() != 400)) {
                    Thread sampleNoteThread = new Thread(this.np);
                    this.np.stop = true;
                    this.np.pitch = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch();
                    sampleNoteThread.start();
                }
            }
        } else if (!(keyCode != this.theScore.optionsCanvas.keyCodes[1] && keyCode != this.theScore.optionsCanvas.keyCodes[14] || this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch() <= 0 || this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getTieBackwards() && !this.theScore.getTrack((int)this.currentTrack).getNote((int)this.highlightedNote).selected)) {
            int tempIndex;
            System.out.println("pitch up...");
            int incPitch = 0;
            if (this.shift) {
                incPitch = 12;
            } else if (!this.shift) {
                incPitch = 1;
            }
            if (this.numSelectedNotes > 0) {
                int checkSelected = 0;
                boolean doChange = true;
                int firstSelected = -1;
                for (tempIndex = 0; checkSelected < this.numSelectedNotes && tempIndex < this.theScore.getTrack(this.currentTrack).getSize(); ++tempIndex) {
                    if (!this.theScore.getTrack((int)this.currentTrack).getNote((int)tempIndex).selected) continue;
                    if (++checkSelected == 1) {
                        firstSelected = tempIndex;
                    }
                    if (this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getPitch() <= 0 || this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getPitch() + incPitch <= 127) continue;
                    doChange = false;
                }
                if (doChange) {
                    checkSelected = 0;
                    for (tempIndex = firstSelected; checkSelected < this.numSelectedNotes || tempIndex < this.theScore.getTrack(this.currentTrack).getSize(); ++tempIndex) {
                        if (!this.theScore.getTrack((int)this.currentTrack).getNote((int)tempIndex).selected) continue;
                        ++checkSelected;
                        if (this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getPitch() <= 0) continue;
                        this.theScore.getTrack(this.currentTrack).getNote(tempIndex).setPitch((byte)(this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getPitch() + incPitch));
                    }
                }
            }
            if (!this.theScore.getTrack((int)this.currentTrack).getNote((int)this.highlightedNote).selected) {
                byte originalPitch = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch();
                if (incPitch > 0) {
                    this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setPitch((byte)(this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch() + incPitch));
                    tempIndex = this.highlightedNote;
                    block19: while (this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getTieForwards()) {
                        int duration = this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getDuration();
                        int tempDT = 0;
                        while (tempDT < duration) {
                            tempDT += this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getDeltaTime();
                            ++tempIndex;
                        }
                        while (tempDT == duration) {
                            if (this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getPitch() == originalPitch) {
                                this.theScore.getTrack(this.currentTrack).getNote(tempIndex).setPitch((byte)(originalPitch + incPitch));
                                continue block19;
                            }
                            ++tempIndex;
                        }
                    }
                }
            }
            if (this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch() > 0 && (this.theScore.mh.player == null || this.theScore.mh.player.getState() != 400)) {
                Thread sampleNoteThread = new Thread(this.np);
                this.np.stop = true;
                this.np.pitch = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch();
                sampleNoteThread.start();
            }
        } else if (!(keyCode != this.theScore.optionsCanvas.keyCodes[7] && keyCode != this.theScore.optionsCanvas.keyCodes[15] || this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch() <= 1 || this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getTieBackwards())) {
            int tempIndex;
            System.out.println("pitch down");
            int incPitch = 0;
            if (this.shift) {
                incPitch = -12;
            } else if (!this.shift) {
                incPitch = -1;
            }
            if (this.numSelectedNotes > 0) {
                int checkSelected = 0;
                boolean doChange = true;
                int firstSelected = -1;
                for (tempIndex = 0; checkSelected < this.numSelectedNotes && tempIndex < this.theScore.getTrack(this.currentTrack).getSize(); ++tempIndex) {
                    if (!this.theScore.getTrack((int)this.currentTrack).getNote((int)tempIndex).selected) continue;
                    if (++checkSelected == 1) {
                        firstSelected = tempIndex;
                    }
                    if (this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getPitch() <= 0 || this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getPitch() + incPitch >= 1) continue;
                    doChange = false;
                }
                if (doChange) {
                    checkSelected = 0;
                    for (tempIndex = firstSelected; checkSelected < this.numSelectedNotes || tempIndex < this.theScore.getTrack(this.currentTrack).getSize(); ++tempIndex) {
                        if (!this.theScore.getTrack((int)this.currentTrack).getNote((int)tempIndex).selected) continue;
                        ++checkSelected;
                        if (this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getPitch() <= 0) continue;
                        this.theScore.getTrack(this.currentTrack).getNote(tempIndex).setPitch((byte)(this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getPitch() + incPitch));
                    }
                }
            }
            if (!this.theScore.getTrack((int)this.currentTrack).getNote((int)this.highlightedNote).selected) {
                byte originalPitch = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch();
                if (incPitch != 0) {
                    this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setPitch((byte)(this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch() + incPitch));
                    tempIndex = this.highlightedNote;
                    block24: while (this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getTieForwards()) {
                        int duration = this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getDuration();
                        int tempDT = 0;
                        while (tempDT < duration) {
                            tempDT += this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getDeltaTime();
                            ++tempIndex;
                        }
                        while (tempDT == duration) {
                            if (this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getPitch() == originalPitch) {
                                this.theScore.getTrack(this.currentTrack).getNote(tempIndex).setPitch((byte)(originalPitch + incPitch));
                                continue block24;
                            }
                            ++tempIndex;
                        }
                    }
                }
            }
            if (this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch() > 0 && (this.theScore.mh.player == null || this.theScore.mh.player.getState() != 400)) {
                Thread sampleNoteThread = new Thread(this.np);
                this.np.stop = true;
                this.np.pitch = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch();
                sampleNoteThread.start();
            }
        } else if (keyCode == this.theScore.optionsCanvas.keyCodes[9]) {
            this.theScore.tempoTrack.setDeltaTime(this.highlightedNoteTotalDeltaTime);
            this.theScore.keyPadCanvas.drawStandard(this.theScore.tempoTrack.getBarNumber());
        } else if (keyCode == this.theScore.optionsCanvas.keyCodes[10]) {
            if (this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch() == 0) {
                if (this.clef == 0) {
                    this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setPitch((byte)71);
                } else if (this.clef == 1) {
                    this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setPitch((byte)50);
                } else if (this.clef == 2) {
                    this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setPitch((byte)57);
                } else {
                    this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setPitch((byte)60);
                }
            } else if (!this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getTieBackwards()) {
                boolean temptf = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getTieForwards();
                byte originalPitch = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch();
                int originalDrawFromDT = this.drawFromTotalDeltaTime;
                int tempDT = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getDeltaTime();
                int moveBack = this.theScore.getTrack(this.currentTrack).removeNote(this.highlightedNote, this.drawFromBarTicks);
                int tempBarTicks = this.drawFromBarTicks;
                int tempIndex = 0;
                tempIndex = moveBack > 0 ? this.highlightedNote - 1 : this.highlightedNote;
                block27: while (temptf) {
                    int duration = this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getDuration();
                    tempDT = 0;
                    while (tempDT < duration) {
                        tempDT += this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getDeltaTime();
                        tempBarTicks += this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getDeltaTime();
                        ++tempIndex;
                        tempBarTicks %= this.ticksPerBar;
                        this.theScore.tempoTrack.setDeltaTime(this.drawFromTotalDeltaTime);
                        this.getCurrentTimeSig();
                    }
                    while (tempDT == duration) {
                        if (this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getPitch() == originalPitch) {
                            temptf = this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getTieForwards();
                            int otherMoveBack = this.theScore.getTrack(this.currentTrack).removeNote(tempIndex, tempBarTicks);
                            tempDT -= otherMoveBack;
                            if (otherMoveBack != 0) continue block27;
                            --tempIndex;
                            continue block27;
                        }
                        ++tempIndex;
                    }
                }
                this.drawFromTotalDeltaTime = originalDrawFromDT - moveBack;
                this.theScore.tempoTrack.setDeltaTime(this.drawFromTotalDeltaTime);
                this.getCurrentTimeSig();
                this.drawFromBarTicks -= moveBack;
                this.drawFromBeatTicks -= moveBack;
                this.drawFromBeatTicks += this.ticksPerBeat;
                this.drawFromBeatTicks %= this.ticksPerBeat;
                if (moveBack != 0) {
                    --this.highlightedNote;
                    this.drawFromNote = this.highlightedNote;
                }
            }
        } else if (keyCode == this.theScore.optionsCanvas.keyCodes[11]) {
            byte findPitch = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch();
            int tempIndex = this.highlightedNote + 1;
            int selDur = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getDuration();
            int searchdt = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getDeltaTime();
            if (findPitch > 0) {
                while (this.highlightedNote < this.theScore.getTrack(this.currentTrack).getSize() && searchdt <= selDur) {
                    if (this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getPitch() == findPitch) {
                        this.theScore.getTrack(this.currentTrack).getNote(tempIndex).setTieBackwards(!this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getTieForwards());
                        this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setTieForwards(!this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getTieForwards());
                        break;
                    }
                    searchdt += this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getDeltaTime();
                    ++tempIndex;
                }
            }
        }
        this.repaint();
    }

    public void getCurrentTimeSig() {
        this.timeSig = this.theScore.tempoTrack.getCurrentTimeSig();
        this.ticksPerBeat = this.timeSig.getTicksPerBeat(this.theScore.getTicksPerCrotchet());
        this.ticksPerBar = this.timeSig.getTicksPerBar(this.theScore.getTicksPerCrotchet());
    }

    public void drawTimeSig(Graphics g, int currentXPosition, int y) {
        g.drawString(String.valueOf(this.timeSig.getNumerator()), currentXPosition, y += this.noteSize * 2, 33);
        g.drawString(String.valueOf(this.timeSig.getDenominator()), currentXPosition, y, 17);
    }

    public int drawTrebleClef(Graphics g, int x, int y) {
        g.setColor(this.theScore.optionsCanvas.colourClefs[0], this.theScore.optionsCanvas.colourClefs[1], this.theScore.optionsCanvas.colourClefs[2]);
        g.drawArc(x += this.noteSize, y + this.noteSize * 2, (int)this.noteSize, this.noteSize * 2, 180, -180);
        g.drawArc(x - (int)((double)this.noteSize * 0.5), y + this.noteSize * 2, (int)((double)this.noteSize * 1.5), this.noteSize * 2, 0, -180);
        g.drawArc(x - (int)((double)this.noteSize * 0.5), y, this.noteSize * 3, this.noteSize * 6, 180, -90);
        g.drawArc(x + (int)((double)this.noteSize * 0.5), y - this.noteSize, (int)((double)this.noteSize * 0.5), (int)this.noteSize, 0, 360);
        g.drawLine(x + (int)((double)this.noteSize * 0.5), y, x + (int)((double)this.noteSize * 0.5), y + this.noteSize * 5);
        g.drawArc(x - (int)((double)this.noteSize * 0.5), (int)((double)y + 4.5 * (double)this.noteSize), (int)this.noteSize, (int)this.noteSize, 180, 180);
        g.fillArc((int)((double)x - 0.5 * (double)this.noteSize), (int)((double)y + (double)this.noteSize * 4.5), (int)((double)this.noteSize * 0.8), (int)((double)this.noteSize * 0.8), 0, 360);
        return x + this.noteSize * 2;
    }

    public int drawBassClef(Graphics g, int x, int y) {
        g.setColor(this.theScore.optionsCanvas.colourClefs[0], this.theScore.optionsCanvas.colourClefs[1], this.theScore.optionsCanvas.colourClefs[2]);
        g.fillArc(x, (int)((double)y + (double)this.noteSize * 0.5), (int)((double)this.noteSize * 0.8), (int)((double)this.noteSize * 0.8), 0, 360);
        g.drawArc(x, y, this.noteSize * 2, this.noteSize * 2, 180, -180);
        g.drawArc(x - this.noteSize * 2, y - this.noteSize, this.noteSize * 4, (int)((double)this.noteSize * 4.5), 0, -90);
        this.drawDot(g, x + this.noteSize, y + (int)(0.2 * (double)this.noteSize));
        this.drawDot(g, x + this.noteSize, y + (int)(1.2 * (double)this.noteSize));
        g.setColor(this.theScore.optionsCanvas.colourNotes[0], this.theScore.optionsCanvas.colourNotes[1], this.theScore.optionsCanvas.colourNotes[2]);
        return x + this.noteSize * 3;
    }

    public int drawCClef(Graphics g, int x, int y) {
        g.setColor(this.theScore.optionsCanvas.colourClefs[0], this.theScore.optionsCanvas.colourClefs[1], this.theScore.optionsCanvas.colourClefs[2]);
        g.fillRect(x - this.noteSize, y, (int)((double)this.noteSize * 0.5), this.noteSize * 4);
        g.drawLine(x, y, x, y + this.noteSize * 4);
        g.drawArc((int)((double)(x += (int)(0.5 * (double)this.noteSize)) - (double)this.noteSize * 0.5), y, (int)this.noteSize, (int)((double)this.noteSize * 1.5), -90, 180);
        g.fillArc((int)((double)x - (double)this.noteSize * 0.5), y, (int)((double)this.noteSize * 0.8), (int)((double)this.noteSize * 0.8), 0, 360);
        g.drawLine(x, (int)((double)y + (double)this.noteSize * 1.5), x, (int)((double)y + (double)this.noteSize * 2.5));
        g.drawArc((int)((double)x - (double)this.noteSize * 0.5), (int)((double)y + (double)this.noteSize * 2.5), (int)this.noteSize, (int)((double)this.noteSize * 1.5), -90, 180);
        g.fillArc((int)((double)x - (double)this.noteSize * 0.5), (int)((double)y + (double)this.noteSize * 3.2), (int)((double)this.noteSize * 0.8), (int)((double)this.noteSize * 0.8), 0, 360);
        g.setColor(this.theScore.optionsCanvas.colourNotes[0], this.theScore.optionsCanvas.colourNotes[1], this.theScore.optionsCanvas.colourNotes[2]);
        return x + this.noteSize * 2;
    }

    public void tiedNoteToggleSelection() {
        int tempIndex = this.highlightedNote;
        byte originalPitch = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getPitch();
        boolean setSelectedTo = this.theScore.getTrack((int)this.currentTrack).getNote((int)this.highlightedNote).selected;
        block0: while (this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getTieForwards()) {
            int duration = this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getDuration();
            int tempDT = 0;
            while (tempDT < duration) {
                tempDT += this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getDeltaTime();
                ++tempIndex;
            }
            while (tempDT == duration) {
                if (this.theScore.getTrack(this.currentTrack).getNote(tempIndex).getPitch() == originalPitch) {
                    if (this.theScore.getTrack((int)this.currentTrack).getNote((int)tempIndex).selected == setSelectedTo) continue block0;
                    this.numSelectedNotes = this.theScore.getTrack(this.currentTrack).getNote(tempIndex).toggleSelected(this.numSelectedNotes);
                    continue block0;
                }
                ++tempIndex;
            }
        }
    }

    public void multiSelectRight() {
        if (this.highlightedNote >= this.startMultiSelectIndex && !this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getTieBackwards()) {
            this.numSelectedNotes = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setSelected(this.numSelectedNotes);
            if (this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getTieForwards()) {
                this.tiedNoteToggleSelection();
            }
        } else if (this.highlightedNote < this.startMultiSelectIndex && !this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getTieBackwards()) {
            this.numSelectedNotes = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setDeselected(this.numSelectedNotes);
            if (this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getTieForwards()) {
                this.tiedNoteToggleSelection();
            }
        }
    }

    public void multiSelectLeft() {
        if (this.highlightedNote >= this.startMultiSelectIndex && !this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getTieBackwards()) {
            this.numSelectedNotes = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setDeselected(this.numSelectedNotes);
            if (this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getTieForwards()) {
                this.tiedNoteToggleSelection();
            }
        } else if (this.highlightedNote < this.startMultiSelectIndex && !this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getTieBackwards()) {
            this.numSelectedNotes = this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).setSelected(this.numSelectedNotes);
            if (this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getTieForwards()) {
                this.tiedNoteToggleSelection();
            }
        }
    }

    public void updateDrawFromNoteRight() {
        int moved = 0;
        this.theScore.tempoTrack.setDeltaTime(this.drawFromTotalDeltaTime);
        this.getCurrentTimeSig();
        while (this.highlightedNoteDistance > this.maxPixelsToHighlightedNote) {
            int noteDt = this.theScore.getTrack(this.currentTrack).getNote(this.drawFromNote).getDeltaTime();
            moved += noteDt;
            if (noteDt > 0) {
                this.highlightedNoteDistance -= (int)((double)this.noteSize * 1.25);
                for (int smallNote = this.ticksPerCrotchet / 32; smallNote < noteDt; smallNote *= 2) {
                    this.highlightedNoteDistance -= this.noteSize / 4;
                }
            }
            ++this.drawFromNote;
        }
        this.drawFromTotalDeltaTime += moved;
        this.theScore.tempoTrack.setDeltaTime(this.drawFromTotalDeltaTime);
        this.drawFromBarTicks = this.theScore.tempoTrack.getBarTicks();
        this.drawFromBeatTicks = this.theScore.tempoTrack.getBeatTicks();
    }

    public void updateDrawFromNoteLeft() {
        int moved = 0;
        this.theScore.tempoTrack.setDeltaTime(this.drawFromTotalDeltaTime);
        this.getCurrentTimeSig();
        while (this.drawFromNote > 0 && this.highlightedNoteDistance < this.maxPixelsToHighlightedNote - this.noteSize) {
            int noteDt = this.theScore.getTrack(this.currentTrack).getNote(this.drawFromNote - 1).getDeltaTime();
            moved -= noteDt;
            if (noteDt > 0) {
                this.highlightedNoteDistance += (int)((double)this.noteSize * 1.25);
                for (int smallNote = this.ticksPerCrotchet / 32; smallNote < noteDt; smallNote *= 2) {
                    this.highlightedNoteDistance += this.noteSize / 4;
                }
            }
            --this.drawFromNote;
        }
        this.drawFromTotalDeltaTime += moved;
        if (this.drawFromTotalDeltaTime == 0) {
            // empty if block
        }
        this.theScore.tempoTrack.setDeltaTime(this.drawFromTotalDeltaTime);
        this.drawFromBarTicks = this.theScore.tempoTrack.getBarTicks();
        this.drawFromBeatTicks = this.theScore.tempoTrack.getBeatTicks();
    }

    public void updateHighlightedNoteRight(int dt) {
        if (dt > 0) {
            this.highlightedNoteTotalDeltaTime += dt;
            this.highlightedNoteDistance += (int)((double)this.noteSize * 1.25);
            for (int smallNote = this.ticksPerCrotchet / 32; smallNote < dt; smallNote *= 2) {
                this.highlightedNoteDistance += this.noteSize / 4;
            }
        }
    }

    public void updateHighlightedNoteLeft(int dt) {
        if (dt > 0) {
            this.highlightedNoteTotalDeltaTime -= dt;
            this.highlightedNoteDistance -= (int)((double)this.noteSize * 1.25);
            for (int smallNote = this.ticksPerCrotchet / 32; smallNote < dt; smallNote *= 2) {
                this.highlightedNoteDistance -= this.noteSize / 4;
            }
        }
    }

    public void startScrolling() {
        this.currentTrackBeforePlay = this.currentTrack;
        this.highlightedNoteBeforePlay = this.highlightedNote;
        this.highlightedNoteTotalDeltaTimeBeforePlay = this.highlightedNoteTotalDeltaTime;
        this.drawFromNoteBeforePlay = this.drawFromNote;
        this.drawFromtTotalDeltaTimeBeforePlay = this.drawFromTotalDeltaTime;
        this.highlightedNoteDistanceBeforePlay = this.highlightedNoteDistance;
        this.threadTask = 0;
        this.playing = true;
        Thread t = new Thread(this);
        t.start();
    }

    public void stopScrolling() {
        this.playing = false;
    }

    public void gotoMarker(int marker) {
        if (this.playing) {
            this.pauseThread = 1;
            while (this.pauseThread != 2) {
            }
        }
        this.theScore.tempoTrack.getDTfromBar(this.theScore.markers[marker]);
        int barDT = this.theScore.dtAtEditME;
        if (this.highlightedNoteTotalDeltaTime < barDT) {
            while (this.highlightedNoteTotalDeltaTime < barDT) {
                this.updateHighlightedNoteRight(this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote).getDeltaTime());
                ++this.highlightedNote;
                if (this.highlightedNote != this.theScore.getTrack(this.currentTrack).getSize()) continue;
                for (int i = 0; i < 50; ++i) {
                    this.theScore.getTrack(this.currentTrack).addNote(new Note(0, 70, useful.theScore.getTicksPerCrotchet() / 2, useful.theScore.getTicksPerCrotchet() / 2));
                }
            }
            this.updateDrawFromNoteRight();
            this.repaint();
        } else if (this.highlightedNoteTotalDeltaTime > barDT) {
            while (this.highlightedNoteTotalDeltaTime > barDT) {
                this.updateHighlightedNoteLeft(this.theScore.getTrack(this.currentTrack).getNote(this.highlightedNote - 1).getDeltaTime());
                --this.highlightedNote;
            }
            this.updateDrawFromNoteLeft();
        }
        this.repaint();
        this.theScore.showDisplayable((Displayable)this);
        if (this.pauseThread == 2) {
            try {
                this.theScore.tempoTrack.setDeltaTime(barDT);
                System.out.println("Set media time = " + this.theScore.mh.player.setMediaTime(this.theScore.tempoTrack.mediaTime));
            }
            catch (Exception ex) {
                System.out.println("Exception setting media time " + ex.getMessage());
                ex.printStackTrace();
            }
            this.pauseThread = 0;
        }
    }

    public void run() {
        if (this.threadTask == 0) {
            int lastIterationDt = 0;
            this.lastIterationHighlightedNote = 0;
            System.out.println("in run, Thread task = 0");
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ie) {
                System.out.println(ie.toString());
            }
            this.drawFromTotalDeltaTime = 0;
            this.highlightedNoteTotalDeltaTime = 0;
            this.highlightedNoteDistance = 0;
            this.highlightedNote = 0;
            this.drawFromNote = 0;
            while (this.playing) {
                Player cfr_ignored_0 = this.theScore.mh.player;
                if (this.theScore.mh.player.getState() != 400) break;
                if (this.pauseThread == 1) {
                    this.pauseThread = (byte)2;
                    while (this.pauseThread != 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException ie) {
                            System.out.println(ie.toString());
                        }
                    }
                }
                this.mediaTime = this.theScore.mh.player.getMediaTime();
                this.highlightedNote = this.theScore.getTrack(this.currentTrack).getNoteFromMs(this.mediaTime);
                int dtDiff = this.theScore.getTrack((int)this.currentTrack).highlightedNoteDt - lastIterationDt;
                lastIterationDt = this.theScore.getTrack((int)this.currentTrack).highlightedNoteDt;
                for (int l = this.lastIterationHighlightedNote; l < this.highlightedNote; ++l) {
                    this.updateHighlightedNoteRight(this.theScore.getTrack(this.currentTrack).getNote(l).getDeltaTime());
                }
                if (dtDiff > 0) {
                    this.updateDrawFromNoteRight();
                    this.repaint();
                }
                this.lastIterationHighlightedNote = this.highlightedNote;
                try {
                    Thread.sleep(125L);
                }
                catch (InterruptedException ie) {
                    System.out.println(ie.toString());
                }
            }
            this.theScore.removeStop();
            this.playing = false;
            this.currentTrack = this.currentTrackBeforePlay;
            this.drawFromNote = this.drawFromNoteBeforePlay;
            this.drawFromTotalDeltaTime = this.drawFromtTotalDeltaTimeBeforePlay;
            this.highlightedNoteDistance = this.highlightedNoteDistanceBeforePlay;
            this.highlightedNote = this.highlightedNoteBeforePlay;
            this.highlightedNoteTotalDeltaTime = this.highlightedNoteTotalDeltaTimeBeforePlay;
            this.theScore.tempoTrack.setDeltaTime(this.drawFromTotalDeltaTime);
            this.getCurrentTimeSig();
            this.drawFromBarTicks = this.theScore.tempoTrack.getBarTicks();
            this.drawFromBeatTicks = this.theScore.tempoTrack.getBeatTicks();
            this.repaint();
        }
    }
}

