/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class TempoTrack {
    private Vector tempos = new Vector();
    private Vector timeSigs = new Vector();
    private Vector keySigs = new Vector();
    private Vector otherEvents = new Vector();
    public Vector metaEvents = new Vector();
    private int tempoPointer = 0;
    private int timeSigPointer = 0;
    private int keySigPointer = 0;
    private int otherEventPointer = 0;
    private int metaEventPointer = 0;
    private int lastDt = 0;
    private int deltaTimeSinceLastEvent = 0;
    private boolean keySigChanged;
    private boolean timeSigChanged;
    private boolean tempoChanged;
    private boolean otherEventChanged;
    private Score theScore;
    private int barNumber = 1;
    private int tep;
    private int tsp;
    private int ksp;
    private int oep;
    private int mep;
    public int lastSetDt;
    private int barTicks;
    private int beatTicks;
    private boolean loadedKeySig = false;
    private boolean loadedTimeSig = false;
    private boolean loadedTempo = false;
    public long mediaTime = 0L;

    public TempoTrack(Score theScore) {
        this.theScore = theScore;
    }

    public int getBarTicks() {
        return this.barTicks;
    }

    public int getBeatTicks() {
        return this.beatTicks;
    }

    public void addTempoEvent(TempoEvent te, int dt) {
        this.tempos.addElement(te);
        this.metaEvents.addElement(new MetaEvent(dt - this.lastDt, 81));
    }

    public void addTimeSigEvent(TimeSigEvent ti, int dt) {
        this.timeSigs.addElement(ti);
        this.metaEvents.addElement(new MetaEvent(dt - this.lastDt, 88));
    }

    public void addKeySigEvent(KeySigEvent ke, int dt) {
        this.keySigs.addElement(ke);
        this.metaEvents.addElement(new MetaEvent(dt - this.lastDt, 89));
    }

    public void getDTfromBar(int bar) {
        TimeSigEvent tempTS = (TimeSigEvent)this.timeSigs.elementAt(0);
        int tsPointer = -1;
        int totalDT = 0;
        int currentBar = 0;
        int remainder = 0;
        int dt = 0;
        --bar;
        for (int i = 0; i < this.metaEvents.size() && currentBar < bar; ++i) {
            dt = ((MetaEvent)this.metaEvents.elementAt(i)).getDeltaTime();
            totalDT += dt;
            int bit = dt % tempTS.getTicksPerBar(this.theScore.getTicksPerCrotchet());
            if ((remainder += bit) > tempTS.getTicksPerBar(this.theScore.getTicksPerCrotchet())) {
                ++currentBar;
                remainder -= tempTS.getTicksPerBar(this.theScore.getTicksPerCrotchet());
            }
            if ((currentBar += (dt -= bit) / tempTS.getTicksPerBar(this.theScore.getTicksPerCrotchet())) > bar || ((MetaEvent)this.metaEvents.elementAt(i)).getEventType() != 88) continue;
            tempTS = (TimeSigEvent)this.timeSigs.elementAt(++tsPointer);
        }
        if (currentBar < bar) {
            totalDT += (bar - currentBar) * tempTS.getTicksPerBar(this.theScore.getTicksPerCrotchet());
        } else if (currentBar > bar) {
            totalDT -= (currentBar - bar) * tempTS.getTicksPerBar(this.theScore.getTicksPerCrotchet());
        }
        this.theScore.dtAtEditME = totalDT;
        this.theScore.timeSigAtEditME = tempTS;
    }

    public void insertTempoEvent(TempoEvent toInsert, int dtAt) {
        int i;
        int tPointer = 0;
        int dt = 0;
        for (i = 0; i < this.metaEvents.size() && dt <= dtAt; ++i) {
            if (((MetaEvent)this.metaEvents.elementAt(i)).getEventType() != 81 || (dt += ((MetaEvent)this.metaEvents.elementAt(i)).getDeltaTime()) > dtAt) continue;
            ++tPointer;
        }
        int meDT = 0;
        if (dt > dtAt && i > 0) {
            int idt = ((MetaEvent)this.metaEvents.elementAt(i - 1)).getDeltaTime();
            meDT = dtAt - (dt - idt);
            ((MetaEvent)this.metaEvents.elementAt(i - 1)).setDeltaTime(dt - meDT);
        } else {
            meDT = dtAt - dt;
        }
        this.metaEvents.insertElementAt(new MetaEvent(meDT, 81), i);
        this.tempos.insertElementAt(toInsert, tPointer);
    }

    public void insertTimeSigEvent(TimeSigEvent toInsert, int dtAt) {
        int i;
        int tPointer = 0;
        int dt = 0;
        for (i = 0; i < this.metaEvents.size() && dt <= dtAt; ++i) {
            if (((MetaEvent)this.metaEvents.elementAt(i)).getEventType() != 88 || (dt += ((MetaEvent)this.metaEvents.elementAt(i)).getDeltaTime()) > dtAt) continue;
            ++tPointer;
        }
        int meDT = 0;
        if (dt > dtAt && i > 0) {
            int idt = ((MetaEvent)this.metaEvents.elementAt(i - 1)).getDeltaTime();
            meDT = dtAt - (dt - idt);
            ((MetaEvent)this.metaEvents.elementAt(i - 1)).setDeltaTime(dt - meDT);
        } else {
            meDT = dtAt - dt;
        }
        this.metaEvents.insertElementAt(new MetaEvent(meDT, 88), i);
        this.timeSigs.insertElementAt(toInsert, tPointer);
    }

    public void insertKeySigEvent(KeySigEvent toInsert, int dtAt) {
        int i;
        int tPointer = 0;
        int dt = 0;
        for (i = 0; i < this.metaEvents.size() && dt <= dtAt; ++i) {
            if (((MetaEvent)this.metaEvents.elementAt(i)).getEventType() != 89 || (dt += ((MetaEvent)this.metaEvents.elementAt(i)).getDeltaTime()) > dtAt) continue;
            ++tPointer;
        }
        int meDT = 0;
        if (dt > dtAt && i > 0) {
            int idt = ((MetaEvent)this.metaEvents.elementAt(i - 1)).getDeltaTime();
            meDT = dtAt - (dt - idt);
            ((MetaEvent)this.metaEvents.elementAt(i - 1)).setDeltaTime(dt - meDT);
        } else {
            meDT = dtAt - dt;
        }
        this.metaEvents.insertElementAt(new MetaEvent(meDT, 89), i);
        this.keySigs.insertElementAt(toInsert, tPointer);
    }

    public void addMetaEventFromBytes(int deltaTime, byte type, int length, byte[] data, byte[] vl) {
        System.out.println("addMetaEventFromBytes, dt = " + deltaTime + " type = " + type);
        this.metaEvents.addElement(new MetaEvent(deltaTime, type));
        if (type == 81) {
            this.loadedTempo = true;
            this.tempos.addElement(new TempoEvent(data));
        } else if (type == 88) {
            this.loadedTimeSig = true;
            this.timeSigs.addElement(new TimeSigEvent(data));
        } else if (type == 89) {
            this.loadedKeySig = true;
            this.keySigs.addElement(new KeySigEvent(data));
        } else {
            this.otherEvents.addElement(new OtherEvent(type, length, data, vl));
        }
    }

    public void setDeltaTime(int dt) {
        int dtPointer;
        this.lastSetDt = dt;
        int lastTimeSigDT = 0;
        this.deltaTimeSinceLastEvent = dt;
        this.tempoPointer = -1;
        this.timeSigPointer = -1;
        this.keySigPointer = -1;
        this.otherEventPointer = -1;
        this.barNumber = 1;
        int ticksPerBar = 0;
        int ticksPerBarRemainder = 0;
        int totalDT = 0;
        int dtOfLastTempo = 0;
        this.mediaTime = 0L;
        int ticksPerCrotchet = this.theScore.getTicksPerCrotchet();
        int msInTick = 0;
        this.keySigChanged = false;
        this.timeSigChanged = false;
        this.tempoChanged = false;
        this.otherEventChanged = false;
        int lastEventDeltaTime = 0;
        this.metaEventPointer = 0;
        MetaEvent me = (MetaEvent)this.metaEvents.elementAt(this.metaEventPointer);
        for (dtPointer = me.getDeltaTime(); dtPointer < dt; dtPointer += me.getDeltaTime()) {
            this.deltaTimeSinceLastEvent -= me.getDeltaTime();
            lastEventDeltaTime = me.getDeltaTime();
            totalDT += me.getDeltaTime();
            if (ticksPerBar > 0) {
                this.barNumber += (me.getDeltaTime() + ticksPerBarRemainder) / ticksPerBar;
                ticksPerBarRemainder = (me.getDeltaTime() + ticksPerBarRemainder) % ticksPerBar;
            }
            if (me.getEventType() == 81) {
                ++this.tempoPointer;
                if (this.tempoPointer > 0) {
                    this.mediaTime += (long)((dtPointer - dtOfLastTempo) * msInTick);
                }
                int tempo = this.getCurrentTempo().getTempo();
                msInTick = tempo / ticksPerCrotchet;
                dtOfLastTempo = dtPointer;
            } else if (me.getEventType() == 88) {
                ++this.timeSigPointer;
                lastTimeSigDT = dtPointer;
                TimeSigEvent ts = (TimeSigEvent)this.timeSigs.elementAt(this.timeSigPointer);
                ticksPerBar = ts.getTicksPerBar(this.theScore.getTicksPerCrotchet());
            } else if (me.getEventType() == 89) {
                ++this.keySigPointer;
            } else {
                ++this.otherEventPointer;
            }
            ++this.metaEventPointer;
            if (this.metaEventPointer >= this.metaEvents.size()) break;
            me = (MetaEvent)this.metaEvents.elementAt(this.metaEventPointer);
        }
        if (ticksPerBarRemainder > 0) {
            this.barNumber += ticksPerBarRemainder / ticksPerBar;
            totalDT += ticksPerBarRemainder;
        }
        if (dt > totalDT) {
            this.barNumber += (dt - totalDT) / ticksPerBar;
        }
        while (dtPointer == dt) {
            this.deltaTimeSinceLastEvent = 0;
            lastEventDeltaTime = me.getDeltaTime();
            if (me.getEventType() == 81) {
                ++this.tempoPointer;
                this.tempoChanged = true;
            } else if (me.getEventType() == 88) {
                ++this.timeSigPointer;
                this.timeSigChanged = true;
            } else if (me.getEventType() == 89) {
                ++this.keySigPointer;
                this.keySigChanged = true;
            } else {
                ++this.otherEventPointer;
            }
            ++this.metaEventPointer;
            if (this.metaEventPointer >= this.metaEvents.size()) break;
            me = (MetaEvent)this.metaEvents.elementAt(this.metaEventPointer);
            dtPointer += me.getDeltaTime();
        }
        this.theScore.keySigHandler.calculateInKey((KeySigEvent)this.keySigs.elementAt(this.keySigPointer));
        int dtRem = dt - lastTimeSigDT;
        TimeSigEvent ts = (TimeSigEvent)this.timeSigs.elementAt(this.timeSigPointer);
        ticksPerBar = ts.getTicksPerBar(this.theScore.getTicksPerCrotchet());
        int ticksPerBeat = ts.getTicksPerBeat(this.theScore.getTicksPerCrotchet());
        this.barTicks = dtRem % ticksPerBar;
        this.beatTicks = this.barTicks > 0 ? this.barTicks % ticksPerBeat : 0;
        this.mediaTime += (long)((dt - dtOfLastTempo) * msInTick);
    }

    public void incrementDeltaTime(int dt) {
        this.timeSigChanged = false;
        this.keySigChanged = false;
        this.lastSetDt += dt;
        if (this.metaEventPointer >= this.metaEvents.size()) {
            this.theScore.keySigHandler.calculateInKey((KeySigEvent)this.keySigs.elementAt(this.keySigPointer));
            this.deltaTimeSinceLastEvent += dt;
            return;
        }
        MetaEvent me = (MetaEvent)this.metaEvents.elementAt(this.metaEventPointer);
        this.deltaTimeSinceLastEvent += dt;
        while (this.deltaTimeSinceLastEvent >= me.getDeltaTime() && dt != 0) {
            if (me.getEventType() == 81) {
                ++this.tempoPointer;
                this.tempoChanged = true;
                System.out.println("tempo pointer inc...");
            } else if (me.getEventType() == 88) {
                ++this.timeSigPointer;
                this.timeSigChanged = true;
                System.out.println("time sig pointer inc");
            } else if (me.getEventType() == 89) {
                ++this.keySigPointer;
                this.theScore.keySigHandler.calculateInKey((KeySigEvent)this.keySigs.elementAt(this.keySigPointer));
                this.keySigChanged = true;
                System.out.println("key sig pointer inc");
            } else {
                ++this.otherEventPointer;
                this.otherEventChanged = true;
                System.out.println("other event pointer inc...");
            }
            ++this.metaEventPointer;
            if (this.metaEventPointer >= this.metaEvents.size()) break;
            this.deltaTimeSinceLastEvent -= me.getDeltaTime();
            me = (MetaEvent)this.metaEvents.elementAt(this.metaEventPointer);
        }
        this.theScore.keySigHandler.calculateInKey((KeySigEvent)this.keySigs.elementAt(this.keySigPointer));
    }

    public boolean hasTimeSigChanged() {
        boolean c = false;
        boolean temp = this.timeSigChanged;
        this.timeSigChanged = false;
        return temp;
    }

    public boolean hasKeySigChanged() {
        boolean temp = this.keySigChanged;
        this.keySigChanged = false;
        return temp;
    }

    public boolean hasTempoChanged() {
        boolean temp = this.tempoChanged;
        this.tempoChanged = false;
        return temp;
    }

    public TimeSigEvent getCurrentTimeSig() {
        return (TimeSigEvent)this.timeSigs.elementAt(this.timeSigPointer);
    }

    public KeySigEvent getCurrentKeySig() {
        return (KeySigEvent)this.keySigs.elementAt(this.keySigPointer);
    }

    public TempoEvent getCurrentTempo() {
        return (TempoEvent)this.tempos.elementAt(this.tempoPointer);
    }

    public byte[] getEventAsBytes(int num) {
        MetaEvent me;
        if (num >= this.metaEvents.size()) {
            return null;
        }
        this.tep = -1;
        this.tsp = -1;
        this.ksp = -1;
        this.oep = -1;
        this.mep = 0;
        this.mep = 0;
        while (this.mep <= num) {
            me = (MetaEvent)this.metaEvents.elementAt(this.mep);
            System.out.println("writing meta event, me.type = " + me.getEventType() + "\n");
            if (me.getEventType() == 81) {
                ++this.tep;
            } else if (me.getEventType() == 88) {
                ++this.tsp;
            } else if (me.getEventType() == 89) {
                ++this.ksp;
            } else {
                ++this.oep;
            }
            ++this.mep;
        }
        me = (MetaEvent)this.metaEvents.elementAt(num);
        if (me.getEventType() == 81) {
            return ((TempoEvent)this.tempos.elementAt(this.tep)).returnBytes();
        }
        if (me.getEventType() == 88) {
            return ((TimeSigEvent)this.timeSigs.elementAt(this.tsp)).returnBytes();
        }
        if (me.getEventType() == 89) {
            return ((KeySigEvent)this.keySigs.elementAt(this.ksp)).returnBytes();
        }
        return ((OtherEvent)this.otherEvents.elementAt(this.oep)).returnBytes();
    }

    public int getBarNumber() {
        return this.barNumber;
    }

    public void clearMetaEvents() {
        this.loadedKeySig = false;
        this.loadedTimeSig = false;
        this.loadedTempo = false;
        this.metaEvents.removeAllElements();
        this.keySigs.removeAllElements();
        this.timeSigs.removeAllElements();
        this.tempos.removeAllElements();
        this.otherEvents.removeAllElements();
    }

    public void checkMetaEventsLoaded() {
        if (!this.loadedKeySig) {
            this.addKeySigEvent(new KeySigEvent(0, 0), 0);
        }
        if (!this.loadedTempo) {
            TempoEvent te = new TempoEvent();
            te.setBPM(120);
            this.addTempoEvent(te, 0);
        }
        if (!this.loadedTimeSig) {
            this.addTimeSigEvent(new TimeSigEvent(4, 2), 0);
        }
    }

    public void populateMetaEventList() {
        this.theScore.metaEventList.deleteAll();
        System.out.println("metaevents size = " + this.metaEvents.size());
        int dt = 0;
        int ticksPerBar = 1;
        int ticksPerBeat = 1;
        int currentBar = 0;
        int currentBeat = 0;
        int currentBeatTicks = 0;
        int tsPointer = -1;
        int ksPointer = -1;
        int tPointer = -1;
        TimeSigEvent ts = (TimeSigEvent)this.timeSigs.elementAt(0);
        for (int i = 0; i < this.metaEvents.size(); ++i) {
            MetaEvent me = (MetaEvent)this.metaEvents.elementAt(i);
            dt = me.getDeltaTime();
            if (currentBeatTicks > 0) {
                if (dt >= ticksPerBeat - currentBeatTicks) {
                    dt -= ticksPerBeat - currentBeatTicks;
                    ++currentBeat;
                } else {
                    currentBeatTicks += dt;
                    dt = 0;
                }
            }
            while (currentBeat != 0 && dt > 0) {
                if (dt >= ticksPerBeat) {
                    dt -= ticksPerBeat;
                    if (++currentBeat != ts.getNumerator()) continue;
                    currentBeat = 0;
                    ++currentBar;
                    continue;
                }
                currentBeatTicks += dt;
                dt = 0;
            }
            int remainder = dt;
            if (dt >= ticksPerBar) {
                remainder = dt % ticksPerBar;
                currentBar += (dt -= remainder) / ticksPerBar;
            }
            if (remainder >= ticksPerBeat) {
                dt = remainder % ticksPerBeat;
                remainder -= dt;
                currentBeat += dt / ticksPerBeat;
            }
            currentBeatTicks = remainder;
            if (me.getEventType() == 81) {
                ++tPointer;
            } else if (me.getEventType() == 88) {
                ++tsPointer;
                ts = (TimeSigEvent)this.timeSigs.elementAt(this.timeSigPointer);
                ticksPerBar = ts.getTicksPerBar(this.theScore.getTicksPerCrotchet());
                ticksPerBeat = ts.getTicksPerBeat(this.theScore.getTicksPerCrotchet());
            } else if (me.getEventType() == 89) {
                ++ksPointer;
            }
            String eventTime = String.valueOf(currentBar + 1) + ":" + String.valueOf(currentBeat + 1) + "(" + String.valueOf(currentBeatTicks) + ")";
            if (me.getEventType() != this.theScore.metaEventMenuAction) continue;
            if (me.getEventType() == 81) {
                this.theScore.metaEventList.append(eventTime + " -- " + ((TempoEvent)this.tempos.elementAt(tPointer)).toString(), null);
                continue;
            }
            if (me.getEventType() == 88) {
                this.theScore.metaEventList.append(eventTime + " -- " + ((TimeSigEvent)this.timeSigs.elementAt(tsPointer)).toString(), null);
                continue;
            }
            if (me.getEventType() != 89) continue;
            this.theScore.metaEventList.append(eventTime + " -- " + ((KeySigEvent)this.keySigs.elementAt(ksPointer)).toString(), null);
        }
    }

    public void deleteMetaEvent() {
        int pointer = -1;
        for (int i = 0; i < this.metaEvents.size(); ++i) {
            MetaEvent me = (MetaEvent)this.metaEvents.elementAt(i);
            if (me.getEventType() != this.theScore.metaEventMenuAction || ++pointer != this.theScore.metaEventList.getSelectedIndex()) continue;
            int dt = me.getDeltaTime();
            this.metaEvents.removeElementAt(i);
            if (i < this.metaEvents.size()) {
                me = (MetaEvent)this.metaEvents.elementAt(i);
                me.setDeltaTime(me.getDeltaTime() + dt);
            }
            if (this.theScore.metaEventMenuAction == 81) {
                this.tempos.removeElementAt(pointer);
                break;
            }
            if (this.theScore.metaEventMenuAction == 88) {
                this.timeSigs.removeElementAt(pointer);
                break;
            }
            if (this.theScore.metaEventMenuAction != 89) break;
            this.keySigs.removeElementAt(pointer);
            break;
        }
    }

    public TempoEvent getTempo(int index) {
        return (TempoEvent)this.tempos.elementAt(index);
    }

    public KeySigEvent getKeySig(int index) {
        return (KeySigEvent)this.keySigs.elementAt(index);
    }

    public TimeSigEvent getTimeSig(int index) {
        return (TimeSigEvent)this.timeSigs.elementAt(index);
    }
}

